/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.configuration.settings.validator;

import com.ericsson.neptune.i18n.util.ServiceMessageBundleUtil;
import com.tandbergtv.neptune.configuration.settings.entity.SettingDefinition;
import com.tandbergtv.neptune.configuration.settings.validator.AbstractSettingValidator;
import com.tandbergtv.neptune.configuration.settings.validator.ValidationResult;
import java.io.File;

public class BasicFileSystemValidator
extends AbstractSettingValidator {
    @Override
    public ValidationResult validate(SettingDefinition setting, String value) {
        if (value == null || value.isEmpty()) {
            return this.getFailValidationResultWithLocalKey(setting, "needValidPath");
        }
        File directory = new File(value);
        if (!directory.isDirectory()) {
            return this.getFailValidationResultWithLocalKey(setting, "needValidPath");
        }
        if (!directory.canRead()) {
            String message = "{0}: " + value + ServiceMessageBundleUtil.getAdminLocaleValueWithoutArguments("directoryNotAccessible", defaultMessageBundle.getString("directoryNotAccessible"), this.getCurrentLocal());
            return this.getFailValidationResultWithMessage(setting, message);
        }
        if (!directory.canWrite()) {
            String message = "{0}: " + value + ServiceMessageBundleUtil.getAdminLocaleValueWithoutArguments("directoryPermissionError", defaultMessageBundle.getString("directoryPermissionError"), this.getCurrentLocal());
            return this.getFailValidationResultWithMessage(setting, message);
        }
        return this.getSuccessValidationResult();
    }
}

