/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.configuration.settings.validator;

import com.ericsson.neptune.i18n.I18nLocaleUtil;
import com.ericsson.neptune.i18n.util.ServiceMessageBundleUtil;
import com.tandbergtv.neptune.configuration.settings.entity.LocalizedString;
import com.tandbergtv.neptune.configuration.settings.entity.SettingDefinition;
import com.tandbergtv.neptune.configuration.settings.entity.SettingGroup;
import com.tandbergtv.neptune.configuration.settings.validator.GroupValidator;
import com.tandbergtv.neptune.configuration.settings.validator.ValidationResult;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;

public class SimpleSettingsValidator
implements GroupValidator {
    private static ResourceBundle defaultMessageBundle = ResourceBundle.getBundle("com.tandbergtv.neptune.configuration.settings.validator.ValidatorMessages");

    @Override
    public List<ValidationResult> validate(SettingGroup group, Map<String, String> values) {
        ArrayList<ValidationResult> errors = new ArrayList<ValidationResult>();
        HashSet<String> validSettings = new HashSet<String>(group.getSettings().size());
        for (SettingDefinition def : group.getSettings()) {
            validSettings.add(def.getName());
        }
        String currentLocale = I18nLocaleUtil.getThreadScopeLocaleValue();
        String displayName = ServiceMessageBundleUtil.getSettingsLocaleDiplayName(group.getPath(), group.getDisplayName().get(0).getValue(), currentLocale);
        for (String settingToBeSaved : values.keySet()) {
            String displaySettingToBeSaved = ServiceMessageBundleUtil.getSettingsLocaleDiplayName(group.getPath() + settingToBeSaved, settingToBeSaved, currentLocale);
            if (validSettings.contains(settingToBeSaved)) continue;
            ValidationResult result = new ValidationResult();
            ArrayList<List<LocalizedString>> params = new ArrayList<List<LocalizedString>>(2);
            ArrayList<LocalizedString> settingToBeInserted = new ArrayList<LocalizedString>(1);
            settingToBeInserted.add(new LocalizedString(displaySettingToBeSaved, currentLocale));
            params.add(settingToBeInserted);
            params.add(ServiceMessageBundleUtil.createLocalizedParam(displayName));
            String message = ServiceMessageBundleUtil.getAdminLocaleValue("settingsBelongError", defaultMessageBundle.getString("settingsBelongError"), currentLocale, settingToBeSaved, displayName);
            result.fail().addMessage(message, currentLocale, params);
            errors.add(result);
        }
        return errors;
    }
}

