/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.file;

import com.tandbergtv.neptune.file.Watcher;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class FolderMonitor
extends Thread
implements Closeable {
    private static Logger logger = Logger.getLogger(FolderMonitor.class);
    private static final WatchEvent.Kind<?>[] EVENTS_ALL = new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.OVERFLOW, StandardWatchEventKinds.ENTRY_DELETE};
    private List<Watcher> watchers;
    private WatchService watchService;
    private boolean isClosed = false;
    private Map<WatchKey, Watcher> watchKeyMap;
    private long interval = TimeUnit.SECONDS.toMillis(10L);

    public FolderMonitor(Watcher watcher) {
        this.watchers = new ArrayList<Watcher>(1);
        this.watchers.add(watcher);
    }

    public FolderMonitor(List<Watcher> watchers) {
        this.watchers = watchers;
    }

    private boolean register() {
        this.watchKeyMap = new HashMap<WatchKey, Watcher>(this.watchers.size());
        try {
            this.watchService = FileSystems.getDefault().newWatchService();
            for (Watcher watcher : this.watchers) {
                if (watcher.getDirectory().toFile().isDirectory()) {
                    WatchKey key = watcher.getDirectory().register(this.watchService, EVENTS_ALL);
                    this.watchKeyMap.put(key, watcher);
                    continue;
                }
                logger.error((Object)String.format("%s is not a valid directory", watcher.getDirectory().toString()));
            }
        }
        catch (IOException e) {
            logger.error((Object)"register directory to watchService failed", (Throwable)e);
            this.close();
            return false;
        }
        return true;
    }

    @Override
    public void close() {
        this.isClosed = true;
        try {
            if (this.watchService != null) {
                this.watchService.close();
            }
        }
        catch (IOException e) {
            logger.error((Object)"folder monitor closing on error", (Throwable)e);
        }
    }

    @Override
    public void run() {
        if (this.register()) {
            this.watch();
        }
    }

    private void watch() {
        long lastCheckFinishedFilesTime = 0L;
        while (!this.isClosed) {
            try {
                WatchKey watchKey = this.watchService.poll(this.interval, TimeUnit.MILLISECONDS);
                if (watchKey != null) {
                    TimeUnit.SECONDS.sleep(1L);
                }
                if (watchKey != null) {
                    Watcher watcher = this.watchKeyMap.get(watchKey);
                    List<WatchEvent<?>> watchEvents = watchKey.pollEvents();
                    ArrayList events = new ArrayList(watchEvents.size());
                    watchEvents.forEach(event -> {
                        if (event.kind() == StandardWatchEventKinds.OVERFLOW) {
                            watcher.onError((WatchEvent<?>)event, watcher.getDirectory());
                        } else {
                            File file = ((Path)event.context()).toFile();
                            if (watcher.getFilter() == null || watcher.getFilter().accept(file)) {
                                events.add((WatchEvent<?>)event);
                            }
                        }
                    });
                    watcher.cacheUnFinishedFile(events);
                    watchKey.reset();
                }
                if (System.currentTimeMillis() - lastCheckFinishedFilesTime < this.interval) continue;
                lastCheckFinishedFilesTime = System.currentTimeMillis();
                for (Watcher watcher : this.watchers) {
                    watcher.checkFileStatus();
                }
            }
            catch (InterruptedException | ClosedWatchServiceException e) {
                logger.error((Object)"folder monitor exiting on error", (Throwable)e);
                break;
            }
            catch (Exception e) {
                logger.error((Object)"folder monitor processing on error", (Throwable)e);
            }
        }
        this.close();
    }

    public FolderMonitor setInterval(int seconds) {
        if (seconds > 0) {
            this.interval = TimeUnit.SECONDS.toMillis(seconds);
        }
        return this;
    }

    public static class Event {
        private List<File> createdFiles;
        private List<File> deletedFiles;
        private List<File> modifiedFiles;
        private Path directory;

        public Event(List<File> createdFiles, List<File> deletedFiles, List<File> modifiedFiles, Path directory) {
            this.createdFiles = createdFiles;
            this.deletedFiles = deletedFiles;
            this.modifiedFiles = modifiedFiles;
            this.directory = directory;
        }

        public List<File> getCreatedFiles() {
            return this.createdFiles;
        }

        public List<File> getDeletedFiles() {
            return this.deletedFiles;
        }

        public List<File> getModifiedFiles() {
            return this.modifiedFiles;
        }

        public Path getDirectory() {
            return this.directory;
        }
    }
}

