/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.file;

import com.tandbergtv.neptune.file.FolderMonitor;
import java.io.File;
import java.io.FileFilter;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class Watcher {
    protected Logger logger = Logger.getLogger(FolderMonitor.class);
    private Path directory;
    private FileFilter filter;
    private long interval = TimeUnit.SECONDS.toMillis(10L);
    private Map<Path, WatchEvent<?>> unFinishedFiles = new HashMap();

    public Watcher(Path directory, FileFilter filter) {
        this.directory = directory;
        this.filter = filter;
    }

    public Watcher(String directory, FileFilter filter) {
        this.directory = new File(directory).toPath();
        this.filter = filter;
    }

    public Path getDirectory() {
        return this.directory;
    }

    public FileFilter getFilter() {
        return this.filter;
    }

    public void onFileChanged(FolderMonitor.Event event) {
    }

    public void onFolderContentsChanged(Path directory) {
    }

    public void onError(WatchEvent<?> even, Path directory) {
        this.logger.error((Object)String.format("FolderMonitor[%s] context[%s] occur error", directory.toString(), even.context()));
    }

    public void cacheUnFinishedFile(List<WatchEvent<?>> fileEvents) {
        for (WatchEvent<?> event : fileEvents) {
            this.unFinishedFiles.put((Path)event.context(), event);
        }
    }

    private List<WatchEvent<?>> getFinishedFiles() {
        ArrayList finishedFiles = new ArrayList(this.unFinishedFiles.size());
        Iterator<WatchEvent<?>> it = this.unFinishedFiles.values().iterator();
        long now = System.currentTimeMillis();
        while (it.hasNext()) {
            WatchEvent<?> event = it.next();
            if (event.kind() == StandardWatchEventKinds.ENTRY_DELETE) {
                it.remove();
                finishedFiles.add(event);
                continue;
            }
            File file = this.getFile(event.context());
            long fileLastModifiedTime = file.lastModified();
            if (fileLastModifiedTime == 0L || now - file.lastModified() < this.interval) continue;
            it.remove();
            finishedFiles.add(event);
        }
        return finishedFiles;
    }

    private File getFile(Object fileName) {
        return Paths.get(this.directory.toString(), fileName.toString()).toFile();
    }

    public void checkFileStatus() {
        List<WatchEvent<?>> finishedFiles = this.getFinishedFiles();
        if (finishedFiles.size() == 0) {
            return;
        }
        ArrayList<File> createdFiles = new ArrayList<File>(finishedFiles.size());
        ArrayList<File> deletedFiles = new ArrayList<File>(finishedFiles.size());
        ArrayList<File> modifiedFiles = new ArrayList<File>(finishedFiles.size());
        for (WatchEvent<?> event : finishedFiles) {
            File file = this.getFile(event.context());
            if (event.kind() == StandardWatchEventKinds.ENTRY_CREATE) {
                createdFiles.add(file);
                continue;
            }
            if (event.kind() == StandardWatchEventKinds.ENTRY_MODIFY) {
                modifiedFiles.add(file);
                continue;
            }
            if (event.kind() != StandardWatchEventKinds.ENTRY_DELETE) continue;
            deletedFiles.add(file);
        }
        if (createdFiles.size() > 0 || modifiedFiles.size() > 0 || deletedFiles.size() > 0) {
            this.onFileChanged(new FolderMonitor.Event(createdFiles, deletedFiles, modifiedFiles, this.directory));
            if (this.unFinishedFiles.size() == 0) {
                this.onFolderContentsChanged(this.directory);
            }
        }
    }

    public void setInterval(int seconds) {
        if (this.interval > 0L) {
            this.interval = TimeUnit.SECONDS.toMillis(seconds);
        }
    }
}

