/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import java.io.IOException;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.log4j.Logger;

public class EnvironmentUtil {
    private static final Logger LOGGER = Logger.getLogger(EnvironmentUtil.class);
    private static final String ENVIRONMENT_NAME_DATA_CENTERS_URL = "http://app:8501/v1/catalog/service/cms";
    private static final String ENVIRONMENT_NAME_SETTING_PATH = "com.ericsson.cms.neptune.environment.settings";
    private static final String ENVIRONMENT_NAME_DISPALY_TEXT = "environmentNameDispalyText";
    private static final String ENVIRONMENT_NAME_DISPALY = "dispalyEnvironmentName";
    private static final String ENVIRONMENT_NAME_DATACENTER = "\"Datacenter\":\"(.*?)\"";
    private static final String ENVIRONMENT_NAME_EMPTY = "";
    private static final String PREPACK_SETTING_PATH = "com.ericsson.cms.neptune.prepack";
    private static final String PRODUCT_NAME = "productName";
    private static final String PRODUCT_VERSION = "productVersion";
    private boolean dispalyEnvironmentName = false;
    private final HttpClient httpClient = new HttpClient();
    private final ObjectMapper objectMapper = new ObjectMapper();

    private EnvironmentUtil() {
    }

    public static String getEnvironmentNameSettingPath() {
        return ENVIRONMENT_NAME_SETTING_PATH;
    }

    public static String getPrepackSettingPath() {
        return PREPACK_SETTING_PATH;
    }

    public static String getProductName() {
        return PRODUCT_NAME;
    }

    public static String getProductVersion() {
        return PRODUCT_VERSION;
    }

    public static EnvironmentUtil getEnvironmentUtil() {
        return EnvironmentUtilHolder.environmentUtil;
    }

    public static String getProductFeildValue(String json, String productFeild) {
        return EnvironmentUtil.getEnvironmentUtil().loadProductFeildValue(json, productFeild);
    }

    public String loadProductFeildValue(String json, String productFeild) {
        String productFeildValue = ENVIRONMENT_NAME_EMPTY;
        if (Strings.isNullOrEmpty((String)json)) {
            return productFeildValue;
        }
        try {
            Map settings = (Map)this.objectMapper.readValue(json, Map.class);
            if (settings == null || settings.isEmpty()) {
                LOGGER.debug((Object)(productFeild + " read setting fail."));
                return productFeildValue;
            }
            return (String)settings.get(productFeild);
        }
        catch (IOException e) {
            LOGGER.error((Object)("error when fetching " + productFeild + ENVIRONMENT_NAME_EMPTY), (Throwable)e);
            return productFeildValue;
        }
    }

    public static String getEnvironmentName(String json) {
        return EnvironmentUtil.getEnvironmentUtil().loadEnvironmentName(json);
    }

    public String loadEnvironmentName(String json) {
        String environmentNameText = ENVIRONMENT_NAME_EMPTY;
        this.dispalyEnvironmentName = false;
        environmentNameText = this.readEnvironmentNameFromSetting(json);
        if (!this.dispalyEnvironmentName) {
            return ENVIRONMENT_NAME_EMPTY;
        }
        if (Strings.isNullOrEmpty((String)environmentNameText)) {
            environmentNameText = this.getEnvironmentNameFromDataCenters();
        }
        return environmentNameText;
    }

    private String readEnvironmentNameFromSetting(String json) {
        if (Strings.isNullOrEmpty((String)json)) {
            return ENVIRONMENT_NAME_EMPTY;
        }
        try {
            Map settings = (Map)this.objectMapper.readValue(json, Map.class);
            if (settings == null || settings.isEmpty()) {
                LOGGER.debug((Object)"loadEnvironmentName read setting fail.");
                return ENVIRONMENT_NAME_EMPTY;
            }
            String isShowEnvironmentName = (String)settings.get(ENVIRONMENT_NAME_DISPALY);
            if (!Boolean.parseBoolean(isShowEnvironmentName)) {
                return ENVIRONMENT_NAME_EMPTY;
            }
            this.dispalyEnvironmentName = true;
            return (String)settings.get(ENVIRONMENT_NAME_DISPALY_TEXT);
        }
        catch (IOException e) {
            LOGGER.error((Object)"error when fetching environment Name", (Throwable)e);
            return ENVIRONMENT_NAME_EMPTY;
        }
    }

    private String getEnvironmentNameFromDataCenters() {
        GetMethod get = new GetMethod(ENVIRONMENT_NAME_DATA_CENTERS_URL);
        String userResponse = this.sendHttpMethod((HttpMethodBase)get);
        if (Strings.isNullOrEmpty((String)userResponse)) {
            return ENVIRONMENT_NAME_EMPTY;
        }
        return this.getDataCenterFromString(userResponse);
    }

    private String getDataCenterFromString(String text) {
        Pattern pattern = Pattern.compile(ENVIRONMENT_NAME_DATACENTER);
        Matcher matcher = pattern.matcher(text);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return ENVIRONMENT_NAME_EMPTY;
    }

    private String sendHttpMethod(HttpMethodBase method) {
        try {
            int responseCode = this.httpClient.executeMethod((HttpMethod)method);
            String responseBody = method.getResponseBodyAsString();
            if (responseCode == 200) {
                return responseBody;
            }
            LOGGER.error((Object)("HTTP request returned unexpected response. Response Code: " + responseCode + ", Message: " + responseBody));
        }
        catch (Exception e) {
            LOGGER.error((Object)"An exception was thrown while sending the HTTP request", (Throwable)e);
        }
        return ENVIRONMENT_NAME_EMPTY;
    }

    private static class EnvironmentUtilHolder {
        private static EnvironmentUtil environmentUtil = new EnvironmentUtil();

        private EnvironmentUtilHolder() {
        }
    }
}

