/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.springframework.amqp.core.Declarable;
import org.springframework.util.Assert;

public abstract class AbstractDeclarable
implements Declarable {
    private volatile boolean shouldDeclare = true;
    private volatile Collection<Object> declaringAdmins = new ArrayList<Object>();
    private boolean ignoreDeclarationExceptions;

    @Override
    public boolean shouldDeclare() {
        return this.shouldDeclare;
    }

    public void setShouldDeclare(boolean shouldDeclare) {
        this.shouldDeclare = shouldDeclare;
    }

    @Override
    public Collection<?> getDeclaringAdmins() {
        return Collections.unmodifiableCollection(this.declaringAdmins);
    }

    @Override
    public boolean isIgnoreDeclarationExceptions() {
        return this.ignoreDeclarationExceptions;
    }

    public void setIgnoreDeclarationExceptions(boolean ignoreDeclarationExceptions) {
        this.ignoreDeclarationExceptions = ignoreDeclarationExceptions;
    }

    public void setAdminsThatShouldDeclare(Object ... adminArgs) {
        ArrayList<Object> admins = new ArrayList<Object>();
        if (adminArgs != null) {
            if (adminArgs.length > 1) {
                Assert.noNullElements((Object[])adminArgs, (String)"'admins' cannot contain null elements");
            }
            if (adminArgs.length > 0 && (adminArgs.length != 1 || adminArgs[0] != null)) {
                admins.addAll(Arrays.asList(adminArgs));
            }
        }
        this.declaringAdmins = admins;
    }
}

