/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.metadata.search.utils;

import com.tandbergtv.metadatamanager.assetkey.AssetKeyHandler;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.util.XmlUtil;
import com.tandbergtv.metadatamanager.util.binder.ECMFBinder;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class DbDocHandler {
    Connection con;
    static String GET_DOC_SQL = "SELECT XMLSERIALIZE(content x.document as text ) FROM mdm_metadata x WHERE x.document_id in ";
    private static final Logger logger = Logger.getLogger(DbDocHandler.class);

    public DbDocHandler(Connection con) {
        this.con = con;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Document> queryDoc(List<Long> documentIds) throws SQLException {
        StringBuilder sb = new StringBuilder();
        sb.append(GET_DOC_SQL);
        sb.append("(");
        boolean isFirst = true;
        for (Long id : documentIds) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(",");
            }
            sb.append(id);
        }
        sb.append(")");
        Document doc = null;
        Statement st = null;
        ResultSet rs = null;
        DocumentBuilder builder = null;
        ArrayList<Document> docs = new ArrayList<Document>();
        try {
            String sql = sb.toString();
            st = this.con.prepareStatement(sql);
            rs = st.executeQuery();
            builder = XmlUtil.borrowDocumentBuilder();
            ResultSetMetaData metadata = rs.getMetaData();
            int columnType = metadata.getColumnType(1);
            while (rs.next()) {
                Reader r = null;
                Clob c = null;
                if (columnType == 2005) {
                    c = rs.getClob(1);
                    r = c.getCharacterStream();
                } else {
                    r = new StringReader(rs.getString(1));
                }
                doc = builder.parse(new InputSource(r));
                docs.add(doc);
                if (c != null) {
                    c.free();
                }
                if (r == null) continue;
                r.close();
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            st.close();
        }
        return docs;
    }

    public static void main(String[] args) throws Exception {
        String url = "jdbc:postgresql://10.116.49.55:5444/WPD12";
        String user = "wfs";
        String pwd = "Wf$1234";
        Connection con = DriverManager.getConnection(url, user, pwd);
        DbDocHandler test = new DbDocHandler(con);
        Long docId = 621L;
        ArrayList<Long> docIds = new ArrayList<Long>();
        docIds.add(621L);
        docIds.add(616L);
        List<Document> docs = test.queryDoc(docIds);
        if (docs != null) {
            List rootAssets = new ECMFBinder().bind(docs.get(0));
            Asset rootAsset = (Asset)rootAssets.get(0);
            Map updData = AssetKeyHandler.getDataForUpdate((Asset)rootAsset);
            Set assets = updData.keySet();
            for (Asset a : assets) {
                System.out.println("Asset ID=" + a.getId() + " json=" + (String)updData.get(a));
            }
        } else {
            System.out.println("No document found for " + docId);
        }
    }
}

