/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.metadata.search.utils;

import com.tandbergtv.metadatamanager.conf.SpecificationBuilder;
import com.tandbergtv.metadatamanager.factoryImpl.SpecHandlerFactory;
import com.tandbergtv.metadatamanager.spec.ISpecHandler;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.java.plugin.PluginClassLoader;
import org.java.plugin.PluginManager;
import org.java.plugin.registry.Extension;
import org.java.plugin.registry.ExtensionPoint;
import org.java.plugin.registry.PluginDescriptor;
import org.java.plugin.registry.PluginRegistry;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;

public class SlimSpecBuilder {
    private static final Logger logger = Logger.getLogger(SpecificationBuilder.class);
    private static final String PLUGIN_ID = "com.tandbergtv.metadata";
    private static final String EXTENSION_POINT_ID = "specification";
    private PluginManager pluginManager = null;
    protected ISpecHandler specHandler;
    protected Map<String, ISpecHandler> specHandlerMap;
    protected Map<String, URL> identifierMappingResourceMap;
    private ApplicationContext context;

    public SlimSpecBuilder(PluginManager pluginManager, ApplicationContext context) {
        this.pluginManager = pluginManager;
        this.context = context;
        this.specHandlerMap = new HashMap<String, ISpecHandler>();
        this.identifierMappingResourceMap = new HashMap<String, URL>();
    }

    public void buildSpecifications() {
        logger.info((Object)"Building Specifications");
        PluginRegistry pluginRegistry = this.pluginManager.getRegistry();
        ExtensionPoint point = pluginRegistry.getExtensionPoint(PLUGIN_ID, EXTENSION_POINT_ID);
        Collection extensions = point.getAvailableExtensions();
        for (Extension extension : extensions) {
            String specSpecificTTVXpathsFileName;
            String mappingResource;
            PluginDescriptor descriptor = extension.getDeclaringPluginDescriptor();
            PluginClassLoader classLoader = this.pluginManager.getPluginClassLoader(descriptor);
            String alias = extension.getParameter("alias").valueAsString();
            if (alias == null || alias.equals("")) {
                throw new RuntimeException("Alias Not Specified!");
            }
            String contextFile = extension.getParameter("spechandler").valueAsString();
            URL url1 = classLoader.getResource(contextFile);
            String path = url1.getPath();
            path = "file:" + path;
            FileSystemXmlApplicationContext jpfContext = new FileSystemXmlApplicationContext(this.context);
            jpfContext.setConfigLocation(path);
            jpfContext.setClassLoader((ClassLoader)classLoader);
            jpfContext.refresh();
            this.specHandler = (ISpecHandler)jpfContext.getBean(alias);
            this.specHandler.setAlias(alias);
            Extension.Parameter param = extension.getParameter("mappingResource");
            if (param != null && (mappingResource = param.valueAsString()) != null && !mappingResource.equals("")) {
                URL url = classLoader.getResource(mappingResource);
                this.specHandler.setMappingResourceUrl(url);
                this.identifierMappingResourceMap.put(alias, url);
            }
            if ((param = extension.getParameter("specSpecificTTVXpathsFileName")) != null && (specSpecificTTVXpathsFileName = param.valueAsString()) != null && !specSpecificTTVXpathsFileName.equals("")) {
                InputStream specSpecificTTVXpathsFileNameStream = classLoader.getResourceAsStream(specSpecificTTVXpathsFileName);
                this.specHandler.setSpecSpecificTTVXpathsStream(specSpecificTTVXpathsFileNameStream);
            }
            this.specHandlerMap.put(alias, this.specHandler);
        }
        this.context.getBean("specHandlerFactory");
        SpecHandlerFactory.getHandlers().putAll(this.specHandlerMap);
        logger.info((Object)"Finished building Specifications");
    }
}

