/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.utils.title;

import com.ericsson.utils.title.PersistenceUtil;
import com.ericsson.utils.title.PropertiesUtil;
import com.ericsson.utils.title.TimeMetrics;
import com.tandbergtv.watchpoint.pmm.dao.hibernate.HibernateContext;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.Transaction;

public class ResyncElasticSearchTitlesApp {
    private static final String[] SPRING_CONTEXT_CONFIG = new String[]{"com/tandbergtv/cms/search/utils/SyncHibernateContext.xml"};
    private String fileName;
    private int numFailedTitles = 0;
    private int numToAbort;
    private RandomAccessFile statusFile;
    private String connectionUrl;

    public ResyncElasticSearchTitlesApp(String fileName, String url, String dbPort) {
        this.fileName = fileName;
        if (url != null) {
            this.connectionUrl = "jdbc:postgresql://" + url + ":" + dbPort + "/ttv";
        }
        this.init();
    }

    private void init() {
        try {
            if (this.connectionUrl != null) {
                System.setProperty("jdbc.connectionUrl", this.connectionUrl);
            }
            PersistenceUtil.initializeContext(SPRING_CONTEXT_CONFIG);
            this.numToAbort = ResyncElasticSearchTitlesApp.getNumberToAbort();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public void close() {
        if (this.statusFile != null) {
            try {
                this.statusFile.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        PersistenceUtil.closeContext();
    }

    public boolean processTitleIds() throws Exception {
        String line;
        TimeMetrics tm = new TimeMetrics();
        String statusFileName = this.fileName + ".stat";
        this.statusFile = new RandomAccessFile(statusFileName, "rw");
        List<Object> prevFailedTitleIds = new ArrayList();
        String failedTitlesFileName = this.fileName + ".failed";
        File failedTitlesFile = new File(failedTitlesFileName);
        if (failedTitlesFile.exists()) {
            prevFailedTitleIds = this.getPreviousFailedTitleIds(failedTitlesFileName);
            failedTitlesFile.delete();
        }
        FileWriter writer = new FileWriter(failedTitlesFile);
        BufferedReader reader = new BufferedReader(new FileReader(this.fileName));
        long lineCount = 0L;
        if (this.statusFile.length() != 0L) {
            System.out.println("Trying to recover...");
            this.statusFile.seek(0L);
            String lastProcessedId = this.statusFile.readUTF();
            if (lastProcessedId.contains("FINISH")) {
                System.out.println(this.fileName + " already finished.");
                reader.close();
                writer.close();
                return true;
            }
            System.out.println("Last processed title id = " + lastProcessedId);
            long count = 0L;
            while ((line = reader.readLine()) != null) {
                ++count;
                if (lastProcessedId.equals(line)) {
                    System.out.println("Skipped " + count + " title IDs.");
                    break;
                }
                if (!prevFailedTitleIds.contains(line)) continue;
                System.out.println("Processing previous failed titleID = " + line);
                this.processLine(line, tm, writer);
                if (this.numFailedTitles <= this.numToAbort) continue;
                System.out.println("Aborting - too many failures.");
                reader.close();
                writer.close();
                return false;
            }
        }
        long t1 = System.currentTimeMillis();
        while ((line = reader.readLine()) != null) {
            if ((line = line.trim()).length() < 1) continue;
            System.out.println("Processing titleID = " + line);
            this.processLine(line, tm, writer);
            if (++lineCount % 100L == 0L) {
                this.printProgress(lineCount, t1, tm);
            }
            if (this.numFailedTitles <= this.numToAbort) continue;
            System.out.println("Aborting - too many failures.");
            reader.close();
            writer.close();
            return false;
        }
        this.printProgress(lineCount, t1, tm);
        reader.close();
        this.statusFile.seek(0L);
        this.statusFile.writeUTF("FINISH");
        writer.close();
        if (this.numFailedTitles == 0) {
            failedTitlesFile.delete();
        }
        return true;
    }

    private void printProgress(long count, long totalTime, TimeMetrics tm) {
        long t2 = System.currentTimeMillis();
        long timeSec = (t2 - totalTime) / 1000L;
        int min = (int)(timeSec / 60L);
        int sec = (int)(timeSec - (long)(min * 60));
        if (tm.count != 0) {
            System.out.println("Count = " + count + ", time = " + min + " min " + sec + " sec, DB = " + tm.db / (long)tm.count + " ms, ES = " + tm.es / (long)tm.count + " ms");
        }
        tm.clear();
    }

    public void saveTitleIds(int numFiles, int batchSize, Date fromDate) {
        System.out.println("Saving title IDs for " + numFiles + " concurrent threads...");
        long t1 = System.currentTimeMillis();
        PersistenceUtil.saveTitleIds(numFiles, batchSize, fromDate);
        long t2 = System.currentTimeMillis();
        System.out.println("Done in " + (t2 - t1) + " ms.");
    }

    private boolean processLine(String line, TimeMetrics tm, FileWriter writer) throws Exception {
        long titleId = 0L;
        try {
            titleId = Long.parseLong(line);
        }
        catch (Exception ex) {
            System.out.println("Could not parse titleID = " + line);
            return false;
        }
        boolean titleSaved = false;
        try {
            titleSaved = this.processTitle(titleId, tm);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (!titleSaved) {
            ++this.numFailedTitles;
            System.out.println("Could not save title " + titleId);
            writer.write(titleId + "\n");
        }
        return titleSaved;
    }

    private boolean processTitle(long titleId, TimeMetrics tm) throws Exception {
        if (titleId >= 0L) {
            return this.addTitle(titleId, tm);
        }
        return this.deleteTitle(titleId * -1L, tm);
    }

    private boolean addTitle(long titleId, TimeMetrics tm) throws Exception {
        Session session = HibernateContext.getContext().getCurrentSession();
        Transaction trans = session.beginTransaction();
        long t1 = System.currentTimeMillis();
        Title title = PersistenceUtil.getTitleFromDB(titleId);
        if (title == null) {
            return true;
        }
        long t2 = System.currentTimeMillis();
        long dbTime = t2 - t1;
        if (!PersistenceUtil.saveTitleInElasticSearch(title)) {
            return false;
        }
        long t3 = System.currentTimeMillis();
        long esTime = t3 - t2;
        ++tm.count;
        tm.db += dbTime;
        tm.es += esTime;
        String strTitleId = "" + titleId;
        this.statusFile.seek(0L);
        this.statusFile.writeUTF(strTitleId);
        trans.commit();
        return true;
    }

    private boolean deleteTitle(long titleId, TimeMetrics tm) throws Exception {
        Session session = HibernateContext.getContext().getCurrentSession();
        Transaction trans = session.beginTransaction();
        long t1 = System.currentTimeMillis();
        Title title = PersistenceUtil.getTitleFromDB(titleId);
        if (title == null) {
            return true;
        }
        long t2 = System.currentTimeMillis();
        long dbTime = t2 - t1;
        if (!PersistenceUtil.removeTitleInElasticSearch(title)) {
            return false;
        }
        long t3 = System.currentTimeMillis();
        long esTime = t3 - t2;
        ++tm.count;
        tm.db += dbTime;
        tm.es += esTime;
        String strTitleId = "-" + titleId;
        this.statusFile.seek(0L);
        this.statusFile.writeUTF(strTitleId);
        trans.commit();
        return true;
    }

    private static int getNumberToAbort() {
        int numAbort = 1;
        String str = PropertiesUtil.readProperties().getProperty("numberToAbort");
        if (str == null || str.trim().isEmpty()) {
            System.out.println("WARN: Number to Abort is not set ('numberToAbort' property in 'sync.properties' file). Will use 1.");
        } else {
            try {
                numAbort = Integer.parseInt(str);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (numAbort < 1) {
            numAbort = 0;
        }
        System.out.println("Number to Abort : " + numAbort);
        return numAbort;
    }

    private List<String> getPreviousFailedTitleIds(String fileName) throws Exception {
        String line;
        BufferedReader reader = new BufferedReader(new FileReader(fileName));
        ArrayList<String> prevFailedtitleIds = new ArrayList<String>();
        while ((line = reader.readLine()) != null) {
            line = line.trim();
            prevFailedtitleIds.add(line);
        }
        reader.close();
        return prevFailedtitleIds;
    }
}

