/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.elasticsearch.geosync;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Properties;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;

public class TransportClientFactory {
    private static final int TRANSPORT_CLIENT_PORT = 9300;

    private TransportClientFactory() {
    }

    public static TransportClient createTransportClient(Properties properties) throws UnknownHostException {
        Settings.Builder bld = Settings.settingsBuilder();
        bld.put("cluster.name", properties.getProperty("cluster.name"));
        Settings settings = bld.build();
        TransportClient client = new TransportClient.Builder().settings(settings).build();
        String hosts = properties.getProperty("hosts");
        InetAddress[] addresses = InetAddress.getAllByName(hosts);
        if (addresses != null) {
            for (InetAddress ia : addresses) {
                InetSocketTransportAddress addr = new InetSocketTransportAddress(new InetSocketAddress(ia.getHostAddress(), 9300));
                client.addTransportAddress((TransportAddress)addr);
                System.out.println("Host added: " + ia.getHostAddress() + ":" + 9300);
            }
        }
        return client;
    }
}

