/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.search.elasticsearch.util.sync;

import com.tandbergtv.workflow.driver.search.elasticsearch.util.sync.Bookmark;
import com.tandbergtv.workflow.driver.search.elasticsearch.util.sync.ESWriter;
import com.tandbergtv.workflow.driver.search.elasticsearch.util.sync.WoRdbmsToEsSynchronizer;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class BlockingExecutor
extends ThreadPoolExecutor {
    private Logger logger = Logger.getLogger(BlockingExecutor.class);
    private Semaphore semaphore;
    private Bookmark bookmark;

    public BlockingExecutor(int poolSize, int queueSize, Bookmark bookmark) {
        super(poolSize, poolSize, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        this.semaphore = new Semaphore(poolSize + queueSize);
        this.bookmark = bookmark;
    }

    @Override
    public void execute(Runnable command) {
        boolean acquired = false;
        do {
            try {
                this.semaphore.acquire();
                acquired = true;
            }
            catch (InterruptedException e) {
                this.logger.warn((Object)"InterruptedException whilst aquiring semaphore", (Throwable)e);
            }
        } while (!acquired);
        try {
            super.execute(command);
        }
        catch (RejectedExecutionException e) {
            this.semaphore.release();
            throw e;
        }
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        super.afterExecute(r, t);
        ESWriter wr = (ESWriter)r;
        if (!wr.isNotFound()) {
            if (wr.isDeleted()) {
                WoRdbmsToEsSynchronizer.deletedCount.incrementAndGet();
            } else {
                WoRdbmsToEsSynchronizer.savedCount.incrementAndGet();
            }
        }
        this.bookmark.update(wr.getWoId());
        this.semaphore.release();
    }
}

