/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.search.elasticsearch.util.sync;

import com.tandbergtv.workflow.driver.search.elasticsearch.util.sync.WoRdbmsToEsSynchronizer;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class Bookmark
implements Runnable {
    private Logger logger = Logger.getLogger(Bookmark.class);
    private static final String BOOKMARK_FILE = System.getProperty("com.tandbergtv.cms.product.dir") + "/scripts/sync_utils/work/workflowBookmark.txt";
    private static final String BOOKMARK_FORMAT = "%d:%d:%d:%d";
    private boolean keepRunning = true;
    private Date currentRunStartTimeParam;
    private long lastRunProcessId = 0L;
    private List<Long> readStart = Collections.synchronizedList(new ArrayList());
    private Set<Long> bookmarks = Collections.synchronizedSet(new HashSet());
    private long lastWrittenBookmark = 0L;

    public Bookmark(Date startTime) {
        this.currentRunStartTimeParam = startTime;
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        String[] arr;
        String bookMark = "";
        FileInputStream fis = null;
        BufferedReader reader = null;
        try {
            String line;
            File f = new File(BOOKMARK_FILE);
            if (!f.exists()) {
                f.createNewFile();
            }
            fis = new FileInputStream(f);
            reader = new BufferedReader(new InputStreamReader(fis));
            while ((line = reader.readLine()) != null) {
                if (line.trim().startsWith("#") || line.trim().split(":").length != 4) continue;
                bookMark = line;
                break;
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"Encountered exception during bookmark initialization", (Throwable)e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {}
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {}
            }
        }
        if (!bookMark.isEmpty() && (arr = bookMark.split(":")) != null && arr.length == 4 && ("" + this.currentRunStartTimeParam.getTime()).equals(arr[0])) {
            if (("" + WoRdbmsToEsSynchronizer.LAST_RECORD).equals(arr[1])) {
                this.logger.info((Object)"Last run completed successfully, running complete synchronization again");
                return;
            }
            Date dt = new Date();
            dt.setTime(Long.parseLong(arr[3]));
            this.logger.info((Object)("A previous interrupted run [" + WoRdbmsToEsSynchronizer.INPUT_DATE_FORMATTER.format(dt) + "] was detected."));
            this.lastRunProcessId = Long.parseLong(arr[1]);
            this.lastWrittenBookmark = Long.parseLong(arr[2]);
            if (this.lastRunProcessId > this.lastWrittenBookmark) {
                this.lastWrittenBookmark = this.lastRunProcessId;
            }
        }
    }

    public long getLastWrittenBookmark() {
        return this.lastWrittenBookmark;
    }

    public void addStart(long startingId) {
        this.readStart.add(startingId);
    }

    public void update(long completedId) {
        this.bookmarks.add(completedId);
    }

    public void terminate() {
        this.lastRunProcessId = WoRdbmsToEsSynchronizer.LAST_RECORD;
        this.keepRunning = false;
        this.logProgress();
        ArrayList<Long> errors = new ArrayList<Long>();
        ArrayList<Long> bkItems = new ArrayList<Long>(this.bookmarks);
        if (bkItems.size() == 0) {
            return;
        }
        Collections.sort(bkItems);
        while (bkItems.size() > 1) {
            long butone;
            int lastIndex = bkItems.size() - 1;
            long last = (Long)bkItems.get(lastIndex);
            if (last - (butone = ((Long)bkItems.get(lastIndex - 1)).longValue()) != 1L) {
                for (long i = last - 1L; i > butone; --i) {
                    errors.add(i);
                }
            }
            bkItems.remove(lastIndex);
        }
        if (errors.size() > 0) {
            StringBuffer str = new StringBuffer();
            for (Long i : errors) {
                str.append(i).append(", ");
            }
            this.logger.error((Object)("Some of the WOs did not synchronize properly, hence reporting an error. Expected success bookmark would have been:" + bkItems.get(0) + ". Failed WOs are:" + str.toString()));
        }
        this.write();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write() {
        long butone;
        int lastIndex;
        long last;
        ArrayList<Long> bkItems = new ArrayList<Long>(this.bookmarks);
        if (bkItems.size() == 0) {
            return;
        }
        Collections.sort(bkItems);
        while (bkItems.size() > 1 && (last = ((Long)bkItems.get(lastIndex = bkItems.size() - 1)).longValue()) - (butone = ((Long)bkItems.get(lastIndex - 1)).longValue()) == 1L) {
            bkItems.remove(lastIndex);
            this.bookmarks.remove(last);
            if (!this.readStart.contains(last)) continue;
            this.readStart.remove(last);
            this.lastWrittenBookmark = last;
        }
        this.lastRunProcessId = this.lastRunProcessId == WoRdbmsToEsSynchronizer.LAST_RECORD ? this.lastRunProcessId : (Long)bkItems.get(bkItems.size() - 1);
        this.lastWrittenBookmark = this.lastWrittenBookmark == 0L ? this.readStart.get(0) : this.lastWrittenBookmark;
        String bookMark = String.format(BOOKMARK_FORMAT, this.currentRunStartTimeParam.getTime(), this.lastRunProcessId, this.lastWrittenBookmark, new Date().getTime());
        FileOutputStream fos = null;
        BufferedWriter writer = null;
        try {
            fos = new FileOutputStream(BOOKMARK_FILE);
            writer = new BufferedWriter(new OutputStreamWriter(fos));
            writer.write(bookMark);
            writer.flush();
        }
        catch (Exception e) {
            this.logger.error((Object)("Failed to write bookmark [" + bookMark + "]"), (Throwable)e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    this.logger.error((Object)"Failed to close writer", (Throwable)e);
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    this.logger.error((Object)"Failed to close file output stream", (Throwable)e);
                }
            }
        }
    }

    private void logProgress() {
        String msg = "Saved " + WoRdbmsToEsSynchronizer.savedCount.get() + " documents to ElasticSearch out of " + WoRdbmsToEsSynchronizer.totalCount + " Workorders; Deleted " + WoRdbmsToEsSynchronizer.deletedCount.get() + " documents from ElasticSearch that were found inactive in RDBMS.";
        this.logger.info((Object)msg);
        System.out.println(msg);
    }

    @Override
    public void run() {
        while (this.keepRunning) {
            try {
                Thread.sleep(30000L);
            }
            catch (InterruptedException e1) {
                break;
            }
            this.logProgress();
            this.write();
        }
    }
}

