/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.search.elasticsearch.util.sync;

import com.ericsson.neptune.es.CmsTransportClient;
import com.tandbergtv.workflow.core.Datatype;
import com.tandbergtv.workflow.core.ProcessPriority;
import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.graph.ErrorCategory;
import com.tandbergtv.workflow.driver.search.elasticsearch.WfsEsParameters;
import com.tandbergtv.workflow.driver.search.elasticsearch.util.sync.BlockingExecutor;
import com.tandbergtv.workflow.driver.search.elasticsearch.util.sync.Bookmark;
import com.tandbergtv.workflow.driver.search.elasticsearch.util.sync.ESWriter;
import com.tandbergtv.workflow.driver.search.elasticsearch.util.sync.WoRdbmsToEsSynchronizer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import org.apache.log4j.Logger;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class ESSynchronizer
implements Runnable {
    private Logger logger = Logger.getLogger(ESSynchronizer.class);
    private static final String CONFIG_FILE = System.getProperty("com.tandbergtv.cms.product.dir", "/opt/tandbergtv/cms") + "/conf/workflow/WFSElasticSearch.properties";
    private CmsTransportClient client;
    private BlockingQueue<Long> woQueue;
    private Map<Long, Object[]> workOrderData;
    private Map<Long, Object[]> tokenData;
    private Map<Long, String> templates;
    private Map<String, List<Object[]>> variables;
    private int concurrency;
    private long lastWOId = 0L;
    private Bookmark bookmark;

    public ESSynchronizer(BlockingQueue<Long> woQueue, int concurrency, Bookmark bookmark, Map<Long, Object[]> workOrderData, Map<Long, Object[]> tokenData, Map<Long, String> templates, Map<String, List<Object[]>> variables) {
        this.woQueue = woQueue;
        this.concurrency = concurrency;
        this.bookmark = bookmark;
        this.workOrderData = workOrderData;
        this.tokenData = tokenData;
        this.templates = templates;
        this.variables = variables;
    }

    private void init() {
        this.logger.info((Object)"Starting WFSElasticSearch service...");
        try {
            this.client = new CmsTransportClient(CONFIG_FILE);
        }
        catch (Exception e) {
            this.logger.fatal((Object)"Could not connect to ElasticSearch.", (Throwable)e);
            System.exit(2);
        }
    }

    public void save(String procId, XContentBuilder source) throws Exception {
        if (source == null) {
            return;
        }
        long t1 = System.currentTimeMillis();
        while (!this.trySaving(procId, source)) {
            long t2;
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if ((t2 = System.currentTimeMillis()) - t1 <= this.client.getSettings().getWriteTimeoutMs()) continue;
            this.logger.fatal((Object)("Failed attempt of saving process Id " + procId + " to reindex later for save operation."));
            System.out.println("Failed attempt of saving process Id " + procId + " to reindex later for save operation.");
            System.exit(2);
            return;
        }
    }

    private void addSearchableField(XContentBuilder bldr, String key, Object value) {
        try {
            bldr.field(key, value);
        }
        catch (Exception ex) {
            this.logger.error((Object)"Cannot add field", (Throwable)ex);
        }
    }

    public void addSearchFields(XContentBuilder bldr, long procId) {
        Object[] wColumns = this.workOrderData.remove(procId);
        Object[] tColumns = this.tokenData.remove(procId);
        if (tColumns == null) {
            this.logger.warn((Object)("No token data for work order:" + procId + ", will skip it."));
            return;
        }
        this.addSearchableField(bldr, "id", procId);
        long templateId = ((BigDecimal)wColumns[3]).longValue();
        this.addSearchableField(bldr, "templateId", templateId);
        this.addSearchableField(bldr, "templateName", this.templates.get(templateId));
        int adminStatus = ((BigDecimal)wColumns[7]).intValue();
        this.addSearchableField(bldr, "adminStatus", ProcessStatus.values()[adminStatus]);
        int status = ((BigDecimal)wColumns[8]).intValue();
        this.addSearchableField(bldr, "status", ProcessStatus.values()[status]);
        int priority = ((BigDecimal)wColumns[9]).intValue();
        this.addSearchableField(bldr, "priority", ProcessPriority.values()[priority]);
        this.addSearchableField(bldr, "isActive", 1 == ((BigDecimal)wColumns[6]).intValue());
        if (tColumns[2] != null) {
            this.addSearchableField(bldr, "currentTask", tColumns[2].toString());
        }
        if (wColumns[1] != null && wColumns[1].toString().trim().length() > 0) {
            this.addSearchableField(bldr, "startTime", this.getTime(wColumns[1].toString()));
        }
        if (wColumns[2] != null && wColumns[2].toString().trim().length() > 0) {
            this.addSearchableField(bldr, "endTime", this.getTime(wColumns[2].toString()));
        }
        if (this.validateId(wColumns[5])) {
            this.addSearchableField(bldr, "superProcessTokenId", ((BigDecimal)wColumns[5]).longValue());
        } else {
            this.addSearchableField(bldr, "superProcessTokenId", null);
        }
        if (this.validateId(wColumns[10])) {
            this.addSearchableField(bldr, "parentProcessId", ((BigDecimal)wColumns[10]).longValue());
        } else {
            this.addSearchableField(bldr, "parentProcessId", 0);
        }
        if (tColumns[3] != null && ((BigInteger)tColumns[3]).longValue() > 0L) {
            this.addSearchableField(bldr, "hasChildren", true);
        } else {
            this.addSearchableField(bldr, "hasChildren", false);
        }
        if (wColumns[13] != null && ((BigInteger)wColumns[13]).longValue() > 0L) {
            this.addSearchableField(bldr, "hasFailedBranch", true);
        } else {
            this.addSearchableField(bldr, "hasFailedBranch", false);
        }
        if (wColumns[14] != null) {
            this.addSearchableField(bldr, "note", wColumns[14].toString());
        } else {
            this.addSearchableField(bldr, "note", "");
        }
        if (wColumns[12] != null) {
            this.addSearchableField(bldr, "createId", wColumns[12].toString());
        } else {
            this.addSearchableField(bldr, "createId", null);
        }
        this.addSearchableField(bldr, "rootTokenId", ((BigDecimal)wColumns[4]).longValue());
        if (tColumns[5] != null) {
            this.addSearchableField(bldr, "errorTime", this.getTime(tColumns[6].toString()));
            this.addSearchableField(bldr, "errorComment", this.getMessage(tColumns[5] == null ? "" : tColumns[5].toString(), tColumns[7] == null ? "" : tColumns[7].toString(), tColumns));
            this.addSearchableField(bldr, "errorType", ErrorCategory.valueOf((String)tColumns[5].toString()));
        }
        boolean titleIdFound = false;
        boolean titleBriefFound = false;
        boolean licenseStartFound = false;
        boolean licenseEndFound = false;
        boolean providerIdFound = false;
        boolean ingestTemplateFound = false;
        List<Object[]> vars = this.variables.remove(procId + "_" + ((BigDecimal)tColumns[1]).longValue());
        if (vars == null) {
            return;
        }
        for (Object[] vColumns : vars) {
            Date dtVal;
            if (titleIdFound && titleBriefFound && licenseStartFound && licenseEndFound && providerIdFound && ingestTemplateFound) break;
            if (vColumns[0] == null || vColumns[1] == null || vColumns[2] == null) continue;
            String varName = vColumns[0].toString();
            String type = vColumns[1].toString();
            Object value = vColumns[2];
            if ("titleId".equalsIgnoreCase(varName) || "title_id".equalsIgnoreCase(varName)) {
                this.addSearchableField(bldr, "titleId", value.toString());
                titleIdFound = true;
                continue;
            }
            if ("titleBrief".equalsIgnoreCase(varName) || "title_brief".equalsIgnoreCase(varName)) {
                this.addSearchableField(bldr, "titleBrief", value.toString());
                titleBriefFound = true;
                continue;
            }
            if ("licenseStart".equalsIgnoreCase(varName) || "license_start".equalsIgnoreCase(varName) || "licensingWindowStart".equalsIgnoreCase(varName)) {
                dtVal = this.getLicenseValue(type, value);
                if (dtVal != null) {
                    this.addSearchableField(bldr, "licenseStart", dtVal);
                }
                licenseStartFound = true;
                continue;
            }
            if ("licenseEnd".equalsIgnoreCase(varName) || "license_end".equalsIgnoreCase(varName) || "licensingWindowEnd".equalsIgnoreCase(varName)) {
                dtVal = this.getLicenseValue(type, value);
                if (dtVal != null) {
                    this.addSearchableField(bldr, "licenseEnd", dtVal);
                }
                licenseEndFound = true;
                continue;
            }
            if ("providerId".equalsIgnoreCase(varName) || "provider_id".equalsIgnoreCase(varName)) {
                this.addSearchableField(bldr, "providerId", value.toString());
                providerIdFound = true;
                continue;
            }
            if ("ingestTemplate".equalsIgnoreCase(varName)) {
                this.addSearchableField(bldr, "ingestTemplate", true);
                ingestTemplateFound = true;
                continue;
            }
            if ("_last_allocated_resource".equalsIgnoreCase(varName)) {
                this.addSearchableField(bldr, "_last_allocated_resource", value.toString());
                continue;
            }
            if (!WoRdbmsToEsSynchronizer.customMappingFields.contains(varName)) continue;
            this.addSearchableField(bldr, varName, value);
        }
    }

    private Date getLicenseValue(String type, Object value) {
        Date dtVal = null;
        if (type.equalsIgnoreCase(Datatype.DATE.toString())) {
            dtVal = (Date)value;
        } else if (type.equalsIgnoreCase(Datatype.STRING.toString())) {
            dtVal = this.convertTitleStringToDate(value.toString());
        }
        return dtVal;
    }

    private Date convertTitleStringToDate(String date) {
        Date retVal = null;
        if (date != null && !date.isEmpty()) {
            try {
                retVal = WfsEsParameters.getUTCFormat((String)date, null).parse(date);
            }
            catch (ParseException e) {
                this.logger.warn((Object)("Date received from Title Service [" + date + "] is not in correct format. Expected format :" + "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'"), (Throwable)e);
            }
        }
        return retVal;
    }

    private Date getTime(String date) {
        Date retVal = null;
        if (date != null && !date.isEmpty()) {
            try {
                retVal = WfsEsParameters.getUTCFormat((String)date, null).parse(date);
            }
            catch (ParseException e) {
                this.logger.warn((Object)("Date [" + date + "] could not be parsed."), (Throwable)e);
            }
        }
        return retVal;
    }

    private String getMessage(String errorType, String errorDesc, Object[] tColumns) {
        ErrorCategory category = ErrorCategory.valueOf((String)errorType);
        if (category == ErrorCategory.CHILD_PROCESS_FAILED) {
            return "Subprocess ID " + tColumns[4].toString() + " failed";
        }
        if (category == ErrorCategory.TIMEOUT && tColumns[2] != null) {
            return "Timed out at " + tColumns[2].toString();
        }
        if (category == ErrorCategory.INFINITE_LOOP) {
            return "Loop exceeded iteration limit";
        }
        return errorDesc;
    }

    private boolean trySaving(String id, XContentBuilder source) {
        if (this.client == null) {
            this.logger.error((Object)("Could not index process " + id + ". ElasticSearch client is not initialized."));
            return false;
        }
        try {
            IndexRequestBuilder bld = this.client.prepareIndex("wfs", "processinstance", id);
            bld.setSource(source);
            bld.execute().actionGet(10000L);
            return true;
        }
        catch (Exception e) {
            this.logger.error((Object)("Could not index process " + id), (Throwable)e);
            return false;
        }
    }

    private boolean validateId(Object id) {
        return id != null && ((BigDecimal)id).longValue() > 0L;
    }

    @Override
    public void run() {
        this.init();
        BlockingExecutor executor = new BlockingExecutor(this.concurrency, this.concurrency, this.bookmark);
        try {
            while (true) {
                long wip;
                if ((wip = this.woQueue.take().longValue()) == WoRdbmsToEsSynchronizer.LAST_RECORD) {
                    this.logger.info((Object)"Last record fetched from queue");
                    break;
                }
                if (this.lastWOId == 0L) {
                    this.lastWOId = wip;
                }
                for (long i = this.lastWOId - 1L; i > wip; --i) {
                    ESWriter worker = new ESWriter(i, true, this);
                    executor.execute(worker);
                }
                this.lastWOId = wip;
                ESWriter worker = new ESWriter(wip, false, this);
                executor.execute(worker);
            }
        }
        catch (InterruptedException e) {
            this.logger.error((Object)"Interrupted!", (Throwable)e);
        }
        executor.shutdown();
        do {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (!executor.isTerminated());
        this.logger.info((Object)"Reached end of processing");
    }
}

