/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.search.elasticsearch.util.sync;

import com.tandbergtv.workflow.driver.search.elasticsearch.util.sync.ESSynchronizer;
import org.apache.log4j.Logger;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;

public class ESWriter
implements Runnable {
    private Logger logger = Logger.getLogger(ESWriter.class);
    private long woId;
    private boolean notFound = false;
    private boolean deleted = false;
    private ESSynchronizer parent;

    public ESWriter(long woId, boolean notFound, ESSynchronizer parent) {
        this.woId = woId;
        this.notFound = notFound;
        this.parent = parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.notFound) {
            return;
        }
        try (XContentBuilder builder = null;){
            builder = XContentFactory.jsonBuilder();
            builder.prettyPrint();
            builder.startObject();
            this.parent.addSearchFields(builder, this.woId);
            builder.endObject();
            long startEx = System.currentTimeMillis();
            this.parent.save("" + this.woId, builder);
            this.logger.info((Object)("Saved to ES Id:" + this.woId));
            this.logger.debug((Object)("Time taken [" + (System.currentTimeMillis() - startEx) + "] to perform save on ES for WO:" + this.woId));
        }
    }

    public long getWoId() {
        return this.woId;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public boolean isNotFound() {
        return this.notFound;
    }
}

