/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.search.elasticsearch.util.sync;

import com.tandbergtv.workflow.core.lifecycle.Platform;
import com.tandbergtv.workflow.driver.search.elasticsearch.util.sync.Bookmark;
import com.tandbergtv.workflow.driver.search.elasticsearch.util.sync.DBReader;
import com.tandbergtv.workflow.driver.search.elasticsearch.util.sync.ESSynchronizer;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.log4j.Logger;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.map.ObjectMapper;

public class WoRdbmsToEsSynchronizer {
    private static Logger logger = Logger.getLogger(WoRdbmsToEsSynchronizer.class);
    public static final Long LAST_RECORD = -1L;
    public static final SimpleDateFormat INPUT_DATE_FORMATTER = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
    private static final int DEFAULT_QUEUE_LIMIT = 100;
    private static final int DEFAULT_CONCURRENCY = 5;
    private static final String ACTIVATORS_XML = "conf/syncActivators.xml";
    private static final int DEFAULT_VARIABLE_QUERY_LIMIT = 50;
    private static final int DEFAULT_VARIABLE_TRHEAD_LIMIT = 20;
    private static final String CUSTOM_MAPPING_FILE = System.getProperty("com.tandbergtv.cms.product.dir", "/opt/tandbergtv/cms") + "/conf/workflow/custom_wfs_mappings.json";
    private static final String DEFAULT_MAPPING_FILE = "/opt/tandbergtv/cms/scripts/sync_utils/bin/wfs_index.json";
    private static final String EDB_DATABASE_PORT = "5444";
    private static BlockingQueue<Long> woQueue;
    private static Map<Long, Object[]> workOrderData;
    private static Map<Long, Object[]> tokenData;
    private static Map<Long, String> templates;
    private static Map<String, List<Object[]>> variables;
    public static int totalCount;
    public static AtomicInteger savedCount;
    public static AtomicInteger deletedCount;
    private static List<String> defaultMappingFields;
    protected static List<String> customMappingFields;

    public static void main(String[] args) throws Exception {
        String customMappingFile;
        INPUT_DATE_FORMATTER.parse("1900-01-01 00:00:00");
        PosixParser parser = new PosixParser();
        CommandLine cmd = null;
        try {
            cmd = parser.parse(WoRdbmsToEsSynchronizer.getOptions(), args);
        }
        catch (ParseException pe) {
            WoRdbmsToEsSynchronizer.printUsageAndExit();
        }
        if (args.length == 0 || cmd.hasOption("h")) {
            WoRdbmsToEsSynchronizer.printUsageAndExit();
        }
        int queueLimit = cmd.hasOption("queuelimit") ? Integer.parseInt(cmd.getOptionValue("queuelimit")) : 100;
        int concurrency = cmd.hasOption("concurrency") ? Integer.parseInt(cmd.getOptionValue("concurrency")) : 5;
        Date startTime = cmd.hasOption("starttime") ? INPUT_DATE_FORMATTER.parse(cmd.getOptionValue("starttime")) : INPUT_DATE_FORMATTER.parse("1900-01-01 00:00:00");
        int variableQueryLimit = cmd.hasOption("variablequerylimit") ? Integer.parseInt(cmd.getOptionValue("variablequerylimit")) : 50;
        int variableConcurrency = cmd.hasOption("variableconcurrency") ? Integer.parseInt(cmd.getOptionValue("variableconcurrency")) : 20;
        String defaultMappingFile = cmd.hasOption("defaultMappingFile") ? cmd.getOptionValue("defaultMappingFile") : DEFAULT_MAPPING_FILE;
        String string = customMappingFile = cmd.hasOption("customMappingFile") ? cmd.getOptionValue("customMappingFile") : CUSTOM_MAPPING_FILE;
        if (queueLimit <= 0 || queueLimit > 1000) {
            logger.warn((Object)(queueLimit + " is invalid queuelimit range. Using default of " + 100));
            queueLimit = 100;
        }
        if (concurrency <= 0 || concurrency > 100) {
            logger.warn((Object)(concurrency + " is invalid concurrency range. Using default of " + 5));
            concurrency = 5;
        }
        woQueue = new ArrayBlockingQueue<Long>(queueLimit);
        workOrderData = new ConcurrentHashMap<Long, Object[]>();
        tokenData = new ConcurrentHashMap<Long, Object[]>();
        templates = new HashMap<Long, String>();
        variables = new ConcurrentHashMap<String, List<Object[]>>();
        Bookmark bookmark = new Bookmark(startTime);
        WoRdbmsToEsSynchronizer.setHibernateConnectionUrl(cmd);
        Platform.getPlatform().start(ACTIVATORS_XML);
        DBReader producer = new DBReader(woQueue, startTime, queueLimit, bookmark, variableQueryLimit, variableConcurrency, workOrderData, tokenData, templates, variables);
        Thread producerThread = new Thread(producer);
        producerThread.start();
        WoRdbmsToEsSynchronizer.initializeMappingFields(defaultMappingFile, customMappingFile);
        ESSynchronizer consumer = new ESSynchronizer(woQueue, concurrency, bookmark, workOrderData, tokenData, templates, variables);
        Thread consumerThread = new Thread(consumer);
        consumerThread.start();
        Thread bookmarkThread = new Thread(bookmark);
        bookmarkThread.start();
        producerThread.join();
        consumerThread.join();
        bookmark.terminate();
        bookmarkThread.join();
        Platform.getPlatform().stop(ACTIVATORS_XML);
        System.exit(0);
    }

    private static void initializeMappingFields(String defaultMappingFile, String customMappingFile) {
        WoRdbmsToEsSynchronizer.addMappingFields(defaultMappingFile, defaultMappingFields);
        if (WoRdbmsToEsSynchronizer.isCustomMappingFileExists(customMappingFile)) {
            WoRdbmsToEsSynchronizer.addMappingFields(customMappingFile, customMappingFields);
        }
    }

    private static void addMappingFields(String file, List<String> mappingFields) {
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
            ObjectMapper objectMapper = new ObjectMapper();
            JsonNode root = objectMapper.readTree((InputStream)is);
            Iterator nodeIterator = root.findPath("properties").getFieldNames();
            while (nodeIterator.hasNext()) {
                String field = (String)nodeIterator.next();
                if (!defaultMappingFields.contains(field) && !customMappingFields.contains(field)) {
                    mappingFields.add(field);
                    logger.info((Object)("Adding " + field));
                    continue;
                }
                logger.warn((Object)("The fieldName: " + field + " already exist."));
            }
        }
        catch (JsonProcessingException jpe) {
            logger.error((Object)("Error occurred while processing " + is), (Throwable)jpe);
        }
        catch (IOException ioe) {
            logger.error((Object)("Error occurred reading " + is), (Throwable)ioe);
        }
    }

    private static void printUsageAndExit() {
        HelpFormatter help = new HelpFormatter();
        help.printHelp("workflow_elasticsearch_sync.sh <database server DNS name or IP> <parameter 1 parameter 2 ... parameter N>", WoRdbmsToEsSynchronizer.getOptions());
        System.exit(1);
    }

    private static Options getOptions() {
        Options cliOptions = new Options();
        cliOptions.addOption("starttime", true, "Modified since date in yyyy-MM-dd hh:mm:ss format. If missing, considered as Rebuild Index for All Workorders");
        cliOptions.addOption("queuelimit", true, "Size of internal queue, also used as query batch size, defaults to 100");
        cliOptions.addOption("concurrency", true, "Number of parallel threads, defaults to 10");
        cliOptions.addOption("variablequerylimit", true, "Max number of processids to use in variable isntance query, defaults to 50");
        cliOptions.addOption("variableconcurrency", true, "Max number of parallel threads to run variable instance query, defaults to 20");
        cliOptions.addOption("port", true, "Database connection port which listen in connections from client applications . default to 5444");
        cliOptions.addOption("h", "help", false, "Show help.");
        return cliOptions;
    }

    private static void setHibernateConnectionUrl(CommandLine cmd) {
        String connUrl = System.getProperty("hibernate.connection.url");
        connUrl = cmd.hasOption("port") ? connUrl.replaceAll("DBPORT", cmd.getOptionValue("port")) : connUrl.replaceAll("DBPORT", EDB_DATABASE_PORT);
        logger.info((Object)("DB connection url: " + connUrl));
        System.setProperty("hibernate.connection.url", connUrl);
    }

    private static boolean isCustomMappingFileExists(String filePath) {
        File file = new File(filePath);
        return file.exists();
    }

    static {
        totalCount = 0;
        savedCount = new AtomicInteger(0);
        deletedCount = new AtomicInteger(0);
        defaultMappingFields = new ArrayList<String>();
        customMappingFields = new ArrayList<String>();
    }
}

