/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.criteria;

import com.ericsson.cms.criteria.FieldType;
import com.ericsson.cms.criteria.LogicalOperator;
import com.ericsson.cms.criteria.PredicateComplex;
import com.ericsson.cms.criteria.PredicateRightField;
import com.ericsson.cms.criteria.PredicateRightValue;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlTransient;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=PredicateComplex.class, name="predicateComplex"), @JsonSubTypes.Type(value=PredicateRightField.class, name="predicateRightField"), @JsonSubTypes.Type(value=PredicateRightValue.class, name="predicateRightValue")})
@XmlRootElement(name="predicate")
@XmlSeeAlso(value={PredicateComplex.class, PredicateRightField.class, PredicateRightValue.class})
public class Predicate
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 560513553850166233L;
    protected Integer predicateId;
    protected String fieldLeft;
    protected String fieldLeftSectionType;
    protected FieldType fieldTypeLhs;
    protected Integer version;
    protected LogicalOperator operator;
    protected Date createDate;
    protected Date updateDate;
    protected String dataType;
    protected boolean ignoreCase;
    private Boolean not;

    public Predicate() {
    }

    public Predicate(String fieldLeft, String fieldLeftSectionType, FieldType fieldTypeLhs, LogicalOperator operator, Boolean not) {
        this.setFieldLeft(fieldLeft);
        this.operator = operator;
        this.setFieldLeftSectionType(fieldLeftSectionType);
        this.not = not;
        this.setFieldTypeLhs(fieldTypeLhs);
    }

    public Predicate(String fieldLeft, String fieldLeftSectionType, FieldType fieldTypeLhs, LogicalOperator operator, String dataType, Boolean not) {
        this.fieldLeft = fieldLeft;
        this.operator = operator;
        this.fieldLeftSectionType = fieldLeftSectionType;
        this.dataType = dataType;
        this.not = not;
        this.setFieldTypeLhs(fieldTypeLhs);
    }

    @Deprecated
    public Predicate(int predicateId, int version, String fieldLeft, String fieldLeftSectionType, FieldType fieldTypeLhs, LogicalOperator operator, Boolean not) {
        this.predicateId = predicateId;
        this.version = version;
        this.fieldLeft = fieldLeft;
        this.operator = operator;
        this.fieldLeftSectionType = fieldLeftSectionType;
        this.not = not;
        this.setFieldTypeLhs(fieldTypeLhs);
    }

    public Predicate(String fieldLeft, String fieldLeftSectionType, FieldType fieldTypeLhs, LogicalOperator operator, String dataType, Boolean not, Boolean ignoreCase) {
        this(fieldLeft, fieldLeftSectionType, fieldTypeLhs, operator, fieldLeftSectionType, not);
        this.ignoreCase = ignoreCase;
    }

    public void setPredicateId(Integer predicateId) {
        this.predicateId = predicateId;
    }

    @XmlAttribute
    public Integer getPredicateId() {
        return this.predicateId;
    }

    public void setFieldLeft(String fieldLeft) {
        this.fieldLeft = fieldLeft;
    }

    @XmlElement(nillable=true)
    public String getFieldLeft() {
        if (this.fieldLeft == null) {
            return "";
        }
        return this.fieldLeft;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    @XmlElement(nillable=true)
    public Integer getVersion() {
        return this.version;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    @XmlElement(nillable=true)
    public Date getCreateDate() {
        return this.createDate;
    }

    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    @XmlElement(nillable=true)
    public Date getUpdateDate() {
        return this.updateDate;
    }

    public void setOperator(LogicalOperator operator) {
        this.operator = operator;
    }

    @XmlElement(nillable=true)
    public LogicalOperator getOperator() {
        return this.operator;
    }

    @JsonIgnore
    public LogicalOperator getSearchComplientOperator() {
        if (this.getNot().booleanValue()) {
            return this.operator.invert();
        }
        return this.operator;
    }

    public void setHibernateOperator(String operator) {
        this.operator = LogicalOperator.lookUp(operator);
    }

    @JsonIgnore
    @XmlTransient
    public String getHibernateOperator() {
        return this.operator.toString();
    }

    public void setFieldLeftSectionType(String fieldLeftSectionType) {
        this.fieldLeftSectionType = fieldLeftSectionType;
    }

    @XmlElement(nillable=true)
    public String getFieldLeftSectionType() {
        if (this.fieldLeftSectionType == null) {
            return "";
        }
        return this.fieldLeftSectionType;
    }

    public boolean fieldLeftIsWildCard() {
        return this.getFieldLeftSectionType().startsWith("//") || this.getFieldLeftSectionType().isEmpty();
    }

    @JsonIgnore
    @XmlTransient
    public List<String> getFieldLeftSectionTypeAsList() {
        return Arrays.asList(this.getFieldLeftSectionType().split("/"));
    }

    @XmlElement(nillable=true)
    public String getDataType() {
        return this.dataType;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public void setIgnoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
    }

    @XmlElement(nillable=true)
    public boolean getIgnoreCase() {
        return this.ignoreCase;
    }

    public void setNot(Boolean not) {
        this.not = not;
    }

    @XmlElement(nillable=true)
    public Boolean getNot() {
        return this.not;
    }

    @XmlElement(nillable=true)
    public FieldType getFieldTypeLhs() {
        return this.fieldTypeLhs;
    }

    @JsonIgnore
    @XmlTransient
    public String getFieldTypeLhsHibernate() {
        return this.fieldTypeLhs.name();
    }

    public void setFieldTypeLhs(FieldType fieldTypeLhs) {
        this.fieldTypeLhs = fieldTypeLhs;
    }

    public void setFieldTypeLhsHibernate(String fieldTypeLhs) {
        this.setFieldTypeLhs(FieldType.valueOf(fieldTypeLhs.toUpperCase()));
    }

    @JsonIgnore
    public String getFieldLeftTail() {
        return this.getFieldLeft().substring(this.getFieldLeft().lastIndexOf(47) + 1);
    }

    public Predicate clone() {
        return new Predicate(this.fieldLeft, this.fieldLeftSectionType, this.fieldTypeLhs, this.operator, this.dataType, this.not, (Boolean)this.ignoreCase);
    }
}

