/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.sites.core.entities;

import com.ericsson.cms.scheduler.entities.Job;
import com.ericsson.cms.sites.core.entities.ActionOnFailureOption;
import com.ericsson.cms.sites.core.entities.CISMode;
import com.ericsson.cms.sites.core.entities.DistributionOption;
import com.ericsson.cms.sites.core.entities.DistributionSiteTitle;
import com.ericsson.cms.sites.core.entities.LogicalSite;
import com.ericsson.cms.sites.core.entities.Site;
import com.ericsson.cms.sites.core.entities.SiteType;
import com.ericsson.cms.sites.core.entities.TrackingSite;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang.StringUtils;

@XmlRootElement(name="distributionSite")
public class DistributionSite
extends Site
implements Comparable<DistributionSite> {
    private static final long serialVersionUID = -6462042194756033513L;
    private String metadataFormat;
    private String commaSeparatedFileLookupKeys;
    private DistributionOption distributionOption;
    private Integer alertDelayPeriod;
    private String distTemplateName;
    private String associatedGroupName;
    private Map<String, String> distConfParams;
    private String exportPluginName;
    private Map<String, String> exportConfParams;
    private Long associatedResourceId;
    private CISMode cisMode;
    private LogicalSite parent;
    private Set<TrackingSite> children;
    private Set<DistributionSiteTitle> distributionSiteTitles;
    private List<Integer> dependsOnSites;
    private Job timerJob;
    private ActionOnFailureOption actionOnFailure;
    private Integer retryAttempt;
    private Integer retryWaitTime;

    public void setChildren(Set<TrackingSite> children) {
        this.children = children;
    }

    public void addChild(TrackingSite child) {
        if (this.children == null) {
            this.children = new TreeSet<TrackingSite>();
        }
        this.children.add(child);
    }

    public boolean removeChild(TrackingSite child) {
        if (this.children != null) {
            return this.children.remove(child);
        }
        return false;
    }

    public void clearChildren() {
        if (this.children != null) {
            this.children.clear();
        }
    }

    @JsonIgnore
    @XmlTransient
    public Set<TrackingSite> getChildren() {
        return this.children;
    }

    @Override
    @JsonIgnore
    @XmlTransient
    public Set<Site> getSiteChildren() {
        TreeSet<Site> siteChildren = new TreeSet<Site>();
        if (this.children != null) {
            for (TrackingSite trackingSiteChild : this.children) {
                siteChildren.add(trackingSiteChild);
            }
        }
        return siteChildren;
    }

    public void setParent(LogicalSite parent) {
        this.parent = parent;
    }

    @JsonIgnore
    @XmlTransient
    public LogicalSite getParent() {
        return this.parent;
    }

    @Override
    @JsonIgnore
    @XmlElement(nillable=true)
    public SiteType getType() {
        return SiteType.DISTRIBUTION;
    }

    @Override
    @JsonIgnore
    @XmlTransient
    public Set<Site> getSiteParents() {
        HashSet<Site> parents = new HashSet<Site>();
        if (this.parent != null) {
            parents.add(this.parent);
        }
        return parents;
    }

    @JsonIgnore
    @XmlTransient
    public Set<DistributionSiteTitle> getDistributionSiteTitles() {
        return this.distributionSiteTitles;
    }

    public void setDistributionSiteTitles(Set<DistributionSiteTitle> distributionSiteTitles) {
        this.distributionSiteTitles = distributionSiteTitles;
    }

    @XmlElement(nillable=true)
    public String getMetadataFormat() {
        return this.metadataFormat;
    }

    public void setMetadataFormat(String metadataFormat) {
        this.metadataFormat = metadataFormat;
    }

    @JsonIgnore
    @XmlTransient
    public List<String> getFileLookupKeys() {
        if (this.commaSeparatedFileLookupKeys == null || this.commaSeparatedFileLookupKeys.isEmpty()) {
            return null;
        }
        String[] fileLookupKeysArray = this.commaSeparatedFileLookupKeys.split(",");
        return Arrays.asList(fileLookupKeysArray);
    }

    public void setFileLookupKeys(List<String> fileLookupKeys) {
        if (fileLookupKeys == null || fileLookupKeys.isEmpty()) {
            this.commaSeparatedFileLookupKeys = null;
            return;
        }
        this.commaSeparatedFileLookupKeys = StringUtils.join(fileLookupKeys, (String)",");
    }

    @JsonIgnore
    @XmlTransient
    protected String getCommaSeparatedFileLookupKeys() {
        return this.commaSeparatedFileLookupKeys;
    }

    protected void setCommaSeparatedFileLookupKeys(String commaSeparatedFileLookupKeys) {
        this.commaSeparatedFileLookupKeys = commaSeparatedFileLookupKeys;
    }

    @XmlElement(nillable=true)
    public DistributionOption getDistributionOption() {
        return this.distributionOption;
    }

    public void setDistributionOption(DistributionOption distributionOption) {
        this.distributionOption = distributionOption;
    }

    @XmlElement(nillable=true)
    public Integer getAlertDelayPeriod() {
        return this.alertDelayPeriod;
    }

    public void setAlertDelayPeriod(Integer alertDelayPeriod) {
        this.alertDelayPeriod = alertDelayPeriod;
    }

    public String getDistTemplateName() {
        return this.distTemplateName;
    }

    public void setDistTemplateName(String distTemplateName) {
        this.distTemplateName = distTemplateName;
    }

    @JsonIgnore
    @XmlTransient
    public Map<String, String> getDistConfParams() {
        return this.distConfParams;
    }

    public void setDistConfParams(Map<String, String> distConfParams) {
        this.distConfParams = distConfParams;
    }

    @JsonIgnore
    @XmlTransient
    public String getExportPluginName() {
        return this.exportPluginName;
    }

    public void setExportPluginName(String exportPluginName) {
        this.exportPluginName = exportPluginName;
    }

    @JsonIgnore
    @XmlTransient
    public Map<String, String> getExportConfParams() {
        return this.exportConfParams;
    }

    public void setExportConfParams(Map<String, String> exportConfParams) {
        this.exportConfParams = exportConfParams;
    }

    @JsonIgnore
    @XmlTransient
    public Long getAssociatedResourceId() {
        return this.associatedResourceId;
    }

    public void setAssociatedResourceId(Long associatedResourceId) {
        this.associatedResourceId = associatedResourceId;
    }

    public CISMode getCisMode() {
        return this.cisMode;
    }

    public void setCisMode(CISMode cisMode) {
        this.cisMode = cisMode;
    }

    @JsonIgnore
    @XmlTransient
    public Job getTimerJob() {
        return this.timerJob;
    }

    public void setTimerJob(Job timerJob) {
        this.timerJob = timerJob;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    public String getAssociatedGroupName() {
        return this.associatedGroupName;
    }

    public void setAssociatedGroupName(String associatedGroupName) {
        this.associatedGroupName = associatedGroupName;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        return this.getClass() == obj.getClass();
    }

    @Override
    public int compareTo(DistributionSite o) {
        return this.getName().compareToIgnoreCase(o.getName());
    }

    public List<Integer> getDependsOnSites() {
        return this.dependsOnSites;
    }

    public void setDependsOnSites(List<Integer> dependsOnSites) {
        this.dependsOnSites = dependsOnSites;
    }

    public ActionOnFailureOption getActionOnFailure() {
        return this.actionOnFailure;
    }

    public void setActionOnFailure(ActionOnFailureOption actionOnFailure) {
        this.actionOnFailure = actionOnFailure;
    }

    public Integer getRetryAttempt() {
        return this.retryAttempt;
    }

    public void setRetryAttempt(Integer retryAttempt) {
        this.retryAttempt = retryAttempt;
    }

    public Integer getRetryWaitTime() {
        return this.retryWaitTime;
    }

    public void setRetryWaitTime(Integer retryWaitTime) {
        this.retryWaitTime = retryWaitTime;
    }
}

