/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.util;

import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.util.NormalizationChange;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class NormalizedItem {
    private Title title;
    private boolean modified;
    private List<NormalizationChange> changes = new ArrayList<NormalizationChange>();
    private List<Integer> changeRuleSetIdList = new ArrayList<Integer>();

    public NormalizedItem(Title title) {
        this.title = title;
        this.modified = false;
    }

    public NormalizedItem(Title title, boolean modified) {
        this(title);
        this.modified = modified;
    }

    public Title getTitle() {
        return this.title;
    }

    public void setTitle(Title title) {
        this.title = title;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean modified) {
        this.modified = modified;
    }

    public List<NormalizationChange> getChanges() {
        return this.changes;
    }

    public void addChange(NormalizationChange change) {
        this.changes.add(change);
        int ruleSetId = change.getRuleSetId();
        if (!this.changeRuleSetIdList.contains(ruleSetId)) {
            this.changeRuleSetIdList.add(ruleSetId);
        }
    }

    public String getNormalizationChangeInfo() {
        if (!this.changes.isEmpty() && !this.changeRuleSetIdList.isEmpty()) {
            Collections.sort(this.changeRuleSetIdList);
            String ruleSetIdOutput = "Title normalized by normalization RuleSet: " + StringUtils.join(this.changeRuleSetIdList, (String)", ");
            return ruleSetIdOutput + ". ";
        }
        return "";
    }
}

