/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.util;

import com.tandbergtv.watchpoint.pmm.util.WorkflowCreationException;
import com.tandbergtv.watchpoint.routing.SoapMessageHelper;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.message.IMessage;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.producer.ComponentType;
import com.tandbergtv.workflow.message.producer.WorkflowCreationMessageDispatcher;
import com.tandbergtv.workflow.message.util.WPCLConverter;
import org.apache.log4j.Logger;

public class WorkflowCreationSender {
    private static final Logger logger = Logger.getLogger(WorkflowCreationSender.class);

    private WorkflowCreationSender() {
    }

    public static String send(IMessage msg) throws WorkflowCreationException {
        return WorkflowCreationSender.send(msg, new SoapMessageHelper());
    }

    public static String send(WorkflowMessage wfsMessage) throws WorkflowCreationException {
        return WorkflowCreationSender.send(wfsMessage, new SoapMessageHelper());
    }

    public static String send(IMessage msg, SoapMessageHelper soapMessageHelper) throws WorkflowCreationException {
        try {
            WorkflowMessage workflowMessage = new WPCLConverter().convert(msg);
            return WorkflowCreationSender.send(workflowMessage, soapMessageHelper);
        }
        catch (Exception e) {
            throw new WorkflowCreationException(e);
        }
    }

    public static String send(WorkflowMessage workflowMessage, SoapMessageHelper soapMessageHelper) throws WorkflowCreationException {
        try {
            soapMessageHelper.updateConvertedWorkflowMessage(workflowMessage);
            long startTime = System.currentTimeMillis();
            String createId = WorkflowCreationSender.getWorkflowCreationMessageDispatcher().sendCreationMessage(ComponentType.CORE, workflowMessage);
            logger.debug((Object)("Send message cost time " + (System.currentTimeMillis() - startTime) + "ms"));
            logger.debug((Object)("Got create id " + createId));
            return createId;
        }
        catch (Exception e) {
            throw new WorkflowCreationException(e);
        }
    }

    private static WorkflowCreationMessageDispatcher getWorkflowCreationMessageDispatcher() {
        return (WorkflowCreationMessageDispatcher)ServiceRegistry.getDefault().lookup("com.tandbergtv.workflow.message.producer.CreationMessageDispatcher");
    }
}

