/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.util.validation;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;

public class ValidationMessage {
    private String code;
    private String message;
    private List<String> properties = new ArrayList<String>();

    public ValidationMessage(String messageCode) {
        this.code = messageCode;
    }

    public ValidationMessage(String messageCode, String message, String ... messageProperties) {
        this.code = messageCode;
        if (messageProperties != null) {
            for (String p : messageProperties) {
                this.properties.add(p);
            }
        }
        this.message = this.substitute(message, messageProperties);
    }

    private String substitute(String message, String[] params) {
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                String p = Matcher.quoteReplacement(params[i]);
                message = message.replaceAll("\\{\\s*" + i + "\\s*\\}", p);
            }
        }
        return message;
    }

    public String getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public List<String> getProperties() {
        return this.properties;
    }

    public String getProperty(int index) {
        return index >= 0 && index < this.properties.size() ? this.properties.get(index) : null;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ValidationMessage[");
        builder.append(this.code);
        builder.append(" : ");
        builder.append(this.properties.toString());
        builder.append("]");
        return builder.toString();
    }
}

