/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.search;

import com.ericsson.cms.search.ESField;
import com.ericsson.cms.search.util.ElasticSearchUtil;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class ESMetadataFields {
    private Map<String, ESField> fields = new HashMap<String, ESField>();

    public void addField(String key, Object value) {
        if (key == null || value == null) {
            return;
        }
        value = ElasticSearchUtil.processDate(value);
        ESField field = this.fields.get(key);
        if (field == null) {
            field = new ESField();
            this.fields.put(key, field);
        }
        field.addValue(value);
    }

    public void build(XContentBuilder bld) throws Exception {
        if (bld == null) {
            return;
        }
        for (Map.Entry<String, ESField> entry : this.fields.entrySet()) {
            String key = entry.getKey();
            ESField field = entry.getValue();
            if (field.isMultiValue()) {
                ElasticSearchUtil.addArray(bld, key, field.getMultiValue());
                continue;
            }
            bld.field(key, field.getSingleValue());
        }
    }
}

