/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.search;

import com.ericsson.cms.criteria.ExpList;
import com.ericsson.cms.criteria.ExpNode;
import com.ericsson.cms.search.CountByTermSearchCommand;
import com.ericsson.cms.search.ElasticSearchIndexType;
import com.ericsson.cms.search.FileSearchHelper;
import com.ericsson.cms.search.FileSearchResult;
import com.ericsson.cms.search.IElasticSearchService;
import com.ericsson.cms.search.SearchParameters;
import com.ericsson.cms.search.TitleSearchResult;
import com.ericsson.cms.search.cmd.AdvancedSearchCommand;
import com.ericsson.cms.search.cmd.AssociateTrackingSiteTitlesCommand;
import com.ericsson.cms.search.cmd.ClusterWideSearchCountCommand;
import com.ericsson.cms.search.cmd.DeleteSeasonsCommand;
import com.ericsson.cms.search.cmd.DeleteTitleCommand;
import com.ericsson.cms.search.cmd.DeleteTrackingSiteTitleCommand;
import com.ericsson.cms.search.cmd.DeleteTrackingSiteTitlesCommand;
import com.ericsson.cms.search.cmd.DissociateTrackingSiteTitlesCommand;
import com.ericsson.cms.search.cmd.MultiFieldSearchCommand;
import com.ericsson.cms.search.cmd.QuickSearchCommand;
import com.ericsson.cms.search.cmd.SaveSeasonCommand;
import com.ericsson.cms.search.cmd.SaveTitleCommand;
import com.ericsson.cms.search.cmd.TitleCountCommand;
import com.ericsson.cms.search.cmd.TotalDurationCommand;
import com.ericsson.cms.search.cmd.UpdateMasterTitleStatusCommand;
import com.ericsson.cms.search.cmd.UpdateSiteStatusCommand;
import com.ericsson.cms.search.cmd.UpdateSiteStatusesCommand;
import com.ericsson.cms.search.exception.TitleSearchException;
import com.ericsson.cms.search.util.ElasticSearchConnection;
import com.ericsson.cms.search.util.ElasticSearchUtil;
import com.ericsson.cms.search.util.SiteStatusCollection;
import com.ericsson.cms.search.util.UpdateSiteStatusInfo;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.watchpoint.pmm.core.PMMException;
import com.tandbergtv.watchpoint.pmm.dao.hibernate.HibernateContext;
import com.tandbergtv.watchpoint.pmm.entities.Partner;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.partner.IPartnerManagement;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.io.File;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.springframework.util.CollectionUtils;

public class ElasticSearchService
implements IElasticSearchService {
    private static final String CONFIG_FILE = "/opt/tandbergtv/cms/conf/contentMgmt/ElasticSearch.properties";
    private static Logger logger = Logger.getLogger(ElasticSearchService.class);
    private IPartnerManagement partnerManager = (IPartnerManagement)ServiceRegistry.getDefault().lookup(IPartnerManagement.class);
    private ElasticSearchConnection esConnection;
    private boolean cacheAssetsRequiringFiles = false;

    public String getServiceName() {
        return "ElasticSearchService";
    }

    public void start() {
        logger.info((Object)"Starting ElasticSearch service...");
        try {
            this.esConnection = new ElasticSearchConnection(CONFIG_FILE);
        }
        catch (Exception ex) {
            logger.error((Object)"Could not connect to ElasticSearch.", (Throwable)ex);
        }
        logger.info((Object)"Started ElasticSearch service.");
    }

    public void setCacheAssetsRequiringFiles(boolean b) {
        this.cacheAssetsRequiringFiles = b;
    }

    public void stop() {
        logger.info((Object)"Stopping ElasticSearch service...");
        this.esConnection.close();
        logger.info((Object)"Stopped ElasticSearch service.");
    }

    @Override
    public boolean saveTitle(Title title) throws Exception {
        this.validateElasticSearchConnection();
        if (title == null || title.getId() == null) {
            logger.error((Object)"Title is null or Title ID is null");
            return false;
        }
        if (!title.getIsActive().booleanValue()) {
            logger.warn((Object)("Title ID : " + title.getId() + " is already deleted"));
            return false;
        }
        ElasticSearchIndexType titleType = ElasticSearchUtil.getTitleType(title);
        logger.info((Object)("Saving " + (Object)((Object)titleType) + " title " + title.getId()));
        SaveTitleCommand command = new SaveTitleCommand(titleType, title, this.cacheAssetsRequiringFiles);
        if (!this.esConnection.runCommandHA(command)) {
            this.saveFailedTitleId(titleType, title.getId());
            return false;
        }
        if (titleType == ElasticSearchIndexType.SERIES) {
            DeleteSeasonsCommand deleteCommand = new DeleteSeasonsCommand(title.getId());
            if (!this.esConnection.runCommandHA(deleteCommand)) {
                this.saveFailedTitleId(titleType, title.getId());
                return false;
            }
            List seasons = title.getAssets("SEASON");
            for (Asset season : seasons) {
                SaveSeasonCommand saveSeasonCommand = new SaveSeasonCommand(title, season);
                if (this.esConnection.runCommandHA(saveSeasonCommand)) continue;
                this.saveFailedTitleId(titleType, title.getId());
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean deleteTitle(Title title) throws Exception {
        if (title == null) {
            return false;
        }
        if (title.getId() == null) {
            logger.error((Object)"Title ID is null");
            return false;
        }
        ElasticSearchIndexType titleType = ElasticSearchUtil.getTitleType(title);
        return this.deleteTitle(titleType, title.getId());
    }

    @Override
    public boolean deleteTitle(ElasticSearchIndexType titleType, Long titleId) throws Exception {
        DeleteSeasonsCommand deleteCommand;
        this.validateElasticSearchConnection();
        logger.info((Object)("Deleting " + (Object)((Object)titleType) + " title " + titleId));
        DeleteTitleCommand command = new DeleteTitleCommand(titleType, titleId);
        if (!this.esConnection.runCommandHA(command)) {
            this.saveFailedTitleId(titleType, titleId);
            return false;
        }
        if (titleType == ElasticSearchIndexType.SERIES && !this.esConnection.runCommandHA(deleteCommand = new DeleteSeasonsCommand(titleId))) {
            this.saveFailedTitleId(titleType, titleId);
            return false;
        }
        return true;
    }

    @Override
    public void saveFailedTitleId(ElasticSearchIndexType titleType, long titleId) {
        logger.warn((Object)("Saving title ID " + titleId + " for later reindexing."));
        Session session = HibernateContext.getContext().getCurrentSession();
        String sql = "select 1 from mdm_elastic_search_failed_titles where title_id=" + titleId;
        SQLQuery query = session.createSQLQuery(sql);
        if (CollectionUtils.isEmpty((Collection)query.list())) {
            sql = String.format("insert into mdm_elastic_search_failed_titles (title_type, title_id) values (%d , %d) ", titleType.ordinal(), titleId);
            query = session.createSQLQuery(sql);
            query.executeUpdate();
        }
    }

    @Override
    public void clearSuccessfulTitleId(long titleId) {
        logger.info((Object)("Clearing any queued record for saving title ID " + titleId + " after successful syncing with ElasticSearch."));
        Session session = HibernateContext.getContext().getCurrentSession();
        SQLQuery query = session.createSQLQuery("DELETE \n  FROM mdm_elastic_search_failed_titles where title_id = " + titleId + ";");
        int recordCount = query.executeUpdate();
        logger.info((Object)("\tNumber of records deleted from queue: " + recordCount));
    }

    @Override
    public TitleSearchResult quickSearch(String searchString, SearchParameters params) throws Exception {
        this.validateElasticSearchConnection();
        QuickSearchCommand command = new QuickSearchCommand(searchString, params);
        if (this.esConnection.runCommandOnce(command)) {
            return command.getSearchResult();
        }
        throw command.getException();
    }

    @Override
    public TitleSearchResult quickSearchWithAdditionalFilters(String searchString, SearchParameters params, ExpNode rootNode) throws Exception {
        this.validateElasticSearchConnection();
        QuickSearchCommand command = new QuickSearchCommand(searchString, params, rootNode);
        if (this.esConnection.runCommandOnce(command)) {
            return command.getSearchResult();
        }
        throw command.getException();
    }

    @Override
    public TitleSearchResult advancedSearch(ExpNode rootNode, SearchParameters params) throws Exception {
        this.validateElasticSearchConnection();
        AdvancedSearchCommand command = new AdvancedSearchCommand(rootNode, params);
        if (this.esConnection.runCommandOnce(command)) {
            return command.getSearchResult();
        }
        throw command.getException();
    }

    @Override
    public long getClusterWideSearchCount(Set<String> fields, String value) throws Exception {
        this.validateElasticSearchConnection();
        ClusterWideSearchCountCommand command = new ClusterWideSearchCountCommand(fields, value);
        if (this.esConnection.runCommandOnce(command)) {
            return command.getSearchResult().getCount();
        }
        throw command.getException();
    }

    @Override
    public Map<Long, Long> countSiteById(ExpNode rootNode, SearchParameters params) throws Exception {
        this.validateElasticSearchConnection();
        CountByTermSearchCommand command = new CountByTermSearchCommand("distributionSiteId", rootNode, params);
        if (this.esConnection.runCommandOnce(command)) {
            LinkedHashMap<Long, Long> countBySite = new LinkedHashMap<Long, Long>();
            for (Map.Entry<String, Long> entry : command.getAggregationSearchResults().entrySet()) {
                countBySite.put(Long.valueOf(entry.getKey()), entry.getValue());
            }
            return countBySite;
        }
        throw command.getException();
    }

    @Override
    public List<Long> advancedSearchIds(ExpNode rootNode, SearchParameters params) throws Exception {
        this.validateElasticSearchConnection();
        AdvancedSearchCommand command = new AdvancedSearchCommand(rootNode, params);
        command.setFetchIdsOnly(true);
        if (this.esConnection.runCommandOnce(command)) {
            return command.getSearchResultIds();
        }
        throw command.getException();
    }

    @Override
    public void updateMasterTitleDistributionStatus(long titleId, String status) throws Exception {
        this.validateElasticSearchConnection();
        UpdateMasterTitleStatusCommand cmd = new UpdateMasterTitleStatusCommand(titleId, status);
        if (!this.esConnection.runCommandHA(cmd)) {
            this.saveFailedTitleId(ElasticSearchIndexType.MASTER, titleId);
        }
    }

    @Override
    public void updateSiteTitleStatus(long titleId, UpdateSiteStatusInfo siteInfo) throws Exception {
        logger.info((Object)("Updating " + (Object)((Object)siteInfo.siteType) + " site title status: titleId =  " + titleId + ", siteId = " + siteInfo.siteId + ", status = " + siteInfo.status));
        this.validateElasticSearchConnection();
        UpdateSiteStatusCommand command = new UpdateSiteStatusCommand(titleId, siteInfo);
        if (!this.esConnection.runCommandHA(command)) {
            this.saveFailedTitleId(ElasticSearchIndexType.SITE, titleId);
        }
    }

    @Override
    public void updateSiteTitleStatuses(long titleId) throws Exception {
        this.updateSiteTitleStatuses(titleId, null);
    }

    @Override
    public void updateSiteTitleStatuses(long titleId, SiteStatusCollection statuses) throws Exception {
        logger.info((Object)("Updating site title statuses: titleId =  " + titleId));
        this.validateElasticSearchConnection();
        UpdateSiteStatusesCommand command = new UpdateSiteStatusesCommand(titleId, statuses);
        if (!this.esConnection.runCommandHA(command)) {
            this.saveFailedTitleId(ElasticSearchIndexType.SITE, titleId);
        }
    }

    @Override
    public void deleteTrackingSiteTitle(long titleId, int trackingSiteId) throws Exception {
        logger.info((Object)("Deleting tracking site title: titleId = " + titleId + ", trackingSiteId = " + trackingSiteId));
        this.validateElasticSearchConnection();
        DeleteTrackingSiteTitleCommand command = new DeleteTrackingSiteTitleCommand(titleId, trackingSiteId);
        if (!this.esConnection.runCommandHA(command)) {
            this.saveFailedTitleId(ElasticSearchIndexType.SITE, titleId);
        }
    }

    @Override
    public void deleteTrackingSiteTitles(int trackingSiteId, int distributionSiteId) throws Exception {
        logger.info((Object)("Deleting tracking site " + trackingSiteId + " with distribution site " + distributionSiteId));
        this.validateElasticSearchConnection();
        DeleteTrackingSiteTitlesCommand command = new DeleteTrackingSiteTitlesCommand(trackingSiteId, distributionSiteId);
        Thread t = new Thread(new ElaticSearchProcessor(command));
        t.start();
    }

    @Override
    public void associateTrackingSiteTitles(int trackingSiteId, int distributionSiteId, Date statusUpdatedTime) throws Exception {
        logger.info((Object)("Associating tracking site " + trackingSiteId + " with distribution site " + distributionSiteId));
        this.validateElasticSearchConnection();
        AssociateTrackingSiteTitlesCommand command = new AssociateTrackingSiteTitlesCommand(trackingSiteId, distributionSiteId, statusUpdatedTime);
        Thread t = new Thread(new ElaticSearchProcessor(command));
        t.start();
    }

    @Override
    public void dissociateTrackingSiteTitles(int trackingSiteId, int distributionSiteId) throws Exception {
        logger.info((Object)("Dissociating tracking site " + trackingSiteId + " from distribution site " + distributionSiteId));
        this.validateElasticSearchConnection();
        DissociateTrackingSiteTitlesCommand command = new DissociateTrackingSiteTitlesCommand(trackingSiteId, distributionSiteId);
        Thread t = new Thread(new ElaticSearchProcessor(command));
        t.start();
    }

    @Override
    public long getTitleCount(ExpNode rootNode, SearchParameters params) throws Exception {
        this.validateElasticSearchConnection();
        TitleCountCommand command = new TitleCountCommand(rootNode, params);
        if (this.esConnection.runCommandOnce(command)) {
            return command.getTitleCount();
        }
        throw command.getException();
    }

    private void validateElasticSearchConnection() throws TitleSearchException {
        if (this.esConnection == null) {
            String msg = "ElasticSearch client is not initialized.";
            logger.error((Object)msg);
            throw new TitleSearchException(msg);
        }
    }

    @Override
    public double getTotalDuration(String providerId, Date startDate, Date endDate) throws Exception {
        this.validateElasticSearchConnection();
        TotalDurationCommand command = new TotalDurationCommand(providerId, startDate, endDate);
        if (this.esConnection.runCommandOnce(command)) {
            return command.getTotalDuration();
        }
        throw command.getException();
    }

    @Override
    public FileSearchResult fileSearch(String fileName, String providerId) throws Exception {
        long partnerId;
        FileSearchResult ret = new FileSearchResult();
        try {
            partnerId = this.getPartnerIdFromProviderId(providerId);
        }
        catch (PMMException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return ret;
        }
        File file = new File(fileName);
        fileName = file.getName();
        SearchParameters params = FileSearchHelper.createSearchParameters();
        ExpList rootNode = FileSearchHelper.createSearchCriteria(fileName, partnerId);
        TitleSearchResult tsResult = this.advancedSearch((ExpNode)rootNode, params);
        ret = FileSearchHelper.processSearchResults(fileName, tsResult);
        return ret;
    }

    private long getPartnerIdFromProviderId(String providerId) throws PMMException {
        Partner partner = this.partnerManager.getSourceOrSelfPartner(providerId);
        return partner.getId();
    }

    @Override
    public TitleSearchResult multiFieldSearch(String searchString, SearchParameters params) throws TitleSearchException {
        this.validateElasticSearchConnection();
        MultiFieldSearchCommand command = new MultiFieldSearchCommand(searchString, params);
        if (this.esConnection.runCommandOnce(command)) {
            return command.getSearchResult();
        }
        throw new TitleSearchException(command.getException());
    }

    private class ElaticSearchProcessor
    implements Runnable {
        private ElasticSearchConnection.Command cmd;

        public ElaticSearchProcessor(ElasticSearchConnection.Command cmd) {
            this.cmd = cmd;
        }

        @Override
        public void run() {
            ElasticSearchService.this.esConnection.runCommandOnce(this.cmd);
        }
    }
}

