/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.search;

import com.ericsson.cms.criteria.ExpList;
import com.ericsson.cms.criteria.ExpNode;
import com.ericsson.cms.criteria.ExpValue;
import com.ericsson.cms.criteria.FieldType;
import com.ericsson.cms.criteria.LogicalOperator;
import com.ericsson.cms.criteria.Predicate;
import com.ericsson.cms.criteria.PredicateRightValue;
import com.ericsson.cms.search.ElasticSearchIndexType;
import com.ericsson.cms.search.FileSearchResult;
import com.ericsson.cms.search.SearchParameters;
import com.ericsson.cms.search.TitleSearchResult;
import com.tandbergtv.watchpoint.pmm.title.TitleUtil;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;

public class FileSearchHelper {
    private static Logger logger = Logger.getLogger(FileSearchHelper.class);
    private static final String SEMI_COLON = ";";
    private static final String DEFAULT_DATA_TYPE_STRING = "string";

    public static SearchParameters createSearchParameters() {
        SearchParameters params = new SearchParameters();
        params.setTitleIndexType(ElasticSearchIndexType.MASTER);
        params.setFields(Arrays.asList(new SearchParameters.FieldInfo("contentMapping", DEFAULT_DATA_TYPE_STRING)));
        params.setPageSize(100);
        return params;
    }

    public static ExpList createSearchCriteria(String fileName, long partnerId) {
        ExpList rootNode = new ExpList();
        PredicateRightValue predicate = new PredicateRightValue();
        predicate.setFieldTypeLhs(FieldType.PMM_TITLE);
        predicate.setFieldLeft("contentMapping");
        predicate.setDataType(DEFAULT_DATA_TYPE_STRING);
        predicate.setOperator(LogicalOperator.STARTSWITH);
        predicate.setValue(fileName + SEMI_COLON);
        ExpValue node = new ExpValue((Predicate)predicate);
        rootNode.addItem((ExpNode)node);
        predicate = new PredicateRightValue();
        predicate.setFieldTypeLhs(FieldType.PMM_TITLE);
        predicate.setFieldLeft("partnerId");
        predicate.setDataType(DEFAULT_DATA_TYPE_STRING);
        predicate.setOperator(LogicalOperator.EQUAL);
        predicate.setValue(String.valueOf(partnerId));
        node = new ExpValue((Predicate)predicate);
        rootNode.addItem((ExpNode)node);
        return rootNode;
    }

    public static FileSearchResult processSearchResults(String fileName, TitleSearchResult tsResult) {
        FileSearchResult result = new FileSearchResult();
        if (tsResult.getCount() == 0L) {
            return result;
        }
        int n = tsResult.getRows().size();
        for (int i = 0; i < n; ++i) {
            TitleSearchResult.SearchRow row = (TitleSearchResult.SearchRow)tsResult.getRows().get(i);
            Object obj = row.getValue(0);
            if (obj instanceof List) {
                FileSearchHelper.processAssetList(result, fileName, row.getId(), (List)obj);
                continue;
            }
            LinkedList<String> list = new LinkedList<String>();
            list.add(obj.toString());
            FileSearchHelper.processAssetList(result, fileName, row.getId(), list);
        }
        return result;
    }

    private static void processAssetList(FileSearchResult result, String fileName, long titleId, List<String> list) {
        for (String str : list) {
            int firstIdx = str.indexOf(SEMI_COLON);
            String assetFileName = "";
            if (firstIdx > 0) {
                assetFileName = str.substring(0, firstIdx);
            }
            if (!TitleUtil.compareFileNames(assetFileName, fileName)) continue;
            int idx = str.lastIndexOf(SEMI_COLON);
            if (idx < 0) {
                logger.error((Object)("Missing ';' separator in contentMapping value: " + str));
                continue;
            }
            String strAssetId = str.substring(idx + 1);
            long assetId = Long.parseLong(strAssetId);
            result.addTitleRecord(titleId, assetId);
        }
    }
}

