/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.search.cmd;

import com.ericsson.cms.criteria.ExpNode;
import com.ericsson.cms.search.AdvancedSearchQueryBuilder;
import com.ericsson.cms.search.SearchParameters;
import com.ericsson.cms.search.cmd.BaseSearchCommand;
import com.ericsson.cms.search.util.ElasticSearchConnection;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.index.query.QueryBuilder;

public class AdvancedSearchCommand
extends BaseSearchCommand {
    protected ExpNode rootNode;
    protected boolean fetchIdsOnly = false;

    public AdvancedSearchCommand(ExpNode rootNode, SearchParameters params) {
        super(params);
        this.rootNode = rootNode;
    }

    public void setFetchIdsOnly(boolean b) {
        this.fetchIdsOnly = b;
    }

    protected boolean isFetchIdsOnly() {
        return this.fetchIdsOnly;
    }

    @Override
    public boolean run(ElasticSearchConnection esConnection) {
        try {
            SearchRequestBuilder searchRequest = this.createSearchRequest(esConnection);
            this.addAdvancedSearchFilter(searchRequest);
            this.search(esConnection, searchRequest);
            return true;
        }
        catch (Exception ex) {
            this.setException(ex);
            return false;
        }
    }

    protected void addAdvancedSearchFilter(SearchRequestBuilder searchRequest) {
        if (this.fetchIdsOnly) {
            searchRequest.setFetchSource(false);
        }
        QueryBuilder rootFilter = null;
        if (this.rootNode != null) {
            AdvancedSearchQueryBuilder query = new AdvancedSearchQueryBuilder(this.params.getTitleIndexType());
            rootFilter = query.build(this.rootNode);
        }
        QueryBuilder filter = this.addPartnerIdFilter(rootFilter, this.params.getPartnerIds());
        logger.debug((Object)("Advanced search filter: " + filter));
        if (filter != null) {
            searchRequest.setPostFilter(filter);
        }
    }

    @Override
    protected void search(ElasticSearchConnection esConnection, SearchRequestBuilder searchRequest) {
        if (this.fetchIdsOnly) {
            super.searchIds(esConnection, searchRequest);
        } else {
            super.search(esConnection, searchRequest);
        }
    }
}

