/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.search.cmd;

import com.ericsson.cms.search.ElasticSearchIndexType;
import com.ericsson.cms.search.cmd.BaseTitleCommand;
import com.ericsson.cms.search.util.ElasticSearchConnection;
import org.apache.log4j.Logger;
import org.elasticsearch.action.delete.DeleteRequestBuilder;
import org.elasticsearch.client.transport.TransportClient;

public class DeleteSeasonsCommand
extends BaseTitleCommand {
    protected static Logger logger = Logger.getLogger(DeleteSeasonsCommand.class);
    private long seriesTitleId;

    public DeleteSeasonsCommand(long seriesTitleId) {
        super(ElasticSearchIndexType.SEASON, "season");
        this.seriesTitleId = seriesTitleId;
    }

    @Override
    public boolean run(ElasticSearchConnection esConnection) {
        try {
            TransportClient client = esConnection.getTransportClient();
            DeleteRequestBuilder deleteRequest = client.prepareDelete(this.indexName, "seriesTitleId", String.valueOf(this.seriesTitleId));
            deleteRequest.execute().actionGet(esConnection.getWriteTimeoutMs());
            return true;
        }
        catch (Exception ex) {
            logger.error((Object)("Could not delete seasons of series title with id = " + this.seriesTitleId), (Throwable)ex);
            return false;
        }
    }
}

