/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.search.cmd;

import com.ericsson.cms.search.ElasticSearchIndexType;
import com.ericsson.cms.search.cmd.BaseTitleCommand;
import com.ericsson.cms.search.util.ElasticSearchConnection;
import org.apache.log4j.Logger;
import org.elasticsearch.action.delete.DeleteRequestBuilder;
import org.elasticsearch.client.transport.TransportClient;

public class DeleteTitleCommand
extends BaseTitleCommand {
    private static Logger logger = Logger.getLogger(DeleteTitleCommand.class);
    private String strTitleId;

    public DeleteTitleCommand(ElasticSearchIndexType titleType, long titleId) {
        super(titleType);
        this.strTitleId = String.valueOf(titleId);
    }

    @Override
    public boolean run(ElasticSearchConnection esConnection) {
        TransportClient esClient = esConnection.getTransportClient();
        try {
            DeleteRequestBuilder bld = esClient.prepareDelete(this.indexName, "title", this.strTitleId);
            bld.execute().actionGet(esConnection.getWriteTimeoutMs());
            return true;
        }
        catch (Exception ex) {
            logger.error((Object)("Could not delete title " + this.strTitleId), (Throwable)ex);
            return false;
        }
    }
}

