/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.search.cmd;

import com.ericsson.cms.search.ElasticSearchIndexType;
import com.ericsson.cms.search.cmd.BaseTitleCommand;
import com.ericsson.cms.search.cmd.SaveTitleUtils;
import com.ericsson.cms.search.util.ElasticSearchConnection;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import org.apache.log4j.Logger;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class SaveTitleCommand
extends BaseTitleCommand {
    private static Logger logger = Logger.getLogger(SaveTitleCommand.class);
    private String strTitleId;
    private XContentBuilder source;

    public SaveTitleCommand(ElasticSearchIndexType titleType, Title title, boolean cacheAssetsRequiringFiles) throws Exception {
        super(titleType);
        this.strTitleId = String.valueOf(title.getId());
        this.source = SaveTitleUtils.computeTitleSource(title, titleType, cacheAssetsRequiringFiles);
    }

    @Override
    public boolean run(ElasticSearchConnection esConnection) {
        TransportClient esClient = esConnection.getTransportClient();
        try {
            IndexRequestBuilder bld = esClient.prepareIndex(this.indexName, this.typeName, this.strTitleId);
            bld.setSource(this.source);
            bld.execute().actionGet(esConnection.getWriteTimeoutMs());
            return true;
        }
        catch (Exception ex) {
            logger.error((Object)("Could not index title " + this.strTitleId), (Throwable)ex);
            return false;
        }
    }
}

