/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.search.cmd;

import com.ericsson.cms.search.ElasticSearchIndexType;
import com.ericsson.cms.search.ElasticSearchTitleBuilder;
import com.ericsson.cms.search.cmd.BaseTitleCommand;
import com.ericsson.cms.search.util.ElasticSearchConnection;
import org.apache.log4j.Logger;
import org.elasticsearch.action.get.GetRequestBuilder;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.client.transport.TransportClient;

public class UpdateMasterTitleStatusCommand
extends BaseTitleCommand {
    private static Logger logger = Logger.getLogger(UpdateMasterTitleStatusCommand.class);
    private String strTitleId;
    private String strDistStatus;

    public UpdateMasterTitleStatusCommand(long titleId, String distributionStatus) {
        super(ElasticSearchIndexType.MASTER);
        this.strTitleId = String.valueOf(titleId);
        this.strDistStatus = distributionStatus;
    }

    @Override
    public boolean run(ElasticSearchConnection esConnection) {
        TransportClient client = esConnection.getTransportClient();
        try {
            GetRequestBuilder request = client.prepareGet(this.indexName, this.typeName, this.strTitleId);
            GetResponse response = (GetResponse)request.execute().actionGet(esConnection.getReadTimeoutMs());
            long version = response.getVersion();
            String oldSource = response.getSourceAsString();
            ElasticSearchTitleBuilder titleBuilder = new ElasticSearchTitleBuilder();
            String newSource = titleBuilder.updateTitle(oldSource, this.strDistStatus);
            if (newSource == null) {
                return true;
            }
            IndexRequestBuilder saveRequest = client.prepareIndex(this.indexName, "title", this.strTitleId);
            saveRequest.setSource(newSource);
            saveRequest.setVersion(version);
            saveRequest.execute().actionGet(esConnection.getWriteTimeoutMs());
            return true;
        }
        catch (Exception ex) {
            logger.error((Object)("Could not update title " + this.strTitleId), (Throwable)ex);
            return false;
        }
    }
}

