/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.search.cmd;

import com.ericsson.cms.search.ElasticSearchIndexType;
import com.ericsson.cms.search.ElasticSearchSiteTitleBuilder;
import com.ericsson.cms.search.cmd.BaseTitleCommand;
import com.ericsson.cms.search.util.ElasticSearchConnection;
import com.ericsson.cms.search.util.UpdateSiteStatusInfo;
import org.apache.log4j.Logger;
import org.elasticsearch.action.get.GetRequestBuilder;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.client.transport.TransportClient;

public class UpdateSiteStatusCommand
extends BaseTitleCommand {
    private static Logger logger = Logger.getLogger(UpdateSiteStatusCommand.class);
    private String strTitleId;
    private UpdateSiteStatusInfo siteInfo;

    public UpdateSiteStatusCommand(long titleId, UpdateSiteStatusInfo siteInfo) {
        this(siteInfo);
        this.strTitleId = String.valueOf(titleId);
    }

    public UpdateSiteStatusCommand(UpdateSiteStatusInfo siteInfo) {
        super(ElasticSearchIndexType.SITE);
        this.siteInfo = siteInfo;
    }

    public void setTitleId(long titleId) {
        this.strTitleId = String.valueOf(titleId);
    }

    @Override
    public boolean run(ElasticSearchConnection esConnection) {
        TransportClient client = esConnection.getTransportClient();
        logger.debug((Object)"::::::::::::::::::UpdateSiteStatusCommand started");
        try {
            GetRequestBuilder request = client.prepareGet(this.indexName, this.typeName, this.strTitleId);
            GetResponse response = (GetResponse)request.execute().actionGet(esConnection.getReadTimeoutMs());
            long version = response.getVersion();
            String oldSource = response.getSourceAsString();
            ElasticSearchSiteTitleBuilder titleBuilder = new ElasticSearchSiteTitleBuilder();
            String newSource = titleBuilder.updateTitle(oldSource, this.siteInfo);
            if (newSource == null) {
                return true;
            }
            IndexRequestBuilder saveRequest = client.prepareIndex(this.indexName, "title", this.strTitleId);
            saveRequest.setSource(newSource);
            saveRequest.setVersion(version);
            saveRequest.execute().actionGet(esConnection.getWriteTimeoutMs());
            logger.debug((Object)"::::::::::::::::::UpdateSiteStatusCommand completed");
            return true;
        }
        catch (Exception ex) {
            logger.error((Object)("Could not update title " + this.strTitleId), (Throwable)ex);
            return false;
        }
    }
}

