/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.search.util;

import java.util.HashSet;
import java.util.Set;

public class AssetPathValidator {
    private static AssetPathValidator instance = new AssetPathValidator();
    private Set<String> allPackagePaths;
    private Set<String> allSeriesPaths;
    private Set<String> allSeasonPaths;
    private Set<String> fixablePackagePaths;
    private Set<String> fixableSeriesPaths;
    private Set<String> fixableSeasonPaths;

    private AssetPathValidator() {
        this.createPackagePaths();
        this.createSeriesPaths();
        this.createSeasonPaths();
    }

    private void createPackagePaths() {
        this.allPackagePaths = new HashSet<String>();
        this.addPath(this.allPackagePaths, "PACKAGE");
        this.addPath(this.allPackagePaths, "PACKAGE/TITLE");
        this.addPath(this.allPackagePaths, "PACKAGE/DISPLAY");
        this.addPath(this.allPackagePaths, "PACKAGE/MOVIE");
        this.addPath(this.allPackagePaths, "PACKAGE/MOVIE/LOGICALCLIP");
        this.addPath(this.allPackagePaths, "PACKAGE/PREVIEW");
        this.addPath(this.allPackagePaths, "PACKAGE/PREVIEW/LOGICALCLIP");
        this.addPath(this.allPackagePaths, "PACKAGE/MOVIESEGMENTGROUP");
        this.addPath(this.allPackagePaths, "PACKAGE/PREVIEWSEGMENTGROUP");
        this.addPath(this.allPackagePaths, "PACKAGE/GAME");
        this.addPath(this.allPackagePaths, "PACKAGE/POSTER");
        this.addPath(this.allPackagePaths, "PACKAGE/BOXCOVER");
        this.addPath(this.allPackagePaths, "PACKAGE/TRICK");
        this.addPath(this.allPackagePaths, "PACKAGE/BARKER");
        this.addPath(this.allPackagePaths, "PACKAGE/ENCRYPTED");
        this.addPath(this.allPackagePaths, "PACKAGE/AUDIO");
        this.fixablePackagePaths = new HashSet<String>();
        this.addPath(this.fixablePackagePaths, "TITLE");
        this.addPath(this.fixablePackagePaths, "DISPLAY");
        this.addPath(this.fixablePackagePaths, "MOVIE");
        this.addPath(this.fixablePackagePaths, "MOVIE/LOGICALCLIP");
        this.addPath(this.fixablePackagePaths, "PREVIEW");
        this.addPath(this.fixablePackagePaths, "PREVIEW/LOGICALCLIP");
        this.addPath(this.fixablePackagePaths, "MOVIESEGMENTGROUP");
        this.addPath(this.fixablePackagePaths, "PREVIEWSEGMENTGROUP");
        this.addPath(this.fixablePackagePaths, "GAME");
        this.addPath(this.fixablePackagePaths, "POSTER");
        this.addPath(this.fixablePackagePaths, "BOXCOVER");
        this.addPath(this.fixablePackagePaths, "TRICK");
        this.addPath(this.fixablePackagePaths, "BARKER");
        this.addPath(this.fixablePackagePaths, "ENCRYPTED");
        this.addPath(this.fixablePackagePaths, "AUDIO");
    }

    private void createSeriesPaths() {
        this.allSeriesPaths = new HashSet<String>();
        this.addPath(this.allSeriesPaths, "SERIES");
        this.addPath(this.allSeriesPaths, "SERIES/TITLE");
        this.addPath(this.allSeriesPaths, "SERIES/DISPLAY");
        this.addPath(this.allSeriesPaths, "SERIES/MOVIE");
        this.addPath(this.allSeriesPaths, "SERIES/MOVIE/LOGICALCLIP");
        this.addPath(this.allSeriesPaths, "SERIES/PREVIEW");
        this.addPath(this.allSeriesPaths, "SERIES/PREVIEW/LOGICALCLIP");
        this.addPath(this.allSeriesPaths, "SERIES/MOVIESEGMENTGROUP");
        this.addPath(this.allSeriesPaths, "SERIES/PREVIEWSEGMENTGROUP");
        this.addPath(this.allSeriesPaths, "SERIES/GAME");
        this.addPath(this.allSeriesPaths, "SERIES/POSTER");
        this.addPath(this.allSeriesPaths, "SERIES/BOXCOVER");
        this.addPath(this.allSeriesPaths, "SERIES/TRICK");
        this.addPath(this.allSeriesPaths, "SERIES/BARKER");
        this.addPath(this.allSeriesPaths, "SERIES/ENCRYPTED");
        this.addPath(this.allSeriesPaths, "SERIES/AUDIO");
        this.addPath(this.allSeriesPaths, "SERIES/SEASON");
        this.addPath(this.allSeriesPaths, "SERIES/SEASON/POSTER");
        this.addPath(this.allSeriesPaths, "SERIES/SEASON/BOXCOVER");
        this.fixableSeriesPaths = new HashSet<String>();
        this.addPath(this.fixableSeriesPaths, "TITLE");
        this.addPath(this.fixableSeriesPaths, "DISPLAY");
        this.addPath(this.fixableSeriesPaths, "MOVIE");
        this.addPath(this.fixableSeriesPaths, "MOVIE/LOGICALCLIP");
        this.addPath(this.fixableSeriesPaths, "PREVIEW");
        this.addPath(this.fixableSeriesPaths, "PREVIEW/LOGICALCLIP");
        this.addPath(this.fixableSeriesPaths, "MOVIESEGMENTGROUP");
        this.addPath(this.fixableSeriesPaths, "PREVIEWSEGMENTGROUP");
        this.addPath(this.fixableSeriesPaths, "GAME");
        this.addPath(this.fixableSeriesPaths, "POSTER");
        this.addPath(this.fixableSeriesPaths, "BOXCOVER");
        this.addPath(this.fixableSeriesPaths, "TRICK");
        this.addPath(this.fixableSeriesPaths, "BARKER");
        this.addPath(this.fixableSeriesPaths, "ENCRYPTED");
        this.addPath(this.fixableSeriesPaths, "AUDIO");
        this.addPath(this.fixableSeriesPaths, "SEASON");
        this.addPath(this.fixableSeriesPaths, "SEASON/POSTER");
        this.addPath(this.fixableSeriesPaths, "SEASON/BOXCOVER");
    }

    private void createSeasonPaths() {
        this.allSeasonPaths = new HashSet<String>();
        this.addPath(this.allSeasonPaths, "SERIES/SEASON");
        this.addPath(this.allSeasonPaths, "SERIES/SEASON/POSTER");
        this.addPath(this.allSeasonPaths, "SERIES/SEASON/BOXCOVER");
        this.fixableSeasonPaths = new HashSet<String>();
        this.addPath(this.fixableSeasonPaths, "SEASON");
        this.addPath(this.fixableSeasonPaths, "SEASON/POSTER");
        this.addPath(this.fixableSeasonPaths, "SEASON/BOXCOVER");
    }

    public static AssetPathValidator getInstance() {
        return instance;
    }

    private void addPath(Set<String> set, String assetPath) {
        set.add(assetPath);
        set.add(assetPath + "/FILE");
    }

    private String preprocessPath(String oldPath) {
        if (oldPath == null) {
            throw new IllegalArgumentException("Invalid asset path: NULL");
        }
        String newPath = oldPath.toUpperCase();
        if (newPath.startsWith("/")) {
            newPath = newPath.substring(1);
        }
        return newPath;
    }

    public String validateAndFixPackageAssetPath(String oldPath) {
        String path = this.preprocessPath(oldPath);
        String pathExcludeFile = path.replaceAll("/FILE", "");
        if (this.allPackagePaths.contains(pathExcludeFile)) {
            return path;
        }
        if (this.fixablePackagePaths.contains(pathExcludeFile)) {
            return "PACKAGE/" + path;
        }
        throw new IllegalArgumentException("Invalid asset path: " + oldPath + ". Only PACKAGE paths are allowed.");
    }

    public String validateAndFixSeriesAssetPath(String oldPath) {
        String path = this.preprocessPath(oldPath);
        String pathExcludeFile = path.replaceAll("/FILE", "");
        if (this.allSeriesPaths.contains(pathExcludeFile)) {
            return path;
        }
        if (this.fixableSeriesPaths.contains(pathExcludeFile)) {
            return "SERIES/" + path;
        }
        throw new IllegalArgumentException("Invalid asset path: " + oldPath + ". Only SERIES paths are allowed.");
    }

    public String validateAndFixSeasonAssetPath(String oldPath) {
        String path = this.preprocessPath(oldPath);
        String pathExcludeFile = path.replaceAll("/FILE", "");
        if (this.allSeasonPaths.contains(pathExcludeFile)) {
            return path;
        }
        if (this.fixableSeasonPaths.contains(pathExcludeFile)) {
            return "SERIES/" + path;
        }
        throw new IllegalArgumentException("Invalid asset path: " + oldPath + ". Only SEASON (SERIES/SEASON) paths are allowed.");
    }
}

