/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.search.util;

import com.ericsson.cms.criteria.FieldType;
import com.ericsson.cms.criteria.SearchColumn;
import com.ericsson.cms.search.ElasticSearchIndexType;
import com.ericsson.cms.search.SearchParameters;
import com.ericsson.cms.search.TitleSearchResult;
import com.ericsson.cms.search.predicate.PredicateBuilderDate;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.util.DataTypeMappingReader;
import com.tandbergtv.neptune.util.GlobalDateFormatUtil;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHitField;
import org.springframework.util.CollectionUtils;

public class ElasticSearchUtil {
    private static Logger logger = Logger.getLogger(ElasticSearchUtil.class);
    private static final String INDEX_MASTER_TITLES = "master_titles";
    private static final String INDEX_SITE_TITLES = "site_titles";
    private static final String INDEX_SERIES_TITLES = "series_titles";
    private static final String INDEX_SEASONS = "seasons";
    private static final String INDEX_TYPE_TITLE = "title";
    private static final String INDEX_TYPE_SEASON = "season";
    private static final String DEFAULT_DATA_TYPE_STRING = "string";

    private ElasticSearchUtil() {
    }

    public static String createElasticSearchKey(String assetPath, String fieldPath) {
        if (assetPath == null || assetPath.isEmpty()) {
            return fieldPath;
        }
        if (!(assetPath = assetPath.toUpperCase()).startsWith("/")) {
            assetPath = "/" + assetPath;
        }
        String path = null;
        if (fieldPath.startsWith("/Fields/CustomFields")) {
            int idx1 = fieldPath.indexOf(91);
            int idx2 = fieldPath.indexOf(93);
            if (idx1 > 0 && idx2 > idx1) {
                String name = fieldPath.substring(idx1 + 7, idx2);
                path = assetPath + "/CustomFields/" + name;
            }
        } else {
            if (fieldPath != null && fieldPath.indexOf(64) >= 0) {
                fieldPath = fieldPath.replace("@", "");
            }
            path = assetPath + fieldPath;
        }
        return path;
    }

    public static String createSiteStatusKey(int siteId) {
        return "/siteStatus/" + siteId;
    }

    public static String createSiteStatusUpdatedTimeKey(int siteId) {
        return "/siteStatus/" + siteId + "/updatedTime";
    }

    public static List<SearchParameters.FieldInfo> buildFieldKeys(List<SearchColumn> columns) {
        ArrayList<SearchParameters.FieldInfo> list = new ArrayList<SearchParameters.FieldInfo>();
        if (columns == null) {
            return list;
        }
        for (SearchColumn column : columns) {
            String fieldPath = column.getFieldName();
            String assetPath = column.getSectionType();
            if (fieldPath == null) continue;
            SearchParameters.FieldInfo field = new SearchParameters.FieldInfo();
            field.setKey(ElasticSearchUtil.createElasticSearchKey(assetPath, fieldPath));
            field.setDataType(column.getDataType());
            list.add(field);
        }
        return list;
    }

    public static List<SearchParameters.FieldInfo> buildFieldKeys(List<SearchColumn> columns, int siteId) {
        ArrayList<SearchParameters.FieldInfo> list = new ArrayList<SearchParameters.FieldInfo>();
        if (columns == null) {
            return list;
        }
        for (SearchColumn column : columns) {
            String fieldPath = column.getFieldName();
            if ("status".equals(column.getFieldName()) && column.getFieldType() == FieldType.SITE) {
                fieldPath = ElasticSearchUtil.createSiteStatusKey(siteId);
            }
            String assetPath = column.getSectionType();
            if (fieldPath == null) continue;
            SearchParameters.FieldInfo field = new SearchParameters.FieldInfo();
            field.setKey(ElasticSearchUtil.createElasticSearchKey(assetPath, fieldPath));
            field.setDataType(column.getDataType());
            list.add(field);
        }
        return list;
    }

    public static TitleSearchResult.SearchRow createSearchRow(List<SearchParameters.FieldInfo> searchFields, SearchHit hit) {
        if (hit == null) {
            throw new IllegalArgumentException("SearchHit is null");
        }
        long titleId = 0L;
        try {
            titleId = Long.parseLong(hit.getId());
        }
        catch (Exception ex) {
            throw new RuntimeException("Invalid title id " + hit.getId());
        }
        ArrayList<Object> values = new ArrayList<Object>();
        if (searchFields != null) {
            for (SearchParameters.FieldInfo searchField : searchFields) {
                if ("id".equals(searchField.getKey())) {
                    values.add(hit.getId());
                    continue;
                }
                SearchHitField hitField = hit.field(searchField.getKey());
                List hitValues = hitField == null ? null : hitField.getValues();
                Object value = ElasticSearchUtil.processField(searchField, hitValues);
                values.add(value);
            }
        }
        return new TitleSearchResult.SearchRow(titleId, values);
    }

    private static Object processField(SearchParameters.FieldInfo searchField, List<Object> hitValues) {
        if (CollectionUtils.isEmpty(hitValues)) {
            return "";
        }
        if (hitValues.size() == 1) {
            return ElasticSearchUtil.processValue(hitValues.get(0), searchField.getDataType());
        }
        ArrayList<String> list = new ArrayList<String>();
        for (Object obj : hitValues) {
            String value = ElasticSearchUtil.processValue(obj, searchField.getDataType());
            list.add(value);
        }
        return list;
    }

    private static String processValue(Object value, String dataType) {
        if ("time".equalsIgnoreCase(dataType)) {
            String strValue = value.toString();
            Date date = PredicateBuilderDate.parseElasticSearchDateString(strValue);
            if (date != null) {
                strValue = GlobalDateFormatUtil.formatTime((Date)date, (String)"HH:mm:ss");
            }
            return strValue;
        }
        if ("date".equals(dataType)) {
            String strValue = value.toString();
            Date date = PredicateBuilderDate.parseElasticSearchDateString(strValue);
            if (date != null) {
                strValue = GlobalDateFormatUtil.formatDateTime((Date)date, (String)"yyyy-MM-dd HH:mm:ss");
            }
            return strValue;
        }
        return value.toString();
    }

    public static String getDataType(String esPath) {
        if (esPath == null) {
            return null;
        }
        int idx = esPath.indexOf("/Fields/");
        if (idx > 0) {
            String fieldPath = esPath.substring(idx);
            DataTypeMappingReader dataTypeMapping = DataTypeMappingReader.getInstance();
            String dataType = dataTypeMapping.determineDataType(fieldPath);
            return dataType == null ? DEFAULT_DATA_TYPE_STRING : dataType;
        }
        idx = esPath.indexOf("/CustomFields/");
        if (idx > 0) {
            String customFieldName = esPath.substring(idx + 14);
            String fieldPath = "/CustomFields/CustomField[@name=" + customFieldName + "]/@value";
            DataTypeMappingReader dataTypeMapping = DataTypeMappingReader.getInstance();
            String dataType = dataTypeMapping.determineDataType(fieldPath);
            return dataType == null ? DEFAULT_DATA_TYPE_STRING : dataType;
        }
        if ("createDate".equals(esPath) || "lastModifiedTime".equals(esPath)) {
            return "date";
        }
        return DEFAULT_DATA_TYPE_STRING;
    }

    public static ElasticSearchIndexType getTitleType(Title title) throws Exception {
        if (title == null) {
            throw new IllegalArgumentException("Title is null.");
        }
        if (title.getOriginalId() == null) {
            Asset root = title.getAsset();
            if (root == null) {
                String msg = "Title root asset is NULL for titleId = " + title.getId();
                throw new Exception(msg);
            }
            String rootAssetType = root.getAssetType();
            if ("SERIES".equalsIgnoreCase(rootAssetType)) {
                return ElasticSearchIndexType.SERIES;
            }
            if ("PACKAGE".equalsIgnoreCase(rootAssetType)) {
                return ElasticSearchIndexType.MASTER;
            }
            String msg = "Could not determine title type for titleId = " + title.getId();
            logger.error((Object)msg);
            throw new Exception(msg);
        }
        return ElasticSearchIndexType.SITE;
    }

    public static Object processDate(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Date) {
            return GlobalDateFormatUtil.formatDateTime((Date)((Date)value), (String)"yyyy-MM-dd'T'HH:mm:ss.SSS");
        }
        return value;
    }

    public static void addField(XContentBuilder bld, String key, Object value) {
        if (value == null) {
            return;
        }
        try {
            bld.field(key, ElasticSearchUtil.processDate(value));
        }
        catch (Exception ex) {
            logger.error((Object)"Cannot add field", (Throwable)ex);
        }
    }

    public static void addArray(XContentBuilder bld, String key, List list) {
        try {
            bld.startArray(key);
            for (Object value : list) {
                bld.value(value);
            }
            bld.endArray();
        }
        catch (Exception ex) {
            logger.error((Object)"Cannot add field", (Throwable)ex);
        }
    }

    public static String getElasticSearchIndexName(ElasticSearchIndexType indexType) {
        if (indexType == null) {
            throw new IllegalArgumentException("ElasticSearchIndexType is NULL.");
        }
        switch (indexType) {
            case MASTER: {
                return INDEX_MASTER_TITLES;
            }
            case SITE: {
                return INDEX_SITE_TITLES;
            }
            case SERIES: {
                return INDEX_SERIES_TITLES;
            }
            case SEASON: {
                return INDEX_SEASONS;
            }
        }
        return null;
    }

    public static String getElasticSearchTypeName(ElasticSearchIndexType indexType) {
        if (indexType == null) {
            throw new IllegalArgumentException("ElasticSearchIndexType is NULL.");
        }
        if (indexType == ElasticSearchIndexType.SEASON) {
            return INDEX_TYPE_SEASON;
        }
        return INDEX_TYPE_TITLE;
    }
}

