/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.content.contentclass;

import com.tandbergtv.content.contentclass.entities.ContentClass;
import com.tandbergtv.content.contentclass.entities.ContentClassAsset;
import com.tandbergtv.content.contentclass.entities.ContentClassMetadata;
import com.tandbergtv.content.contentclass.entities.ContentClassPartner;
import com.tandbergtv.content.contentclass.service.ContentClassPersistenceException;
import com.tandbergtv.content.contentclass.service.IContentClassService;
import com.tandbergtv.metadatamanager.customfield.CustomFieldDeleteCallbackException;
import com.tandbergtv.metadatamanager.customfield.ICustomFieldDeleteCallback;
import com.tandbergtv.metadatamanager.customfield.model.CustomField;
import com.tandbergtv.metadatamanager.customfield.model.CustomFieldGroup;
import com.tandbergtv.neptune.util.InjectionUtil;
import java.util.List;
import org.apache.log4j.Logger;

public class ContentClassCustomFieldDeleteCallback
implements ICustomFieldDeleteCallback {
    private static Logger logger = Logger.getLogger(ContentClassCustomFieldDeleteCallback.class);

    public void beforeCustomFieldDelete(CustomField customField) throws CustomFieldDeleteCallbackException {
    }

    public void afterCustomFieldDelete(CustomField customField) throws CustomFieldDeleteCallbackException {
        IContentClassService service = (IContentClassService)InjectionUtil.injectInstance((String)"cms/ContentClassService/local", IContentClassService.class);
        List list = null;
        try {
            list = service.getAllContentClassesWithoutMetadata();
        }
        catch (ContentClassPersistenceException e) {
            logger.error((Object)e);
            throw new CustomFieldDeleteCallbackException("Cannot delete Custom Field '" + customField.getName() + "' for asset '" + customField.getGroup().getAssetPath() + ": " + e.getMessage());
        }
        if (list != null) {
            for (ContentClass tmpCc : list) {
                try {
                    ContentClassAsset ccAsset;
                    ContentClassMetadata meta;
                    ContentClass cc = service.getContentClassById(tmpCc.getId());
                    if (cc == null || (meta = cc.getMetadata()) == null || (ccAsset = meta.getAsset(customField.getGroup().getAssetPath())) == null) continue;
                    ccAsset.removeField(customField.getFieldPath());
                    ccAsset.removeField(customField.getParentFieldPath());
                    service.saveContentClass(cc);
                }
                catch (ContentClassPersistenceException e) {
                    logger.error((Object)e);
                    throw new CustomFieldDeleteCallbackException("Cannot delete Custom Field '" + customField.getName() + "' for asset '" + customField.getGroup().getAssetPath() + ": " + e.getMessage());
                }
            }
        }
        this.deletePartnerCC(service, customField);
    }

    private void deletePartnerCC(IContentClassService service, CustomField customField) throws CustomFieldDeleteCallbackException {
        try {
            List list = service.getAllContentClassPartnersWithoutMetadata();
            if (list != null) {
                for (ContentClassPartner tmpCcp : list) {
                    ContentClassAsset ccAsset;
                    ContentClassMetadata meta;
                    ContentClassPartner ccp = service.getContentClassPartnerMetadata(tmpCcp.getContentClassId(), tmpCcp.getPartnerId());
                    if (ccp == null || (meta = ccp.getMetadata()) == null || (ccAsset = meta.getAsset(customField.getGroup().getAssetPath())) == null) continue;
                    ccAsset.removeField(customField.getFieldPath());
                    ccAsset.removeField(customField.getParentFieldPath());
                    service.saveContentClassPartner(ccp);
                }
            }
        }
        catch (ContentClassPersistenceException e) {
            logger.error((Object)e);
            throw new CustomFieldDeleteCallbackException("Cannot delete Custom Field '" + customField.getName() + "' for asset '" + customField.getGroup().getAssetPath() + ": " + e.getMessage());
        }
    }

    public void afterCustomFieldGroupDelete(CustomFieldGroup customFieldGroup) throws CustomFieldDeleteCallbackException {
        IContentClassService service = (IContentClassService)InjectionUtil.injectInstance((String)"cms/ContentClassService/local", IContentClassService.class);
        List list = null;
        try {
            list = service.getAllContentClassesWithoutMetadata();
        }
        catch (ContentClassPersistenceException e) {
            logger.error((Object)e);
            throw new CustomFieldDeleteCallbackException("Cannot delete Custom Field '" + customFieldGroup.getName() + "' for asset '" + customFieldGroup.getAssetPath() + ": " + e.getMessage());
        }
        if (list != null) {
            for (ContentClass tmpCc : list) {
                try {
                    ContentClassAsset ccAsset;
                    ContentClassMetadata meta;
                    ContentClass cc = service.getContentClassById(tmpCc.getId());
                    if (cc == null || (meta = cc.getMetadata()) == null || (ccAsset = meta.getAsset(customFieldGroup.getAssetPath())) == null) continue;
                    ccAsset.removeField(customFieldGroup.getGroupXpath());
                    service.saveContentClass(cc);
                }
                catch (ContentClassPersistenceException e) {
                    logger.error((Object)e);
                    throw new CustomFieldDeleteCallbackException("Cannot delete Custom Field Group '" + customFieldGroup.getName() + "' for asset '" + customFieldGroup.getAssetPath() + ": " + e.getMessage());
                }
            }
        }
    }
}

