/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.common;

import com.ericsson.cms.scheduler.IHistoryTokenProvider;
import com.ericsson.cms.scheduler.entities.Job;
import java.util.Objects;
import java.util.ServiceLoader;
import org.apache.log4j.Logger;

public class ServiceLoaderHelper {
    private static final Logger LOGGER = Logger.getLogger(ServiceLoaderHelper.class);
    private static ServiceLoader<IHistoryTokenProvider> htpLoader;

    private ServiceLoaderHelper() {
    }

    public static String getHistoryToken(Job job) {
        if (Objects.isNull(htpLoader)) {
            htpLoader = ServiceLoader.load(IHistoryTokenProvider.class);
        }
        for (IHistoryTokenProvider htp : htpLoader) {
            String historyToken = null;
            try {
                historyToken = htp.getHistoryToken(job);
            }
            catch (Exception e) {
                LOGGER.warn((Object)("Exception occurred getting history token for Job : " + job + " : " + e), (Throwable)e);
            }
            if (!Objects.nonNull(historyToken)) continue;
            return historyToken;
        }
        return null;
    }
}

