/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.assetlist;

import com.tandbergtv.neptune.configuration.service.INeptuneSettingChangeListener;
import com.tandbergtv.watchpoint.pmm.schedule.DistSchedulePersistenceService;
import com.tandbergtv.watchpoint.pmm.schedule.IDistSchedulePersistenceService;
import com.tandbergtv.watchpoint.pmm.schedule.ISchedulePersistenceService;
import com.tandbergtv.watchpoint.pmm.schedule.SchedulePersistenceService;
import com.tandbergtv.watchpoint.pmm.schedule.monitor.IScheduleMonitor;
import com.tandbergtv.watchpoint.pmm.schedule.notify.IScheduleNotifier;
import com.tandbergtv.watchpoint.pmm.schedule.notify.ScheduleNotifierService;
import com.tandbergtv.watchpoint.pmm.schedule.search.IScheduleSearchService;
import com.tandbergtv.watchpoint.pmm.schedule.search.ScheduleSearchService;
import com.tandbergtv.watchpoint.pmm.util.ServiceUtil;
import com.tandbergtv.workflow.core.service.Service;
import java.lang.management.ManagementFactory;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.apache.log4j.Logger;

public class AssetListActivator
implements INeptuneSettingChangeListener {
    private static Logger logger = Logger.getLogger(AssetListActivator.class);
    private static final String SCHEDULE_MONITOR_MBEAN = "com.tandbergtv.watchpoint:type=ScheduleMonitor";

    public void start() {
        ServiceUtil.addService((Service)new SchedulePersistenceService());
        ServiceUtil.addService((Service)new ScheduleSearchService());
        ServiceUtil.addService((Service)new DistSchedulePersistenceService());
        ScheduleNotifierService service = new ScheduleNotifierService();
        ServiceUtil.addService((Service)service);
        this.registerMBean(service);
    }

    public void stop() {
        this.unregisterMBean();
        ServiceUtil.removeService(IScheduleNotifier.class);
        ServiceUtil.removeService(IDistSchedulePersistenceService.class);
        ServiceUtil.removeService(IScheduleSearchService.class);
        ServiceUtil.removeService(ISchedulePersistenceService.class);
    }

    private void registerMBean(IScheduleNotifier service) {
        IScheduleMonitor statistics = service.getScheduleStatistics();
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        try {
            StandardMBean mbean = new StandardMBean(statistics, IScheduleMonitor.class);
            server.registerMBean(mbean, new ObjectName(SCHEDULE_MONITOR_MBEAN));
        }
        catch (Exception ex) {
            logger.warn((Object)"Registration of ScheduleMonitor MBean failed", (Throwable)ex);
        }
    }

    private void unregisterMBean() {
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        try {
            server.unregisterMBean(new ObjectName(SCHEDULE_MONITOR_MBEAN));
        }
        catch (Exception ex) {
            logger.warn((Object)"ScheduleMonitor MBean unregistration failed", (Throwable)ex);
        }
    }

    public void settingsChanged(Map<String, String> arg0) {
        this.unregisterMBean();
        ServiceUtil.removeService(IScheduleNotifier.class);
        ScheduleNotifierService service = new ScheduleNotifierService();
        ServiceUtil.addService((Service)service);
        this.registerMBean(service);
    }
}

