/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.assetlist;

import com.tandbergtv.metadatamanager.exception.SearchException;
import com.tandbergtv.metadatamanager.exception.TranslationException;
import com.tandbergtv.watchpoint.pmm.assetlist.AssetListErrorCode;
import com.tandbergtv.watchpoint.pmm.assetlist.AssetListRuntimeException;
import com.tandbergtv.watchpoint.pmm.assetlist.IAssetListExport;
import com.tandbergtv.watchpoint.pmm.entities.AssetList;
import com.tandbergtv.watchpoint.pmm.entities.IAssetList;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.entities.bind.Marshaller;
import com.tandbergtv.watchpoint.pmm.title.ITitleService;
import com.tandbergtv.watchpoint.pmm.title.TitleWithPartialSpecKeysException;
import com.tandbergtv.watchpoint.pmm.util.XMLDocumentUtility;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class AssetListExport<E extends IAssetList>
implements IAssetListExport<E> {
    private Logger logger = Logger.getLogger(this.getClass());

    public Document export(E entity, String spec) {
        AssetList list = (AssetList)AssetList.class.cast(entity);
        if (!list.getIsActive().booleanValue()) {
            String message = "Cannot export assetlist[" + list.getId() + "] because it is inactive.";
            throw new AssetListRuntimeException(message, AssetListErrorCode.INACTIVE_ASSET_LIST);
        }
        this.logger.debug((Object)("Exporting assetlist: " + entity.getId() + " in " + spec + " spec."));
        for (Title title : entity.getTitles()) {
            try {
                this.setMetadata(title, spec);
            }
            catch (SearchException e) {
                throw new AssetListRuntimeException((Throwable)e, AssetListErrorCode.TITLE_NOT_FOUND);
            }
            catch (TranslationException e) {
                throw new AssetListRuntimeException((Throwable)e, AssetListErrorCode.TITLE_TRANSLATION_ERROR);
            }
            catch (TitleWithPartialSpecKeysException e) {
                throw new AssetListRuntimeException((Throwable)e, AssetListErrorCode.TITLE_WITH_PARTIAL_SPEC_KEYS);
            }
            catch (Exception e) {
                throw new AssetListRuntimeException((Throwable)e, AssetListErrorCode.ASSETLIST_SERIALIZATION_ERROR);
            }
        }
        Marshaller<E> marshaller = new Marshaller<E>();
        return (Document)marshaller.marshal(entity);
    }

    private void setMetadata(Title title, String spec) throws Exception {
        Document doc = this.getTitleService().getMetadata(title.getId(), spec);
        String metadataContent = XMLDocumentUtility.convertToString((Node)doc);
        title.setMetadataContent(metadataContent);
    }

    private ITitleService getTitleService() {
        return (ITitleService)ServiceRegistry.getDefault().lookup(ITitleService.class);
    }
}

