/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.communication.handlers;

import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.metadatamanager.model.FieldName;
import com.tandbergtv.watchpoint.communication.Util;
import com.tandbergtv.watchpoint.communication.config.MessageHandler;
import com.tandbergtv.watchpoint.communication.config.MessageHandlerException;
import com.tandbergtv.watchpoint.pmm.core.TitleValidationException;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.title.ITitleService;
import com.tandbergtv.watchpoint.pmm.title.TitleStatusService;
import com.tandbergtv.watchpoint.pmm.util.ProgressStatusHelper;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.message.IMessageKey;
import com.tandbergtv.workflow.message.IMessageUID;
import com.tandbergtv.workflow.message.WorkflowMessage;
import java.io.File;

public class SetFilePropertiesMessageHandler
implements MessageHandler {
    private static final String MATERIAL_ID_XPATH = "/Fields/CustomFields/CustomField[@name=MaterialId]/@value";
    private static final String ENCODE_PROFILE_XPATH = "/Fields/CustomFields/CustomField[@name=EncodeProfile]/@value";
    private static final String ENCODE_FORMAT_XPATH = "/Fields/CustomFields/CustomField[@name=EncodeFormat]/@value";
    private static final String LOOKUP_KEY_XPATH = "/Fields/CustomFields/CustomField[@name=LookupKey]/@value";
    private static final String LOOKUP_KEY = "lookupKey";
    private static final String HEIGHT = "height";
    private static final String WIDTH = "width";
    private static final String FILE_SIZE = "fileSize";
    private static final String MIME_TYPE = "mimeType";
    private static final String FILE_NAME = "fileName";
    private static final String DURATION = "duration";
    private static final String ASPECTRATIO = "aspectratio";
    private static final String BITRATE = "bitrate";
    private static final String RESOLUTION = "resolution";
    private static final String MATERIAL_ID = "materialId";
    private static final String ENCODE_PROFILE = "encodeProfile";
    private static final String ENCODE_FORMAT = "encodeFormat";
    private static final String TITLE_ID = "titleId";
    private static final String FILE_URI = "fileURI";
    private static final String FILE_ASSET_ID = "fileAssetId";
    private static final String RESULT = "result";
    private static final String SUCCESS = "SUCCESS";
    private static final String CHECKSUM = "checksum";

    @Override
    @Transactional
    public WorkflowMessage handleMessage(WorkflowMessage message) throws Exception {
        Util.validateRequired(message, TITLE_ID, FILE_URI, FILE_ASSET_ID);
        Long titleId = Util.getLongValue(message, TITLE_ID);
        String fileURI = Util.getStringValueTrimmed(message, FILE_URI);
        Long fileAssetId = Util.getLongValue(message, FILE_ASSET_ID);
        String encodeFormat = Util.getStringValueTrimmed(message, ENCODE_FORMAT);
        String encodeProfile = Util.getStringValueTrimmed(message, ENCODE_PROFILE);
        String materialId = Util.getStringValueTrimmed(message, MATERIAL_ID);
        String resolution = Util.getStringValueTrimmed(message, RESOLUTION);
        String bitrate = Util.getStringValueTrimmed(message, BITRATE);
        String aspectratio = Util.getStringValueTrimmed(message, ASPECTRATIO);
        String duration = Util.getStringValueTrimmed(message, DURATION);
        String fileName = Util.getStringValueTrimmed(message, FILE_NAME);
        String mimeType = Util.getStringValueTrimmed(message, MIME_TYPE);
        String fileSize = Util.getStringValueTrimmed(message, FILE_SIZE);
        String width = Util.getStringValueTrimmed(message, WIDTH);
        String height = Util.getStringValueTrimmed(message, HEIGHT);
        String lookupKey = Util.getStringValueTrimmed(message, LOOKUP_KEY);
        String checksum = Util.getStringValueTrimmed(message, CHECKSUM);
        String sourceComponentName = Util.getStringValueTrimmed(message, "sourceComponentName");
        String sourceEntityName = Util.getStringValueTrimmed(message, "sourceEntityName");
        String sourceId = Util.getStringValueTrimmed(message, "sourceId");
        ServiceRegistry registry = ServiceRegistry.getDefault();
        ITitleService service = (ITitleService)registry.lookup(ITitleService.class);
        Title title = null;
        try {
            title = service.getTitleForUpdate(titleId);
        }
        catch (Exception e) {
            String msg = "Failed to read the Title from the persistence service, error: " + e.getMessage();
            throw new MessageHandlerException("ERR-003", msg, e);
        }
        if (title == null) {
            String msg = "Did not get a Title from the persistence service.";
            throw new MessageHandlerException("ERR-003", msg);
        }
        Asset groupAsset = title.getAsset();
        if (groupAsset == null) {
            String msg = "Did not get a group object for a given title.";
            throw new MessageHandlerException("ERR-003", msg);
        }
        com.tandbergtv.metadatamanager.model.File targetAsset = null;
        for (com.tandbergtv.metadatamanager.model.File file : groupAsset.getAllDescendantFiles()) {
            if (file.getId() != fileAssetId.longValue()) continue;
            targetAsset = file;
            break;
        }
        if (targetAsset == null) {
            String msg = "Did not get an item object for a given fileAssetId.";
            throw new MessageHandlerException("ERR-003", msg);
        }
        if (lookupKey != null && !lookupKey.equals("")) {
            for (com.tandbergtv.metadatamanager.model.File file : groupAsset.getAssetsParent(targetAsset).getDirectDescendantFiles()) {
                Field lookupKeyField = file.getFirstField(LOOKUP_KEY_XPATH);
                if (lookupKeyField == null || !lookupKeyField.getTypedValue().equals(lookupKey)) continue;
                lookupKeyField.setValue("");
            }
        }
        this.updateField((Asset)targetAsset, FieldName.FILE_URL.toString(), fileURI);
        this.updateField((Asset)targetAsset, ENCODE_FORMAT_XPATH, encodeFormat);
        this.updateField((Asset)targetAsset, ENCODE_PROFILE_XPATH, encodeProfile);
        this.updateField((Asset)targetAsset, MATERIAL_ID_XPATH, materialId);
        this.updateField((Asset)targetAsset, LOOKUP_KEY_XPATH, lookupKey);
        this.updateField((Asset)targetAsset, FieldName.RESOLUTION.toString(), resolution);
        this.updateField((Asset)targetAsset, FieldName.BITRATE.toString(), bitrate);
        this.updateField((Asset)targetAsset, FieldName.ASPECTRATIO.toString(), aspectratio);
        this.updateField((Asset)targetAsset, FieldName.DURATION.toString(), duration);
        this.updateField((Asset)targetAsset, FieldName.FILE_NAME.toString(), fileName);
        this.updateField((Asset)targetAsset, FieldName.MIME_TYPE.toString(), mimeType);
        if (fileSize == null || fileSize.equals("")) {
            fileSize = new File(fileURI).length() + "";
        }
        this.updateField((Asset)targetAsset, FieldName.FILE_SIZE.toString(), fileSize);
        this.updateField((Asset)targetAsset, FieldName.WIDTH.toString(), width);
        this.updateField((Asset)targetAsset, FieldName.HEIGHT.toString(), height);
        this.updateField((Asset)targetAsset, FieldName.FILE_CHECKSUM.toString(), checksum);
        try {
            service.update(title, sourceComponentName, sourceEntityName, sourceId);
        }
        catch (TitleValidationException e) {
            service.validate(title, true);
            service.saveAsDraft(title);
            TitleStatusService statusService = new TitleStatusService();
            statusService.sendStatus(title, ProgressStatusHelper.VALIDATION_FAILURE, e.getMessage(), false, sourceComponentName, sourceEntityName, sourceId);
        }
        IMessageUID uid = message.getMessageUID();
        IMessageKey key = message.getKey();
        WorkflowMessage response = new WorkflowMessage(uid, key, WorkflowMessage.MessageType.ack);
        response.putValue(RESULT, SUCCESS);
        return response;
    }

    private void updateField(Asset asset, String ttvXPath, String value) {
        if (value != null) {
            Field field = asset.getFirstField(ttvXPath);
            if (field != null) {
                field.setValue(value);
            } else {
                asset.addField(new Field(ttvXPath, value));
            }
        }
    }
}

