/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.core;

import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.partner.IPartnerManagement;
import com.tandbergtv.watchpoint.pmm.title.TitleUtil;
import com.tandbergtv.watchpoint.pmm.util.PMMProperties;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import org.apache.log4j.Logger;

public class AssetsManager {
    private static final Logger logger = Logger.getLogger(AssetsManager.class);
    private static final String UNMAPPED_FILES_DIR = "unmappedAssets";
    private static final String MAPPED_FILES_DIR = "mappedAssets";
    private static final String DERIVED_FILES_DIR = "derivedAssets";
    private static boolean initialized = false;
    private static File unmappedFilesDirectory;
    private static File mappedFilesDirectory;
    private static File derivedFilesDirectory;
    private static ThreadLocal<AssetsManager> instances;
    private Map<String, String> mappedFiles = new HashMap<String, String>();
    private Queue<Record> records = new LinkedList<Record>();

    public static void init() {
        try {
            PMMProperties properties = PMMProperties.getInstance();
            String unmappedFilesDirPath = properties.getProperty(UNMAPPED_FILES_DIR);
            String mappedFilesDirPath = properties.getProperty(MAPPED_FILES_DIR);
            String derivedFilesDirPath = properties.getProperty(DERIVED_FILES_DIR);
            unmappedFilesDirectory = new File(unmappedFilesDirPath);
            if (!unmappedFilesDirectory.exists() || !unmappedFilesDirectory.isDirectory()) {
                logger.error((Object)("[Configuration Error] unmappedAssets " + unmappedFilesDirectory + " does not exist"));
            }
            if (!(mappedFilesDirectory = new File(mappedFilesDirPath)).exists() || !mappedFilesDirectory.isDirectory()) {
                logger.error((Object)("[Configuration Error] mappedAssets " + mappedFilesDirectory + " does not exist"));
            }
            if (!(derivedFilesDirectory = new File(derivedFilesDirPath)).exists()) {
                derivedFilesDirectory.mkdirs();
            }
            if (!derivedFilesDirectory.exists() || !derivedFilesDirectory.isDirectory()) {
                logger.error((Object)("[Configuration Error] derivedAssets " + derivedFilesDirectory + " does not exist"));
            }
            initialized = true;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to initialize.", e);
        }
    }

    private AssetsManager() {
        if (!initialized) {
            throw new RuntimeException("Not initialized properly. Check previous errors.");
        }
    }

    public static AssetsManager getThreadLocalInstance() {
        AssetsManager instance = instances.get();
        if (instance == null) {
            instance = new AssetsManager();
            instances.set(instance);
        }
        return instance;
    }

    public File getUnmappedFilesDirectory() {
        return unmappedFilesDirectory;
    }

    public File getMappedFilesDirectory() {
        return mappedFilesDirectory;
    }

    public File getDerivedFilesDirectory() {
        return derivedFilesDirectory;
    }

    public List<File> getUnmappedFiles() throws IOException {
        return this.getAllFiles(unmappedFilesDirectory);
    }

    public List<File> getUnmappedFiles(String fileName, String pathFilter) throws IOException {
        return this.getFiles(unmappedFilesDirectory, fileName, pathFilter);
    }

    public boolean isUnmappedFile(String filePath) {
        return this.isValidFile(filePath, this.getUnmappedFilesDirectory());
    }

    public boolean isUnmappedFilePath(String filePath) {
        String unmappedPath = this.getUnmappedFilesDirectory().getAbsolutePath();
        return filePath != null && filePath.startsWith(unmappedPath);
    }

    public boolean isMappedFile(String filePath) {
        return this.isValidFile(filePath, this.getMappedFilesDirectory());
    }

    private boolean isValidFile(String filePath, File parentFolder) {
        if (filePath != null && filePath.startsWith(parentFolder.getAbsolutePath())) {
            File file = new File(filePath);
            return file.isFile();
        }
        return false;
    }

    public File moveToMappedFilesDirectory(File file) throws IOException, RuntimeException {
        if (!file.exists()) {
            throw new FileNotFoundException("File does not exist. File: " + file);
        }
        if (!file.isFile()) {
            throw new RuntimeException("File is not a normal file. File: " + file);
        }
        String targetDirName = file.getName() + "_" + System.currentTimeMillis();
        File targetDir = new File(mappedFilesDirectory, targetDirName);
        File targetFile = new File(targetDir, file.getName());
        this.recordMove(file, targetFile);
        return targetFile;
    }

    public File moveToUnmappedFilesDirectory(File file, String filterDir) throws IOException, RuntimeException {
        if (!file.exists()) {
            throw new FileNotFoundException("File does not exist. File: " + file);
        }
        if (!file.isFile()) {
            throw new RuntimeException("File is not a normal file. File: " + file);
        }
        String targetDirName = filterDir + File.separator + file.getName() + "_" + System.currentTimeMillis();
        File targetDir = new File(unmappedFilesDirectory, targetDirName);
        File targetFile = new File(targetDir, file.getName());
        this.recordMove(file, targetFile);
        return targetFile;
    }

    public void beginTransaction() {
        logger.debug((Object)"Begining transaction");
        this.records.clear();
        this.mappedFiles.clear();
    }

    public void commitTransaction() {
        logger.debug((Object)"Committing transaction.");
        ArrayList<Record> failedRecords = new ArrayList<Record>();
        Record r = this.records.poll();
        while (r != null) {
            try {
                this.move(r.src, r.dest);
            }
            catch (Exception e) {
                failedRecords.add(r);
            }
            r = this.records.poll();
        }
        this.records.clear();
        if (!failedRecords.isEmpty()) {
            throw new RuntimeException("Commit failed for: " + failedRecords);
        }
    }

    public void rollbackTransaction() {
        logger.debug((Object)"Rolling back transaction.");
        this.records.clear();
        this.mappedFiles.clear();
    }

    public String getSourceFile(String destFile) {
        return this.mappedFiles.get(destFile);
    }

    private void recordMove(File src, File dest) {
        this.mappedFiles.put(dest.getAbsolutePath(), src.getAbsolutePath());
        this.records.add(new Record(src, dest));
    }

    private void move(File src, File dest) throws IOException {
        dest.getParentFile().mkdirs();
        if (!src.renameTo(dest)) {
            this.deleteIfEmpty(dest.getParentFile());
            throw new IOException("Failed to move file: " + src + " to: " + dest);
        }
        logger.debug((Object)("Moved file: " + src + " to: " + dest));
        this.deleteIfEmpty(src.getParentFile());
    }

    private void deleteIfEmpty(File dir) throws IOException {
        String[] contents = dir.list();
        if (contents == null) {
            logger.warn((Object)("Failed to delete directory: " + dir + " | Reason: Failed to get list of files in the directory"));
            return;
        }
        if (contents.length == 0) {
            if (!this.canDelete(dir)) {
                return;
            }
            if (dir.delete()) {
                logger.debug((Object)("Deleted directory: " + dir));
            } else {
                logger.warn((Object)("Failed to delete directory: " + dir));
            }
        }
    }

    private boolean canDelete(File dir) throws IOException {
        File f1 = unmappedFilesDirectory.getCanonicalFile();
        File f2 = mappedFilesDirectory.getCanonicalFile();
        File f0 = dir.getCanonicalFile();
        return !f0.equals(f1) && !f0.equals(f2);
    }

    private List<File> getAllFiles(File dirFile) throws IOException {
        ArrayList<File> files = new ArrayList<File>();
        File[] dirContents = dirFile.listFiles();
        if (dirContents == null) {
            throw new IOException("IO Exception occurred while trying to get list of files for directory: " + dirFile.getAbsolutePath());
        }
        for (File file : dirContents) {
            if (file.isFile()) {
                files.add(file);
                continue;
            }
            if (!file.isDirectory()) continue;
            files.addAll(this.getAllFiles(file));
        }
        return files;
    }

    private List<File> getFiles(File dirFile, String fileName, String pathFilter) throws IOException {
        ArrayList<File> fileList = new ArrayList<File>();
        File[] dirContents = dirFile.listFiles();
        if (dirContents == null) {
            if (dirFile.exists()) {
                throw new IOException("IO Exception occurred while trying to get list of files for directory: " + dirFile.getAbsolutePath());
            }
            return fileList;
        }
        for (File file : dirContents) {
            if (file.isFile()) {
                if (pathFilter == null || !TitleUtil.checkContainsWithNeptuneSetting(file.getAbsolutePath(), pathFilter) || !TitleUtil.compareFileNames(file.getName(), fileName)) continue;
                fileList.add(file);
                continue;
            }
            if (!file.isDirectory()) continue;
            fileList.addAll(this.getFiles(file, fileName, pathFilter));
        }
        return fileList;
    }

    public File getDerivedFilesDirectory(Title title) {
        if (title.getId() == null) {
            throw new RuntimeException("The title cannot have a derived folder location since it is not persisted.");
        }
        ServiceRegistry registry = ServiceRegistry.getDefault();
        IPartnerManagement partnerManager = (IPartnerManagement)registry.lookup(IPartnerManagement.class);
        String providerId = partnerManager.getPartner(title.getPartnerId().longValue()).getProviderId();
        File providerFolder = new File(this.getDerivedFilesDirectory(), providerId);
        return new File(providerFolder, title.getId().toString());
    }

    static {
        instances = new ThreadLocal();
    }

    private static class Record {
        private File src;
        private File dest;

        Record(File src, File dest) {
            this.src = src;
            this.dest = dest;
        }

        public String toString() {
            return "Source: " + this.src + " | Destination: " + this.dest;
        }
    }
}

