/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.core;

import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.watchpoint.pmm.dao.hibernate.HibernateContext;
import com.tandbergtv.watchpoint.pmm.entities.TitleProperty;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.Query;
import org.hibernate.Session;

public class TitlePropertyManager {
    private static Logger logger = Logger.getLogger(TitlePropertyManager.class);

    public static TitlePropertyManager getInstance() {
        return new TitlePropertyManager();
    }

    @Transactional
    public TitleProperty retrieve(String name, long titleId, Long assetListId, Long contextId) {
        Session session = this.getSession();
        return this.retrieve(session, name, titleId, assetListId, contextId);
    }

    @Transactional
    public List<TitleProperty> retrieveAll(long titleId, Long assetListId, Long contextId) {
        Session session = this.getSession();
        return this.retrieveAll(session, titleId, assetListId, contextId);
    }

    private List<TitleProperty> retrieveAll(Session session, long titleId, Long assetListId, Long contextId) {
        StringBuffer querySB = new StringBuffer();
        querySB.append("from TitleProperty p where p.titleId = :titleId and ");
        if (assetListId != null) {
            querySB.append("assetListId = :assetListId and ");
        } else {
            querySB.append("assetListId is null and ");
        }
        if (contextId != null) {
            querySB.append("contextId = :contextId");
        } else {
            querySB.append("contextId is null");
        }
        Query query = session.createQuery(querySB.toString());
        query.setParameter("titleId", (Object)titleId);
        if (assetListId != null) {
            query.setParameter("assetListId", (Object)assetListId);
        }
        if (contextId != null) {
            query.setParameter("contextId", (Object)contextId);
        }
        return query.list();
    }

    private TitleProperty retrieve(Session session, String name, long titleId, Long assetListId, Long contextId) {
        StringBuffer querySB = new StringBuffer();
        querySB.append("from TitleProperty p where p.name = :name and p.titleId = :titleId and ");
        if (assetListId != null) {
            querySB.append("assetListId = :assetListId and ");
        } else {
            querySB.append("assetListId is null and ");
        }
        if (contextId != null) {
            querySB.append("contextId = :contextId");
        } else {
            querySB.append("contextId is null");
        }
        Query query = session.createQuery(querySB.toString());
        query.setParameter("name", (Object)name);
        query.setParameter("titleId", (Object)titleId);
        if (assetListId != null) {
            query.setParameter("assetListId", (Object)assetListId);
        }
        if (contextId != null) {
            query.setParameter("contextId", (Object)contextId);
        }
        return (TitleProperty)query.uniqueResult();
    }

    @Transactional
    public TitleProperty store(TitleProperty property) {
        this.checkRequiredFields(property);
        TitleProperty propertyInDB = this.getPropertyFromDB(property);
        Session session = this.getSession();
        if (propertyInDB != null) {
            propertyInDB.setValue(property.getValue());
            this.save(session, propertyInDB);
            return propertyInDB;
        }
        property.setId(null);
        this.save(session, property);
        return property;
    }

    private TitleProperty getPropertyFromDB(TitleProperty property) {
        Session session = this.getSession();
        TitleProperty propertyInDB = this.retrieve(session, property.getName(), property.getTitleId(), property.getAssetListId(), property.getContextId());
        return propertyInDB;
    }

    private void checkRequiredFields(TitleProperty property) {
        if (property.getName() == null || property.getName().trim().length() == 0) {
            throw new IllegalArgumentException("name cannot be null or empty");
        }
        if (property.getTitleId() == null) {
            throw new IllegalArgumentException("titleId cannot be null");
        }
    }

    private void save(Session session, TitleProperty property) {
        try {
            session.saveOrUpdate((Object)property);
            logger.debug((Object)("Saved TitleProperty " + property));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to save " + property, e);
        }
    }

    private Session getSession() {
        return HibernateContext.getContext().getCurrentSession();
    }

    @Transactional
    public void remove(TitleProperty property) {
        this.checkRequiredFields(property);
        TitleProperty propertyInDB = this.getPropertyFromDB(property);
        if (propertyInDB != null) {
            this.getSession().delete((Object)propertyInDB);
        }
    }
}

