/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.metadataconfig;

import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.watchpoint.pmm.dao.hibernate.HibernateContext;
import com.tandbergtv.watchpoint.pmm.entities.metadataconfig.AppType;
import com.tandbergtv.watchpoint.pmm.entities.metadataconfig.ContentAdvisory;
import com.tandbergtv.watchpoint.pmm.entities.metadataconfig.Genre;
import com.tandbergtv.watchpoint.pmm.entities.metadataconfig.Product;
import com.tandbergtv.watchpoint.pmm.entities.metadataconfig.Rating;
import com.tandbergtv.watchpoint.pmm.entities.metadataconfig.Studio;
import com.tandbergtv.watchpoint.pmm.metadataconfig.IMetadataConfigurator;
import com.tandbergtv.watchpoint.pmm.metadataconfig.MetadataConfigException;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;

public class MetadataConfiguratorImpl
implements IMetadataConfigurator {
    private static final String SELECT_RATING = "SelectRating";

    @Transactional
    public Boolean deleteAppType(List<String> appTypes) throws MetadataConfigException {
        if (appTypes == null || appTypes.size() == 0) {
            return false;
        }
        try {
            Session session = this.getSession();
            for (String appType : appTypes) {
                AppType obj = (AppType)session.get(AppType.class, (Serializable)((Object)appType));
                if (obj == null) {
                    return false;
                }
                session.delete((Object)obj);
            }
            return true;
        }
        catch (HibernateException he) {
            throw new MetadataConfigException((Throwable)he);
        }
    }

    @Transactional
    public Boolean deleteContentAdvsory(List<String> contentAdvisories) throws MetadataConfigException {
        if (contentAdvisories == null || contentAdvisories.size() == 0) {
            return false;
        }
        try {
            Session session = this.getSession();
            for (String contentAdvisory : contentAdvisories) {
                ContentAdvisory obj = (ContentAdvisory)session.get(ContentAdvisory.class, (Serializable)((Object)contentAdvisory));
                if (obj == null) {
                    return false;
                }
                session.delete((Object)obj);
            }
            return true;
        }
        catch (HibernateException he) {
            throw new MetadataConfigException((Throwable)he);
        }
    }

    @Transactional
    public Boolean deleteGenre(List<String> genres) throws MetadataConfigException {
        if (genres == null || genres.size() == 0) {
            return false;
        }
        try {
            Session session = this.getSession();
            for (String genre : genres) {
                Genre obj = (Genre)session.get(Genre.class, (Serializable)((Object)genre));
                if (obj == null) {
                    return false;
                }
                session.delete((Object)obj);
            }
            return true;
        }
        catch (HibernateException he) {
            throw new MetadataConfigException((Throwable)he);
        }
    }

    @Transactional
    public Boolean deleteProduct(List<String> productCodes) throws MetadataConfigException {
        if (productCodes == null || productCodes.size() == 0) {
            return false;
        }
        try {
            Session session = this.getSession();
            for (String productCode : productCodes) {
                Product obj = (Product)session.get(Product.class, (Serializable)((Object)productCode));
                if (obj == null) {
                    return false;
                }
                session.delete((Object)obj);
            }
            return true;
        }
        catch (HibernateException he) {
            throw new MetadataConfigException((Throwable)he);
        }
    }

    @Transactional
    public Boolean deleteRating(Map<String, String> ratings) throws MetadataConfigException {
        if (ratings == null || ratings.size() == 0) {
            return false;
        }
        try {
            Session session = this.getSession();
            Query query = session.getNamedQuery(SELECT_RATING);
            for (String rating : ratings.keySet()) {
                String ratingSystem = ratings.get(rating);
                query.setParameter("rating", (Object)rating);
                query.setParameter("ratingSystem", (Object)ratingSystem);
                Rating obj = (Rating)query.uniqueResult();
                session.delete((Object)obj);
            }
            return true;
        }
        catch (HibernateException he) {
            throw new MetadataConfigException((Throwable)he);
        }
    }

    @Transactional
    public Boolean deleteStuido(List<String> displayNames) throws MetadataConfigException {
        if (displayNames == null || displayNames.size() == 0) {
            return false;
        }
        try {
            Session session = this.getSession();
            for (String displayName : displayNames) {
                Studio obj = (Studio)session.get(Studio.class, (Serializable)((Object)displayName));
                if (obj == null) {
                    return false;
                }
                session.delete((Object)obj);
            }
            return true;
        }
        catch (HibernateException he) {
            throw new MetadataConfigException((Throwable)he);
        }
    }

    @Transactional
    public AppType getAppType(String appType) {
        Session session = this.getSession();
        AppType obj = (AppType)session.load(AppType.class, (Serializable)((Object)appType));
        return obj;
    }

    @Transactional
    public ContentAdvisory getContentAdvisory(String contentAdvisory) {
        Session session = this.getSession();
        ContentAdvisory obj = (ContentAdvisory)session.load(ContentAdvisory.class, (Serializable)((Object)contentAdvisory));
        return obj;
    }

    @Transactional
    public Genre getGenre(String genre) {
        Session session = this.getSession();
        Genre obj = (Genre)session.load(Genre.class, (Serializable)((Object)genre));
        return obj;
    }

    @Transactional
    public Product getProduct(String productCode) {
        Session session = this.getSession();
        Product obj = (Product)session.load(Product.class, (Serializable)((Object)productCode));
        return obj;
    }

    @Transactional
    public Rating getRating(String rating, String ratingSystem) {
        Session session = this.getSession();
        Query query = session.getNamedQuery(SELECT_RATING);
        query.setParameter("rating", (Object)rating);
        query.setParameter("ratingSystem", (Object)ratingSystem);
        Rating obj = (Rating)query.uniqueResult();
        return obj;
    }

    @Transactional
    public Studio getStudio(String displayName) {
        Session session = this.getSession();
        Studio obj = (Studio)session.load(Studio.class, (Serializable)((Object)displayName));
        return obj;
    }

    @Transactional
    public AppType updateAppType(AppType appType) throws MetadataConfigException {
        Session session = this.getSession();
        AppType obj = (AppType)session.get(AppType.class, (Serializable)((Object)appType.getAppType()));
        if (obj != null) {
            throw new MetadataConfigException("App Type [" + appType.getAppType() + "] already exists in the system.");
        }
        obj = new AppType();
        obj.setAppType(appType.getAppType());
        obj.setCreateDate(new Date());
        obj.setNotes(appType.getNotes());
        session.saveOrUpdate((Object)obj);
        return obj;
    }

    @Transactional
    public ContentAdvisory updateContentAdvisory(ContentAdvisory contentAdvisory) throws MetadataConfigException {
        Session session = this.getSession();
        ContentAdvisory obj = (ContentAdvisory)session.get(ContentAdvisory.class, (Serializable)((Object)contentAdvisory.getContentAdvisory()));
        if (obj != null) {
            throw new MetadataConfigException("Content Advisory [" + contentAdvisory.getContentAdvisory() + "] already exists in the system.");
        }
        obj = new ContentAdvisory();
        obj.setContentAdvisory(contentAdvisory.getContentAdvisory());
        obj.setCreateDate(new Date());
        obj.setDescription(contentAdvisory.getDescription());
        session.saveOrUpdate((Object)obj);
        return obj;
    }

    @Transactional
    public Genre updateGenre(Genre genre) throws MetadataConfigException {
        Session session = this.getSession();
        Genre obj = (Genre)session.get(Genre.class, (Serializable)((Object)genre.getGenre()));
        if (obj != null) {
            throw new MetadataConfigException("Genre [" + genre.getGenre() + "] already exists in the system.");
        }
        obj = new Genre();
        obj.setGenre(genre.getGenre());
        obj.setCreateDate(new Date());
        obj.setDescription(genre.getDescription());
        session.saveOrUpdate((Object)obj);
        return obj;
    }

    @Transactional
    public Product updateProduct(Product product) throws MetadataConfigException {
        Session session = this.getSession();
        Product obj = (Product)session.get(Product.class, (Serializable)((Object)product.getProductCode()));
        if (obj != null) {
            throw new MetadataConfigException("Product code [" + product.getProductCode() + "] already exists in the system.");
        }
        obj = new Product();
        obj.setProductCode(product.getProductCode());
        obj.setCreateDate(new Date());
        obj.setDescription(product.getDescription());
        session.saveOrUpdate((Object)obj);
        return obj;
    }

    @Transactional
    public Rating updateRating(Rating rating) throws MetadataConfigException {
        Session session = this.getSession();
        Query query = session.getNamedQuery(SELECT_RATING);
        query.setParameter("rating", (Object)rating.getRating());
        query.setParameter("ratingSystem", (Object)rating.getRatingSystem());
        Rating obj = (Rating)query.uniqueResult();
        if (obj != null) {
            throw new MetadataConfigException("Rating [" + rating.getRating() + "] already exists for Rating System [" + rating.getRatingSystem() + "].");
        }
        obj = new Rating();
        obj.setRating(rating.getRating());
        obj.setRatingSystem(rating.getRatingSystem());
        obj.setCreateDate(new Date());
        obj.setDescription(rating.getDescription());
        session.saveOrUpdate((Object)obj);
        return obj;
    }

    @Transactional
    public Studio updateStudio(Studio studio) throws MetadataConfigException {
        Session session = this.getSession();
        Studio obj = (Studio)session.get(Studio.class, (Serializable)((Object)studio.getDisplayName()));
        if (obj != null) {
            throw new MetadataConfigException("Studio [" + studio.getDisplayName() + "] already exists in the system.");
        }
        obj = new Studio();
        obj.setDisplayName(studio.getDisplayName());
        obj.setCreateDate(new Date());
        obj.setOrganizationName(studio.getOrganizationName());
        obj.setOrganizationCode(studio.getOrganizationCode());
        obj.setDescription(studio.getDescription());
        session.saveOrUpdate((Object)obj);
        return obj;
    }

    private Session getSession() {
        return HibernateContext.getContext().getCurrentSession();
    }

    public String getServiceName() {
        return "Metadata Configurator";
    }

    public void start() {
    }

    public void stop() {
    }
}

