/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.schedule.notify;

import com.ericsson.cms.sites.core.ISitePartnerManager;
import com.ericsson.cms.sites.core.entities.Site;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.watchpoint.pmm.entities.DistributionSchedule;
import com.tandbergtv.watchpoint.pmm.entities.Planner;
import com.tandbergtv.watchpoint.pmm.entities.Schedule;
import com.tandbergtv.watchpoint.pmm.schedule.notify.INotificationGenerator;
import com.tandbergtv.watchpoint.pmm.schedule.notify.PitchNotificationGenerator;
import com.tandbergtv.watchpoint.pmm.schedule.notify.PlannerNotificationGenerator;

public class NotificationGeneratorFactory {
    private ISitePartnerManager sitePartnerManager = (ISitePartnerManager)InjectionUtil.injectInstance((String)"/cms/SitePartnerManager/local", ISitePartnerManager.class);

    protected NotificationGeneratorFactory() {
    }

    public static NotificationGeneratorFactory newInstance() {
        return new NotificationGeneratorFactory();
    }

    public INotificationGenerator newGenerator(Schedule schedule) {
        if (schedule instanceof Planner) {
            return new PlannerNotificationGenerator();
        }
        if (schedule instanceof DistributionSchedule) {
            Site site = this.sitePartnerManager.getSiteByContextId(schedule.getContextID().longValue());
            return new PitchNotificationGenerator(site);
        }
        throw new UnsupportedOperationException("Notification generator for schedule " + schedule + " " + schedule.getClass() + " is not available");
    }
}

