/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.schedule.notify;

import com.tandbergtv.metadatamanager.util.XPathTranslator;
import com.tandbergtv.neptune.configuration.service.INeptuneUpgradeSettings;
import com.tandbergtv.watchpoint.pmm.schedule.ScheduleRuntimeException;
import com.tandbergtv.watchpoint.pmm.schedule.notify.AbstractNotificationGenerator;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ProgressFileUpgrade
implements INeptuneUpgradeSettings {
    String fileName = null;
    String confFolder = null;
    File file = null;
    private static final Logger logger = Logger.getLogger(ProgressFileUpgrade.class);

    public boolean needsUpgrade() {
        this.file = this.fileName.startsWith("/") || this.fileName.startsWith("\\") ? new File(this.fileName) : new File(this.confFolder, this.fileName);
        return this.file.exists();
    }

    public void setCMSBaseConfFolder(String confFolder) {
        this.confFolder = confFolder;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    private String getValue(Document document, String nodePath) throws Exception {
        XPath xpath = XPathFactory.newInstance().newXPath();
        Node node = (Node)xpath.evaluate(nodePath, document, XPathConstants.NODE);
        if (node != null) {
            return node.getTextContent();
        }
        return null;
    }

    public Map<String, String> upgrade() {
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        String fieldNamePath = "//variable/name";
        String fieldTypePath = "//variable/type";
        try {
            Node node;
            int i;
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(this.file);
            XPath xpath = XPathFactory.newInstance().newXPath();
            String path = "//schedule[@type='planner']/status";
            logger.debug((Object)("Path " + path));
            NodeList nodes = (NodeList)xpath.evaluate(path, document, XPathConstants.NODESET);
            String status = null;
            String offset = null;
            for (i = 0; i < nodes.getLength(); ++i) {
                node = nodes.item(i);
                status = (String)xpath.evaluate("name", node, XPathConstants.STRING);
                offset = (String)xpath.evaluate("offset", node, XPathConstants.STRING);
                logger.debug((Object)("Planner status = " + status + " offset = " + offset));
            }
            properties.put(AbstractNotificationGenerator.PROP_PLANNER_STATUS_OFFSET, offset);
            path = "//schedule[@type='pitch']/status";
            nodes = (NodeList)xpath.evaluate(path, document, XPathConstants.NODESET);
            for (i = 0; i < nodes.getLength(); ++i) {
                node = nodes.item(i);
                status = (String)xpath.evaluate("name", node, XPathConstants.STRING);
                offset = (String)xpath.evaluate("offset", node, XPathConstants.STRING);
            }
            properties.put(AbstractNotificationGenerator.PROP_PITCHER_STATUS_OFFSET, offset);
            Node fieldNameNode = (Node)xpath.evaluate(fieldNamePath, document, XPathConstants.NODE);
            Node fieldTypeNode = (Node)xpath.evaluate(fieldTypePath, document, XPathConstants.NODE);
            if (fieldNameNode == null || fieldTypeNode == null) {
                throw new ScheduleRuntimeException("Variable name and type must be specified.");
            }
            String metadataFieldName = fieldNameNode.getTextContent();
            metadataFieldName = new XPathTranslator().translateTTVtoECMF(metadataFieldName);
            logger.debug((Object)(" metadata field name" + metadataFieldName));
            String metadataFieldType = fieldTypeNode.getTextContent();
            properties.put(AbstractNotificationGenerator.PROP_FIELD_NAME, metadataFieldName);
            properties.put(AbstractNotificationGenerator.PROP_FIELD_TYPE, metadataFieldType);
            String pastDays = this.getValue(document, "//past");
            String futureDays = this.getValue(document, "//future");
            properties.put(AbstractNotificationGenerator.PROP_PAST, pastDays);
            properties.put(AbstractNotificationGenerator.PROP_FUTURE, futureDays);
            logger.debug((Object)("Properties from progress.xml: " + ((Object)properties).toString()));
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return properties;
    }

    public void upgradeApplied() {
        this.file.renameTo(new File(this.file.getAbsolutePath() + ".upgrade"));
    }

    public static void main(String[] arg) {
        ProgressFileUpgrade test = new ProgressFileUpgrade();
        test.file = new File("C:/opt/tandbergtv/cms/conf/pmm/progress.xml");
        Map<String, String> props = test.upgrade();
        System.out.println(props.toString());
    }
}

