/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title;

import com.ericsson.cms.neptune.cluster.Cluster;
import com.ericsson.cms.neptune.cluster.service.IClusterService;
import com.ericsson.cms.neptune.cluster.service.ITopicMessageListener;
import com.ericsson.cms.search.ElasticSearchService;
import com.ericsson.cms.search.ElasticSearchTitleSyncCleanupService;
import com.ericsson.cms.search.IElasticSearchService;
import com.ericsson.neptune.clustermgmt.service.ClusterConstant;
import com.hazelcast.core.HazelcastInstance;
import com.tandbergtv.cms.title.search.ITitleSearchService;
import com.tandbergtv.content.contentclass.hibernate.ContentClassOptionsProvider;
import com.tandbergtv.content.contentclass.hibernate.ContentClassServiceHibernate;
import com.tandbergtv.content.contentclass.service.IContentClassService;
import com.tandbergtv.content.contentclass.service.ICustomFieldManager;
import com.tandbergtv.content.lookupkey.LookupKeyManager;
import com.tandbergtv.content.lookupkey.service.ILookupKeyManager;
import com.tandbergtv.content.metadata.CustomFieldManager;
import com.tandbergtv.content.metadata.IMetadataService;
import com.tandbergtv.content.metadata.MetadataServiceImpl;
import com.tandbergtv.metadatamanager.IAssetCompareService;
import com.tandbergtv.metadatamanager.IAssetCopyService;
import com.tandbergtv.metadatamanager.ITTVDataModelHandler;
import com.tandbergtv.metadatamanager.JPFActivator;
import com.tandbergtv.metadatamanager.customfield.persistence.CustomFieldPersistenceService;
import com.tandbergtv.metadatamanager.customfield.persistence.ICustomFieldPersistenceService;
import com.tandbergtv.metadatamanager.factoryImpl.SpecHandlerFactory;
import com.tandbergtv.metadatamanager.spec.ISpecHandler;
import com.tandbergtv.metadatamanager.util.CompatibilityInfo;
import com.tandbergtv.metadatamanager.util.DataTypeMappingReader;
import com.tandbergtv.metadatamanager.util.FieldAliasMappingReader;
import com.tandbergtv.metadatamanager.util.FileFieldMappingReader;
import com.tandbergtv.metadatamanager.util.XPathMappingReader;
import com.tandbergtv.neptune.configuration.service.IConfigurationService;
import com.tandbergtv.neptune.configuration.service.INeptuneSettingChangeListener;
import com.tandbergtv.neptune.licensing.ILicenseManager;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.watchpoint.pmm.dao.hibernate.ApplicationContextHelper;
import com.tandbergtv.watchpoint.pmm.dao.hibernate.HibernateContext;
import com.tandbergtv.watchpoint.pmm.entities.IContainer;
import com.tandbergtv.watchpoint.pmm.metadataconfig.IMetadataConfigurationReader;
import com.tandbergtv.watchpoint.pmm.metadataconfig.IMetadataConfigurator;
import com.tandbergtv.watchpoint.pmm.metadataconfig.MetadataConfigurationReaderImpl;
import com.tandbergtv.watchpoint.pmm.metadataconfig.MetadataConfiguratorImpl;
import com.tandbergtv.watchpoint.pmm.title.ContainerCacheMessage;
import com.tandbergtv.watchpoint.pmm.title.ContentClassMessage;
import com.tandbergtv.watchpoint.pmm.title.DefaultTitlePersistenceService;
import com.tandbergtv.watchpoint.pmm.title.DistributedScheduler;
import com.tandbergtv.watchpoint.pmm.title.DistributedTitleMessage;
import com.tandbergtv.watchpoint.pmm.title.ILicenseUsageAudit;
import com.tandbergtv.watchpoint.pmm.title.ITitleActivityService;
import com.tandbergtv.watchpoint.pmm.title.ITitleAssetPropertyManager;
import com.tandbergtv.watchpoint.pmm.title.ITitleAssetResourceManager;
import com.tandbergtv.watchpoint.pmm.title.ITitleCompareService;
import com.tandbergtv.watchpoint.pmm.title.ITitleCopyService;
import com.tandbergtv.watchpoint.pmm.title.ITitleFileManager;
import com.tandbergtv.watchpoint.pmm.title.ITitleManager;
import com.tandbergtv.watchpoint.pmm.title.ITitlePersistenceService;
import com.tandbergtv.watchpoint.pmm.title.ITitleResourceManager;
import com.tandbergtv.watchpoint.pmm.title.ITitleService;
import com.tandbergtv.watchpoint.pmm.title.ITitleThumbnailReader;
import com.tandbergtv.watchpoint.pmm.title.LicenseAuditUsage;
import com.tandbergtv.watchpoint.pmm.title.TitleAssetPropertyManager;
import com.tandbergtv.watchpoint.pmm.title.TitleAssetResourceManager;
import com.tandbergtv.watchpoint.pmm.title.TitleFileManager;
import com.tandbergtv.watchpoint.pmm.title.TitleManager;
import com.tandbergtv.watchpoint.pmm.title.TitleSearchPersistenceService;
import com.tandbergtv.watchpoint.pmm.title.TitleService;
import com.tandbergtv.watchpoint.pmm.title.activity.TitleActivityService;
import com.tandbergtv.watchpoint.pmm.title.compare.TitleCompareService;
import com.tandbergtv.watchpoint.pmm.title.conf.AssetTypesConfigurationService;
import com.tandbergtv.watchpoint.pmm.title.conf.AutofillProvider;
import com.tandbergtv.watchpoint.pmm.title.conf.AutofillProviderFactory;
import com.tandbergtv.watchpoint.pmm.title.conf.IAssetTypesConfigurationService;
import com.tandbergtv.watchpoint.pmm.title.conf.ISpecificationManager;
import com.tandbergtv.watchpoint.pmm.title.conf.Specification;
import com.tandbergtv.watchpoint.pmm.title.conf.SpecificationBuilder;
import com.tandbergtv.watchpoint.pmm.title.conf.SpecificationManager;
import com.tandbergtv.watchpoint.pmm.title.conf.UISpecification;
import com.tandbergtv.watchpoint.pmm.title.conf.UISpecificationBuilder;
import com.tandbergtv.watchpoint.pmm.title.conf.specs.RightsManagerFactory;
import com.tandbergtv.watchpoint.pmm.title.copy.TitleCopyService;
import com.tandbergtv.watchpoint.pmm.title.ingest.ITitleIngestService;
import com.tandbergtv.watchpoint.pmm.title.ingest.TitleIngestService;
import com.tandbergtv.watchpoint.pmm.title.ingest.TitleIngester;
import com.tandbergtv.watchpoint.pmm.title.resource.TitleResourceManager;
import com.tandbergtv.watchpoint.pmm.title.search.TitleSearchService;
import com.tandbergtv.watchpoint.pmm.title.search.TitleSearchWorkFactory;
import com.tandbergtv.watchpoint.pmm.title.template.ITitleTemplateProvider;
import com.tandbergtv.watchpoint.pmm.title.template.TitleTemplateProvider;
import com.tandbergtv.watchpoint.pmm.title.thumbnail.TitleThumbnailReader;
import com.tandbergtv.watchpoint.pmm.title.usagemonitor.ILicenseMonitor;
import com.tandbergtv.watchpoint.pmm.title.usagemonitor.LicenseMonitorService;
import com.tandbergtv.watchpoint.pmm.util.DistributedTopic;
import com.tandbergtv.watchpoint.pmm.util.ServiceUtil;
import com.tandbergtv.workflow.core.service.Service;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.service.cache.ICacheService;
import com.tandbergtv.workflow.core.service.thread.Scheduler;
import java.io.File;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.java.plugin.PluginManager;
import org.java.plugin.registry.ExtensionPoint;
import org.java.plugin.registry.PluginRegistry;
import org.springframework.context.ApplicationContext;

public class TitleActivator
implements INeptuneSettingChangeListener,
ITopicMessageListener<DistributedTitleMessage> {
    private static final String PLUGIN_ID = "com.tandbergtv.metadata";
    private static final String INTERNAL_SPECIFICATION = "TTV";
    public static final String CONTENT_PLUGIN_FOLDER_RELATIVE_PATH = "plugins" + File.separator + "content";
    public static final String JPF_PLUGIN_REPOSITORY_PROPERTY = "org.java.plugin.boot.pluginsRepositories";
    public static final String PRODUCT_DIR = "com.tandbergtv.cms.product.dir";
    public static final String DISTRIBUTED_TITLE_TOPIC_NAME = "TITLE_TOPIC";
    public static final String plugin_scheduler_name = "plugin-scheduler";
    private static final String[] CONTEXT_CONFIG_FILES = new String[]{"MetadataBeansContext.xml", "com/tandbergtv/watchpoint/pmm/dao/hibernate/TitleMetadataManagerDB_JTA_Context.xml", "META-INF/metadatamanager/MDM_DataSource.xml"};
    private static final String DST_METADATA_PLUGIN_MAP = "dstMetadataPluginMap";
    private Map<String, String> dstMetadataPluginMap;
    private static final Logger logger = Logger.getLogger(TitleActivator.class);
    private IClusterService hzcs;

    public void start() {
        ApplicationContext context = this.initializeSpringContext();
        ITTVDataModelHandler assetDataModelHandler = this.getAssetDataModelHandler(context);
        PluginManager pluginManager = this.intializeMetadataPlugins();
        HibernateContext.getContext().initializeContext();
        ServiceUtil.addService(new ElasticSearchService());
        ServiceUtil.addService((Service)new ContentClassServiceHibernate());
        ServiceUtil.addService(new LicenseMonitorService());
        ServiceUtil.addService((Service)new MetadataConfigurationReaderImpl());
        ServiceUtil.addService((Service)new MetadataConfiguratorImpl());
        ServiceUtil.addService((Service)new ContentClassOptionsProvider());
        ServiceUtil.addService(new DefaultTitlePersistenceService(assetDataModelHandler));
        ServiceUtil.addService((Service)new TitleSearchPersistenceService());
        ServiceUtil.addService((Service)new TitleSearchService());
        ServiceUtil.addService((Service)TitleSearchWorkFactory.createAssetInfoProvider());
        ServiceUtil.addService((Service)new LookupKeyManager());
        ServiceUtil.addService((Service)new SpecificationManager());
        ServiceUtil.addService((Service)new TitleManager());
        ServiceUtil.addService((Service)new TitleFileManager());
        ServiceUtil.addService((Service)TitleService.getInstance());
        ServiceUtil.addService(new TitleResourceManager());
        ServiceUtil.addService(new TitleAssetPropertyManager());
        ServiceUtil.addService((Service)new TitleAssetResourceManager());
        ServiceUtil.addService((Service)new TitleThumbnailReader());
        ServiceUtil.addService((Service)new TitleTemplateProvider());
        ServiceUtil.addService((Service)new TitleCopyService((IAssetCopyService)assetDataModelHandler));
        ServiceUtil.addService((Service)new TitleCompareService((IAssetCompareService)assetDataModelHandler));
        ServiceUtil.addService((Service)new TitleActivityService());
        ServiceUtil.addService((Service)new TitleIngestService());
        ServiceUtil.addService((Service)new TitleIngester());
        ServiceUtil.addService((Service)AssetTypesConfigurationService.newInstance());
        ServiceUtil.addService((Service)new MetadataServiceImpl());
        ServiceUtil.addService((Service)new CustomFieldManager());
        ServiceUtil.addService(new ElasticSearchTitleSyncCleanupService());
        ServiceUtil.addService(new DistributedScheduler(plugin_scheduler_name, 1));
        ServiceUtil.addService(new LicenseAuditUsage());
        this.addMetadataFormatSpecifications(pluginManager, context);
        this.initializeUISpecification(pluginManager);
        this.loadRightsManager(pluginManager);
        this.initializeDistributedTopic();
        this.hzcs = Cluster.getService((String)ClusterConstant.CLUSTER_CONFIG_PATH);
        HazelcastInstance haz = this.hzcs.getInstance();
        this.dstMetadataPluginMap = haz.getMap(DST_METADATA_PLUGIN_MAP);
        this.addPluginsToDisCache(pluginManager);
        logger.debug((Object)"Title services started");
    }

    private void initializeDistributedTopic() {
        DistributedTopic distributedTitleTopic = new DistributedTopic(DISTRIBUTED_TITLE_TOPIC_NAME);
        ServiceUtil.addService((Service)distributedTitleTopic);
        distributedTitleTopic.subscribe((ITopicMessageListener)this);
    }

    private void updateAutofillProviders() {
        IConfigurationService configService = (IConfigurationService)InjectionUtil.injectInstance((String)"cms/ConfigurationService/local", IConfigurationService.class);
        String path = "com.ericsson.cms.contentmgmt.autofill";
        Map props = configService.getProperties(path);
        List<AutofillProvider> list = AutofillProviderFactory.createAutofillProviderList(props);
        ISpecificationManager sm = (ISpecificationManager)ServiceRegistry.getDefault().lookup(ISpecificationManager.class);
        sm.getUISpecification(UISpecification.Type.PACKAGE).setAutofillProviders(list);
        sm.getUISpecification(UISpecification.Type.SERIES).setAutofillProviders(list);
    }

    private void initializeUISpecification(PluginManager pluginManager) {
        ISpecificationManager sm = (ISpecificationManager)ServiceRegistry.getDefault().lookup(ISpecificationManager.class);
        UISpecificationBuilder builder = new UISpecificationBuilder(pluginManager);
        UISpecification packageSpec = builder.buildPackageSpecification();
        UISpecification seriesSpec = builder.buildSeriesSpecification(packageSpec);
        sm.setUISpecification(UISpecification.Type.PACKAGE, packageSpec);
        sm.setUISpecification(UISpecification.Type.SERIES, seriesSpec);
        ICustomFieldManager cfm = (ICustomFieldManager)ServiceRegistry.getDefault().lookup(ICustomFieldManager.class);
        Map groups = cfm.getAllCustomFieldsForUISpec();
        sm.updateUISpecifications(groups);
        this.updateAutofillProviders();
    }

    private void loadRightsManager(PluginManager pluginManager) {
        PluginRegistry registry = pluginManager.getRegistry();
        ExtensionPoint point = registry.getExtensionPoint(PLUGIN_ID, "rightsManager");
        RightsManagerFactory.createRightsManager(pluginManager, point);
    }

    public void stop() {
        ServiceUtil.removeService(DISTRIBUTED_TITLE_TOPIC_NAME);
        ServiceUtil.removeService(IElasticSearchService.class);
        ServiceUtil.removeService(ILicenseMonitor.class);
        ServiceUtil.removeService(ICustomFieldManager.class);
        ServiceUtil.removeService(IMetadataService.class);
        ServiceUtil.removeService(ITitleIngestService.class);
        ServiceUtil.removeService(ITitleActivityService.class);
        ServiceUtil.removeService(ITitleCompareService.class);
        ServiceUtil.removeService(ITitleCopyService.class);
        ServiceUtil.removeService(ITitleTemplateProvider.class);
        ServiceUtil.removeService(ITitleThumbnailReader.class);
        ServiceUtil.removeService(ITitleAssetResourceManager.class);
        ServiceUtil.removeService(ITitleAssetPropertyManager.class);
        ServiceUtil.removeService(ITitleResourceManager.class);
        ServiceUtil.removeService(ITitleService.class);
        ServiceUtil.removeService(ITitleFileManager.class);
        ServiceUtil.removeService(ITitleManager.class);
        ServiceUtil.removeService(ISpecificationManager.class);
        ServiceUtil.removeService(ILookupKeyManager.class);
        ServiceUtil.removeService(ITitleSearchService.class);
        ServiceUtil.removeService(ITitlePersistenceService.class);
        ServiceUtil.removeService(IContentClassService.class);
        ServiceUtil.removeService(IAssetTypesConfigurationService.class);
        ServiceUtil.removeService(IMetadataConfigurator.class);
        ServiceUtil.removeService(IMetadataConfigurationReader.class);
        ServiceUtil.removeService(DistributedScheduler.class);
        ServiceUtil.removeService(ILicenseUsageAudit.class);
        HibernateContext.getContext().closeContext();
        logger.debug((Object)"Title services stopped");
    }

    private void addMetadataFormatSpecifications(PluginManager pluginManager, ApplicationContext context) {
        DataTypeMappingReader dt = DataTypeMappingReader.getInstance((PluginManager)pluginManager);
        ICustomFieldPersistenceService cfs = CustomFieldPersistenceService.getInstance((ApplicationContext)context);
        dt.refreshCustomFieldDataTypeMap(cfs.getAllGroups());
        FileFieldMappingReader.getInstance((PluginManager)pluginManager);
        FieldAliasMappingReader.getInstance((PluginManager)pluginManager);
        CompatibilityInfo.getInstance((PluginManager)pluginManager);
        XPathMappingReader.getInstance();
        new com.tandbergtv.metadatamanager.conf.SpecificationBuilder(pluginManager, context).buildSpecifications();
        int maxCount = this.getMetadataPluginMaxCount();
        if (maxCount > 0) {
            Map map = SpecHandlerFactory.getHandlers();
            int count = 0;
            TreeSet<String> keysToRemove = new TreeSet<String>();
            for (ISpecHandler handler : map.values()) {
                if (!INTERNAL_SPECIFICATION.equals(handler.getSpecName())) {
                    ++count;
                }
                if (count <= maxCount || INTERNAL_SPECIFICATION.equals(handler.getSpecName())) continue;
                keysToRemove.add(handler.getSpecName());
            }
            if (!keysToRemove.isEmpty()) {
                logger.info((Object)("Your license only allows to load " + maxCount + " plugins."));
                for (String key : keysToRemove) {
                    logger.info((Object)("Removing " + key));
                    map.remove(key);
                }
            }
        }
        ISpecificationManager sm = (ISpecificationManager)ServiceRegistry.getDefault().lookup(ISpecificationManager.class);
        SpecificationBuilder builder = SpecificationBuilder.createInstance(pluginManager, SpecHandlerFactory.getHandlers());
        for (Specification specification : builder.buildSpecifications()) {
            if (INTERNAL_SPECIFICATION.equals(specification.getAlias())) {
                sm.setInternalSpecification(specification);
                continue;
            }
            sm.addSpecification(specification);
        }
    }

    private int getMetadataPluginMaxCount() {
        try {
            ILicenseManager mgr = (ILicenseManager)InjectionUtil.injectInstance((String)"cms/LicenseManager/local", ILicenseManager.class);
            String str = mgr.getProperty("MetadataFormats.MaxCount");
            if (str == null || str.isEmpty()) {
                return 0;
            }
            return Integer.parseInt(str);
        }
        catch (Exception ex) {
            logger.error((Object)"Unable to get Metadata Plugin max count from the license manager.", (Throwable)ex);
            return 0;
        }
    }

    private void addPluginsToDisCache(PluginManager pluginManager) {
        SpecificationBuilder builder = SpecificationBuilder.createInstance(pluginManager, SpecHandlerFactory.getHandlers());
        for (Specification specification : builder.buildSpecifications()) {
            String specAlias = specification.getAlias();
            if (this.dstMetadataPluginMap.get(specAlias) != null) continue;
            this.dstMetadataPluginMap.put(specAlias, specification.getName());
        }
    }

    private ApplicationContext initializeSpringContext() {
        logger.debug((Object)"Initializing the Metadata Manager spring context...");
        ApplicationContextHelper helper = new ApplicationContextHelper(CONTEXT_CONFIG_FILES);
        logger.debug((Object)"Successfully initialized the Metadata Manager spring context.");
        return helper.getContext();
    }

    private PluginManager intializeMetadataPlugins() {
        Properties properties = new Properties();
        String installFolder = System.getProperty(PRODUCT_DIR);
        File pluginFolder = new File(installFolder, CONTENT_PLUGIN_FOLDER_RELATIVE_PATH);
        properties.put(JPF_PLUGIN_REPOSITORY_PROPERTY, pluginFolder.getAbsolutePath());
        JPFActivator jpfActivator = new JPFActivator();
        jpfActivator.start(properties);
        return jpfActivator.getPluginManager();
    }

    private ITTVDataModelHandler getAssetDataModelHandler(ApplicationContext context) {
        return (ITTVDataModelHandler)context.getBean("TTVSpecHandler");
    }

    public void settingsChanged(Map<String, String> props) {
        this.updateAutofillProviders();
        DistributedTopic topic = (DistributedTopic)ServiceRegistry.getDefault().lookup(DISTRIBUTED_TITLE_TOPIC_NAME);
        DistributedTitleMessage msg = new DistributedTitleMessage(2);
        topic.publish((Object)msg);
    }

    public void onMessage(DistributedTitleMessage msg) {
        logger.info((Object)("ITopicMessageListener: Got message " + msg.getMessageType() + " from " + msg.getSender()));
        if (this.hzcs.isLocalMember(msg.getSender())) {
            logger.info((Object)("ITopicMessageListener: Skipping local message " + msg.getMessageType() + " from " + msg.getSender()));
            return;
        }
        switch (msg.getMessageType()) {
            case 1: {
                this.updateCustomFields();
                break;
            }
            case 2: {
                this.updateAutofillProviders();
                break;
            }
            case 3: {
                ContentClassMessage ccm = (ContentClassMessage)msg;
                this.updateContentClass(ccm.getContentClassId(), ccm.isDelete());
                break;
            }
            case 4: {
                ContainerCacheMessage cm = (ContainerCacheMessage)msg;
                this.updateContainerCache(cm.getOperation(), cm.getContextId(), cm.getContainer());
                break;
            }
        }
    }

    private void updateCustomFields() {
        try {
            ICustomFieldManager cfm = (ICustomFieldManager)ServiceRegistry.getDefault().lookup(ICustomFieldManager.class);
            List groups = cfm.getAllGroups();
            DataTypeMappingReader dt = DataTypeMappingReader.getInstance(null, null);
            dt.refreshCustomFieldDataTypeMap(groups);
            ISpecificationManager sm = (ISpecificationManager)ServiceRegistry.getDefault().lookup(ISpecificationManager.class);
            sm.updateUISpecifications(CustomFieldManager.createCustomFieldMap(groups));
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
    }

    private void updateContentClass(long contentClassId, boolean isDelete) {
        IContentClassService ccService = (IContentClassService)ServiceRegistry.getDefault().lookup(IContentClassService.class);
        if (isDelete) {
            ccService.updateContentClassCache(contentClassId, isDelete);
        }
        new Scheduler("Synchronize content class type.").schedule(() -> {
            ccService.updateContentClassCache(contentClassId, isDelete);
            return null;
        }, 10000L);
    }

    private void updateContainerCache(int type, long contextId, IContainer container) {
        ServiceRegistry registry = ServiceRegistry.getDefault();
        ICacheService svc = (ICacheService)registry.lookup("Container Cache");
        if (type == 0) {
            svc.add((Serializable)Long.valueOf(contextId), (Object)container);
        } else if (type == 1) {
            svc.remove((Serializable)Long.valueOf(contextId));
        }
    }
}

