/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title;

import com.tandbergtv.metadatamanager.exception.MetadataException;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.metadatamanager.model.File;
import com.tandbergtv.metadatamanager.model.FileType;
import com.tandbergtv.metadatamanager.model.Relation;
import com.tandbergtv.watchpoint.pmm.title.ITitleAssetManager;
import com.tandbergtv.watchpoint.pmm.title.ITitlePersistenceService;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

class TitleAssetManager
implements ITitleAssetManager {
    TitleAssetManager() {
    }

    public Set<String> getFileLookupKeys(Asset asset) {
        if (this.isFile(asset)) {
            throw new IllegalArgumentException("The asset cannot be a File.");
        }
        HashSet<String> lookupKeys = new HashSet<String>();
        for (File file : asset.getDirectDescendantFiles()) {
            String lookupKey = this.getFileLookupKey(file);
            if (this.isNullOrBlank(lookupKey)) continue;
            lookupKeys.add(this.getFileLookupKey(file));
        }
        return lookupKeys;
    }

    public String getFileLookupKey(File file) {
        Field field = file.getFirstField("/Fields/CustomFields/CustomField[@name=LookupKey]/@value");
        String value = field != null ? field.getValue() : null;
        return value;
    }

    public File getFileWithLookupKey(Asset asset, String fileLookupKey) {
        if (this.isFile(asset)) {
            throw new IllegalArgumentException("The asset cannot be a File.");
        }
        if (this.isNullOrBlank(fileLookupKey)) {
            throw new IllegalArgumentException("The fileLookupKey cannot be null or blank.");
        }
        for (File file : asset.getDirectDescendantFiles()) {
            if (!fileLookupKey.equals(this.getFileLookupKey(file))) continue;
            return file;
        }
        return null;
    }

    public Collection<File> getFilesWithoutLookupKey(Asset asset) {
        if (this.isFile(asset)) {
            throw new IllegalArgumentException("The asset cannot be a File.");
        }
        ArrayList<File> files = new ArrayList<File>();
        for (File file : asset.getDirectDescendantFiles()) {
            String fileLookupKey = this.getFileLookupKey(file);
            if (!this.isNullOrBlank(fileLookupKey)) continue;
            files.add(file);
        }
        return files;
    }

    public void filterFiles(Asset asset, Set<String> fileLookupKeys) {
        if (this.isFile(asset)) {
            return;
        }
        Iterator relationIterator = asset.getRelations().iterator();
        while (relationIterator.hasNext()) {
            Relation relation = (Relation)relationIterator.next();
            if (!this.isFilteredRelation(relation, fileLookupKeys)) continue;
            relationIterator.remove();
        }
    }

    public void filterFiles(Asset asset, String fileLookupKey) {
        HashSet<String> fileLookupKeys = new HashSet<String>();
        fileLookupKeys.add(fileLookupKey);
        this.filterFiles(asset, fileLookupKeys);
    }

    private boolean isFilteredRelation(Relation relation, Set<String> fileLookupKeys) {
        Asset asset = relation.getTargetAsset();
        if (!this.isFile(asset)) {
            return false;
        }
        Iterator relationIterator = asset.getRelations().iterator();
        while (relationIterator.hasNext()) {
            Relation childRelation = (Relation)relationIterator.next();
            if (!this.isFilteredRelation(childRelation, fileLookupKeys)) continue;
            relationIterator.remove();
        }
        String value = this.getFileLookupKey((File)asset);
        if (this.isNullOrBlank(value)) {
            value = "";
        }
        if (fileLookupKeys.contains(value)) {
            return false;
        }
        return asset.getRelations().size() == 0;
    }

    public void updateWithFileMetadata(Asset asset, String fileLookupKey) throws MetadataException {
        if (this.isFile(asset) || this.isNullOrBlank(fileLookupKey)) {
            return;
        }
        File file = this.getFileWithLookupKey(asset, fileLookupKey);
        if (file != null) {
            asset.updateWithFileMetadata(file);
        }
    }

    private boolean isFile(Asset asset) {
        return asset instanceof File;
    }

    private boolean isNullOrBlank(String value) {
        return value == null || value.length() == 0;
    }

    public void setLookupKey(File file, String value) {
        Field field = file.getFirstField("/Fields/CustomFields/CustomField[@name=LookupKey]/@value");
        if (field == null) {
            file.addField(new Field("/Fields/CustomFields/CustomField[@name=LookupKey]/@value", value));
        } else {
            field.setValue(value);
        }
    }

    public File createDerivedFile() {
        File result = new File();
        result.setFileType(FileType.DERIVED);
        return result;
    }

    public File createOriginalFile() {
        File result = new File();
        result.setFileType(FileType.ORIGINAL);
        this.setLookupKey(result, "ORIGINAL");
        return result;
    }

    public Asset getAsset(Long id) {
        ITitlePersistenceService tps = (ITitlePersistenceService)ServiceRegistry.getDefault().lookup(ITitlePersistenceService.class);
        return tps.getAsset(id);
    }
}

