/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title;

import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.watchpoint.pmm.entities.TitleAssetProperty;
import com.tandbergtv.watchpoint.pmm.entities.TitleAssetResource;
import com.tandbergtv.watchpoint.pmm.entities.TitleResource;
import com.tandbergtv.watchpoint.pmm.title.ITitleAssetResourceManager;
import com.tandbergtv.watchpoint.pmm.title.ITitleResourceManager;
import com.tandbergtv.watchpoint.pmm.title.TitleAssetPropertyManager;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class TitleAssetResourceManager
implements ITitleAssetResourceManager {
    private final String KEY_FRAMES = "KEY_FRAMES";
    private final String STILL_IMAGE = "STILL_IMAGE";
    private final String THUMBNAIL = "THUMBNAIL";
    private final String THUMBNAIL_LARGE_SUFFIX = "large";
    private final String THUMBNAIL_MEDIUM_SUFFIX = "medium";

    private TitleAssetPropertyManager getService() {
        return (TitleAssetPropertyManager)ServiceRegistry.getDefault().lookup(TitleAssetPropertyManager.class);
    }

    private ITitleResourceManager getTitleResourceManager() {
        return (ITitleResourceManager)ServiceRegistry.getDefault().lookup(ITitleResourceManager.class);
    }

    private TitleAssetResource propertyToResource(TitleAssetProperty property) {
        if (property == null) {
            return null;
        }
        TitleAssetResource resource = new TitleAssetResource();
        resource.setResourcePath(property.getValue());
        resource.setAssetId(property.getAssetId().longValue());
        resource.setTitleId(property.getTitleId().longValue());
        if ("THUMBNAIL".equals(property.getName())) {
            resource.setResourceType(TitleAssetResource.ResourceType.THUMBNAIL);
        } else if ("STILL_IMAGE".equals(property.getName())) {
            resource.setResourceType(TitleAssetResource.ResourceType.STILL_IMAGE);
        } else if ("KEY_FRAMES".equals(property.getName())) {
            resource.setResourceType(TitleAssetResource.ResourceType.KEY_FRAMES);
        }
        resource.setCreateDate(property.getUpdateDate());
        return resource;
    }

    private List<TitleAssetResource> propertyListToResourceList(List<TitleAssetProperty> propertyList) {
        ArrayList<TitleAssetResource> resourceList = new ArrayList<TitleAssetResource>();
        for (TitleAssetProperty property : propertyList) {
            TitleAssetResource resource = this.propertyToResource(property);
            resourceList.add(resource);
        }
        return resourceList;
    }

    @Transactional
    public TitleAssetResource getKeyFrames(long titleId, long assetId) {
        List<TitleAssetProperty> list = this.getService().getByTitleAsset(titleId, assetId, "KEY_FRAMES");
        if (list == null || list.size() == 0) {
            return null;
        }
        TitleAssetProperty property = list.get(0);
        TitleAssetResource resource = this.propertyToResource(property);
        return resource;
    }

    @Transactional
    public List<TitleAssetResource> getKeyFrames(long titleId) {
        List<TitleAssetProperty> propertyList = this.getService().getByTitleAsset(titleId, "KEY_FRAMES");
        List<TitleAssetResource> resourceList = this.propertyListToResourceList(propertyList);
        return resourceList;
    }

    @Transactional
    public List<TitleAssetResource> getStillImages(long titleId, long assetId) {
        List<TitleAssetProperty> propertyList = this.getService().getByTitleAsset(titleId, assetId, "STILL_IMAGE");
        List<TitleAssetResource> resourceList = this.propertyListToResourceList(propertyList);
        return resourceList;
    }

    @Transactional
    public List<TitleAssetResource> getStillImages(long titleId) {
        List<TitleAssetProperty> propertyList = this.getService().getByTitleAsset(titleId, "STILL_IMAGE");
        List<TitleAssetResource> resourceList = this.propertyListToResourceList(propertyList);
        return resourceList;
    }

    @Transactional
    public TitleAssetResource getThumbnail(long titleId, long assetId) {
        List<TitleAssetProperty> propertyList = this.getService().getByTitleAsset(titleId, assetId, "THUMBNAIL");
        List<TitleAssetProperty> filterPropertyList = this.getFilteredThumbnails(propertyList);
        if (filterPropertyList == null || propertyList.size() == 0) {
            return null;
        }
        return this.propertyToResource(filterPropertyList.get(0));
    }

    @Transactional
    public List<TitleAssetResource> getThumbnails(long titleId) {
        List<TitleAssetProperty> propertyList = this.getService().getByTitleAsset(titleId, "THUMBNAIL");
        List<TitleAssetProperty> filterPropertyList = this.getFilteredThumbnails(propertyList);
        if (filterPropertyList == null || filterPropertyList.size() == 0) {
            return null;
        }
        return this.propertyListToResourceList(filterPropertyList);
    }

    private List<TitleAssetProperty> getFilteredThumbnails(List<TitleAssetProperty> propertyList) {
        if (propertyList == null || propertyList.size() == 0) {
            return null;
        }
        ArrayList<TitleAssetProperty> filterPropertyList = new ArrayList<TitleAssetProperty>();
        for (TitleAssetProperty property : propertyList) {
            String resourcePath = property.getValue();
            if (resourcePath.toLowerCase().contains("large") || resourcePath.toLowerCase().contains("medium")) continue;
            filterPropertyList.add(property);
        }
        return filterPropertyList;
    }

    @Transactional
    public void registerKeyFrames(long titleId, long assetId, String assetType, String keyFramesPath) {
        this.getTitleResourceManager().save(new TitleResource(titleId, keyFramesPath));
        TitleAssetProperty property = null;
        List<TitleAssetProperty> properties = this.getService().getByTitleAsset(titleId, assetId, "KEY_FRAMES");
        if (properties == null || properties.size() == 0) {
            property = new TitleAssetProperty();
            property.setAssetId(Long.valueOf(assetId));
            property.setName("KEY_FRAMES");
            property.setTitleId(Long.valueOf(titleId));
            if (assetType != null) {
                property.setValue(assetType);
            }
            property.setValue(keyFramesPath);
            property.setUpdateDate(new Date());
        } else {
            property = properties.get(0);
            property.setValue(keyFramesPath);
            property.setUpdateDate(new Date());
        }
        this.getService().save(property);
    }

    @Transactional
    public void registerStillImage(long titleId, long assetId, String assetType, String imagePath) {
        TitleAssetProperty property;
        this.getTitleResourceManager().save(new TitleResource(titleId, imagePath));
        List<TitleAssetProperty> properties = this.getService().getByTitleAsset(titleId, assetId, "STILL_IMAGE");
        boolean save = true;
        for (TitleAssetProperty property2 : properties) {
            if (imagePath == null || !imagePath.equals(property2.getValue())) continue;
            save = false;
        }
        if (save) {
            property = new TitleAssetProperty();
            property = new TitleAssetProperty();
            property.setAssetId(Long.valueOf(assetId));
            property.setName("STILL_IMAGE");
            property.setTitleId(Long.valueOf(titleId));
            property.setValue(imagePath);
            if (assetType != null) {
                property.setValue(assetType);
            }
        } else {
            throw new RuntimeException("Still Image with titleId: " + titleId + " , assetId: " + assetId + ", and value: " + imagePath + " already registered in the database");
        }
        property.setUpdateDate(new Date());
        this.getService().save(property);
    }

    @Transactional
    public void registerThumbnail(long titleId, long assetId, String assetType, String thumbnailPath) {
        this.getTitleResourceManager().save(new TitleResource(titleId, thumbnailPath));
        TitleAssetProperty property = null;
        List<TitleAssetProperty> properties = this.getService().getByTitleAsset(titleId, assetId, "THUMBNAIL");
        if (properties != null && properties.size() > 0) {
            for (TitleAssetProperty p : properties) {
                if (!p.getTitleId().equals(titleId) || !p.getAssetId().equals(assetId) || !p.getAssetType().equalsIgnoreCase(assetType) || !p.getValue().equalsIgnoreCase(thumbnailPath)) continue;
                property = p;
                property.setUpdateDate(new Date());
                break;
            }
        }
        if (property == null) {
            property = new TitleAssetProperty();
            property.setAssetId(Long.valueOf(assetId));
            property.setAssetType(assetType);
            property.setName("THUMBNAIL");
            property.setTitleId(Long.valueOf(titleId));
            property.setValue(thumbnailPath);
            property.setUpdateDate(new Date());
        }
        this.getService().save(property);
    }

    @Transactional
    public void unregisterKeyFrames(long titleId, long assetId) {
        List<TitleAssetProperty> properties = this.getService().getByTitleAsset(titleId, assetId);
        for (TitleAssetProperty property : properties) {
            if (!"KEY_FRAMES".equals(property.getName())) continue;
            this.getService().delete(property.getId());
        }
    }

    @Transactional
    public void unregisterResourcesForTitle(long titleId) {
        List<TitleAssetProperty> properties = this.getService().getByTitle(titleId);
        for (TitleAssetProperty property : properties) {
            if ("KEY_FRAMES".equals(property.getName())) {
                this.getService().delete(property.getId());
                continue;
            }
            if ("THUMBNAIL".equals(property.getName())) {
                this.getService().delete(property.getId());
                continue;
            }
            if (!"STILL_IMAGE".equals(property.getName())) continue;
            this.getService().delete(property.getId());
        }
    }

    @Transactional
    public void unregisterStillImages(long titleId, long assetId, String imagePath) {
        List<TitleAssetProperty> properties = this.getService().getByTitleAsset(titleId, assetId);
        for (TitleAssetProperty property : properties) {
            if (!"STILL_IMAGE".equals(property.getName()) || !property.getValue().equals(imagePath)) continue;
            this.getService().delete(property.getId());
        }
    }

    @Transactional
    public void unregisterStillImages(long titleId, long assetId) {
        List<TitleAssetProperty> properties = this.getService().getByTitleAsset(titleId, assetId);
        for (TitleAssetProperty property : properties) {
            if (!"STILL_IMAGE".equals(property.getName())) continue;
            this.getService().delete(property.getId());
        }
    }

    @Transactional
    public void unregisterThumbnail(long titleId, long assetId) {
        List<TitleAssetProperty> properties = this.getService().getByTitleAsset(titleId, assetId);
        for (TitleAssetProperty property : properties) {
            if (!"THUMBNAIL".equals(property.getName())) continue;
            this.getService().delete(property.getId());
        }
    }

    public String getServiceName() {
        return "TitleAssetResourceManager";
    }

    public void start() {
    }

    public void stop() {
    }

    public List<TitleAssetResource> getUnfilterThumbnailList(long titleId, long assetId) {
        List<TitleAssetProperty> propertyList = this.getService().getByTitleAsset(titleId, assetId, "THUMBNAIL");
        List<TitleAssetResource> resourceList = this.propertyListToResourceList(propertyList);
        return resourceList;
    }

    public List<TitleAssetResource> getUnfilterThumbnailList(long titleId) {
        List<TitleAssetProperty> propertyList = this.getService().getByTitleAsset(titleId, "THUMBNAIL");
        List<TitleAssetResource> resourceList = this.propertyListToResourceList(propertyList);
        return resourceList;
    }
}

