/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title;

import com.ericsson.cms.criteria.ExpNode;
import com.ericsson.cms.criteria.ExpValue;
import com.ericsson.cms.criteria.FieldType;
import com.ericsson.cms.criteria.LogicalOperator;
import com.ericsson.cms.criteria.Predicate;
import com.ericsson.cms.criteria.PredicateRightValue;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.cms.title.search.ITitleSearchService;
import com.tandbergtv.content.contentclass.entities.ContentClass;
import com.tandbergtv.content.contentclass.service.ContentClassPersistenceException;
import com.tandbergtv.content.contentclass.service.IContentClassService;
import com.tandbergtv.metadatamanager.exception.InvalidRevisionException;
import com.tandbergtv.metadatamanager.exception.MetadataException;
import com.tandbergtv.metadatamanager.exception.SearchException;
import com.tandbergtv.metadatamanager.exception.TranslationException;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.metadatamanager.model.FieldName;
import com.tandbergtv.metadatamanager.model.File;
import com.tandbergtv.metadatamanager.spec.IIdentifier;
import com.tandbergtv.metadatamanager.spec.ISpecHandler;
import com.tandbergtv.metadatamanager.util.AssetUtil;
import com.tandbergtv.watchpoint.pmm.core.ITitleStatusService;
import com.tandbergtv.watchpoint.pmm.core.NoTitleForAnAssetException;
import com.tandbergtv.watchpoint.pmm.core.PMMException;
import com.tandbergtv.watchpoint.pmm.core.TitleValidationException;
import com.tandbergtv.watchpoint.pmm.core.TitleValidationMessage;
import com.tandbergtv.watchpoint.pmm.entities.ISavedTitle;
import com.tandbergtv.watchpoint.pmm.entities.ITitleActionSource;
import com.tandbergtv.watchpoint.pmm.entities.SaveResult;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.entities.TitleActionSource;
import com.tandbergtv.watchpoint.pmm.entities.TitleStatus;
import com.tandbergtv.watchpoint.pmm.entities.event.TitleStatusUpdatedEvent;
import com.tandbergtv.watchpoint.pmm.entities.event.TitleUpdatedEvent;
import com.tandbergtv.watchpoint.pmm.title.ITitleManager;
import com.tandbergtv.watchpoint.pmm.title.ITitlePersistenceService;
import com.tandbergtv.watchpoint.pmm.title.ITitleService;
import com.tandbergtv.watchpoint.pmm.title.TitleActions;
import com.tandbergtv.watchpoint.pmm.title.TitleStatusService;
import com.tandbergtv.watchpoint.pmm.title.TitleWithPartialSpecKeysException;
import com.tandbergtv.watchpoint.pmm.title.autofill.AutoFillService;
import com.tandbergtv.watchpoint.pmm.title.conf.ISpecificationManager;
import com.tandbergtv.watchpoint.pmm.title.conf.Specification;
import com.tandbergtv.watchpoint.pmm.title.conf.UISpecification;
import com.tandbergtv.watchpoint.pmm.util.ProgressStatusHelper;
import com.tandbergtv.watchpoint.pmm.util.RulesEngineFacade;
import com.tandbergtv.workflow.core.event.DefaultMediator;
import com.tandbergtv.workflow.core.event.WorkflowEvent;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;

@Deprecated
public class TitleService
implements ITitleService {
    private static final String SERVICE_NAME = "Title Service";
    private static final Logger logger = Logger.getLogger(TitleService.class);
    private static TitleService _instance;
    private ITitlePersistenceService titlePersistenceService;
    private ITitleStatusService statusService;
    private ITitleManager titleManager;

    public static synchronized TitleService getInstance() {
        if (_instance == null) {
            _instance = new TitleService();
        }
        return _instance;
    }

    public String getServiceName() {
        return SERVICE_NAME;
    }

    public void start() {
        this.titlePersistenceService = this.getService(ITitlePersistenceService.class);
        this.statusService = new TitleStatusService();
        this.titleManager = this.getService(ITitleManager.class);
    }

    public void stop() {
    }

    public Title approve(long titleID) throws PMMException {
        logger.debug((Object)("Approving title: [" + titleID + "]"));
        Title title = this.titleManager.getForUpdate(Long.valueOf(titleID));
        if (title.getStatus() != TitleStatus.READY) {
            throw new PMMException("Title status is " + title.getStatus() + " | Has to be " + TitleStatus.READY + " to be approved");
        }
        title.setStatus(TitleStatus.APPROVED);
        this.save(title);
        return title;
    }

    public Title disapprove(long titleID) throws PMMException {
        logger.debug((Object)("Disapproving title: [" + titleID + "]"));
        Title title = this.titleManager.getForUpdate(Long.valueOf(titleID));
        if (title.getStatus() != TitleStatus.APPROVED) {
            throw new PMMException("Title status is " + title.getStatus() + " | Has to be " + TitleStatus.APPROVED + " to be unapproved");
        }
        title.setStatus(TitleStatus.READY);
        this.save(title);
        return title;
    }

    public List<Asset> findAssetsWithFileName(String fileURI, Asset asset) {
        ArrayList<Asset> result = new ArrayList<Asset>();
        for (Asset descAsset : asset.getAllAssets(false)) {
            Field field = descAsset.getFirstField(FieldName.URL.toString());
            if (field == null || field.getValue() == null || !this.getAssetFileName(field.getValue()).equals(fileURI)) continue;
            result.add(descAsset);
        }
        return result;
    }

    private String getAssetFileName(String fileURI) {
        int pathSeperaterIndex = fileURI.lastIndexOf("/");
        if (pathSeperaterIndex < 0) {
            return fileURI;
        }
        return fileURI.substring(pathSeperaterIndex + 1, fileURI.length());
    }

    private <T> T getService(Class<T> clazz) {
        return (T)ServiceRegistry.getDefault().lookup(clazz);
    }

    public Title getTitle(Long titleId) {
        return this.titleManager.get(titleId);
    }

    public Title getTitleForUpdate(Long titleId) {
        return this.titleManager.getForUpdate(titleId);
    }

    public Title getTitleByAssetId(Long rootAssetId) {
        return this.titleManager.get(this.getTitleIdByAssetId(rootAssetId));
    }

    public Title getTitleForUpdateByAssetId(Long rootAssetId) {
        return this.titleManager.getForUpdate(this.getTitleIdByAssetId(rootAssetId));
    }

    private Long getTitleIdByAssetId(Long rootAssetId) {
        Long titleId = this.titleManager.getIDByAssetID(rootAssetId);
        if (titleId == null) {
            throw new NoTitleForAnAssetException("No title found with asset id: " + rootAssetId);
        }
        return titleId;
    }

    public Collection<Title> getTitle(Document metadata) {
        ISpecHandler specHandler;
        ISpecificationManager specManager = this.getService(ISpecificationManager.class);
        Specification specification = specManager.getSpecificationForDocument(metadata);
        ISpecHandler iSpecHandler = specHandler = specification != null ? specification.getSpecHandler() : null;
        if (specHandler == null) {
            throw new RuntimeException("Failed to identify a specification plugin. Check your license or the specification plugin");
        }
        ArrayList<Asset> matchingAssets = new ArrayList<Asset>();
        try {
            List identifiers = specHandler.getIdentifiers(metadata);
            if (identifiers != null) {
                for (IIdentifier identifier : identifiers) {
                    matchingAssets.add(identifier.getAsset());
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get matching Asset for the metadata document.", e);
        }
        ArrayList<Title> titles = new ArrayList<Title>();
        for (Asset a : matchingAssets) {
            titles.add(this.titleManager.get(this.getTitleIdByAssetId(a.getId())));
        }
        return titles;
    }

    @Transactional
    public Document getMetadata(Long titleId, String spec) throws MetadataException, SearchException, TranslationException, TitleWithPartialSpecKeysException {
        ServiceRegistry registry;
        ISpecificationManager specManager;
        Specification specification;
        ISpecHandler specHandler;
        Document result = null;
        Title t = this.titleManager.get(titleId);
        Asset groupAsset = t.getAsset();
        if (groupAsset != null && (specHandler = (specification = (specManager = (ISpecificationManager)(registry = ServiceRegistry.getDefault()).lookup(ISpecificationManager.class)).getSpecificationByName(spec)).getSpecHandler()) != null) {
            IIdentifier id = specHandler.extractId(groupAsset);
            Map ids = id.getSpecIdentifiers();
            for (Map.Entry entry : ids.entrySet()) {
                if (entry.getValue() != null && !((String)entry.getValue()).isEmpty()) continue;
                throw new TitleWithPartialSpecKeysException(titleId, ids);
            }
            result = specHandler.get(id);
        }
        return result;
    }

    @Transactional
    public void saveAsDraft(Title title) {
        title.setStatus(TitleStatus.DRAFT);
        if (title.getCreateDate() == null) {
            title.setCreateDate(new Date());
        }
        title.setLastModifiedTime(new Date());
        this.titlePersistenceService.save(title);
    }

    @Transactional
    public void save(Title title) {
        TitleStatus oldStatus = title.getStatus();
        ISpecificationManager specManager = this.getService(ISpecificationManager.class);
        UISpecification uiSpec = specManager.getUISpecification(UISpecification.Type.PACKAGE);
        ContentClass contentClass = null;
        IContentClassService ccService = this.getService(IContentClassService.class);
        try {
            contentClass = ccService.getContentClassById(title.getContentClassId().longValue());
        }
        catch (ContentClassPersistenceException ex) {
            throw new RuntimeException("Unable to get content class with id: " + title.getContentClassId(), ex);
        }
        if (contentClass == null) {
            throw new RuntimeException("Unable to get content class with id: " + title.getContentClassId());
        }
        AutoFillService autoFillService = new AutoFillService(uiSpec, contentClass, title);
        autoFillService.autoFill();
        this.statusService.updateTitleStatus(title, contentClass);
        if (title.getCreateDate() == null) {
            title.setCreateDate(new Date());
        }
        title.setLastModifiedTime(new Date());
        this.titlePersistenceService.save(title);
        TitleStatus newStatus = title.getStatus();
        if (newStatus != oldStatus) {
            TitleStatusUpdatedEvent event = new TitleStatusUpdatedEvent((Object)this, title, oldStatus, newStatus);
            DefaultMediator.getInstance().sendAsync((WorkflowEvent)event);
        }
        TitleUpdatedEvent titleUpdatedEvent = new TitleUpdatedEvent((Object)this, title);
        DefaultMediator.getInstance().sendAsync((WorkflowEvent)titleUpdatedEvent);
    }

    @Transactional
    public List<TitleValidationMessage> validate(Title title, boolean isDraft) throws TitleValidationException {
        return this.titleManager.validate(title, isDraft);
    }

    @Transactional
    public SaveResult create(Title title, String sourceComponentName, String sourceEntityName, String sourceId) throws TitleValidationException {
        TitleActionSource source = new TitleActionSource(sourceComponentName, sourceEntityName, sourceId);
        ISavedTitle savedTitle = this.titleManager.create(title, false, (ITitleActionSource)source);
        return new SaveResult(savedTitle.getTitle(), savedTitle.getValidationMessages());
    }

    @Transactional
    public SaveResult update(Title title, String sourceComponentName, String sourceEntityName, String sourceId) throws TitleValidationException {
        TitleActionSource source = new TitleActionSource(sourceComponentName, sourceEntityName, sourceId);
        ISavedTitle savedTitle = this.titleManager.update(title, false, (ITitleActionSource)source);
        return new SaveResult(savedTitle.getTitle(), savedTitle.getValidationMessages());
    }

    @Transactional
    public Title rollback(Long titleId, String version, String sourceComponentName, String sourceEntityName, String sourceId) throws MetadataException, SearchException, TranslationException, InvalidRevisionException, TitleValidationException {
        TitleActionSource source = new TitleActionSource(sourceComponentName, sourceEntityName, sourceId);
        ISavedTitle savedTitle = this.titleManager.rollback(titleId, version, false, (ITitleActionSource)source);
        return savedTitle.getTitle();
    }

    @Transactional
    public Title rollbackAndSaveAsDraft(Long titleId, String version, String sourceComponentName, String sourceEntityName, String sourceId) throws MetadataException, SearchException, TranslationException, InvalidRevisionException, TitleValidationException {
        TitleActionSource source = new TitleActionSource(sourceComponentName, sourceEntityName, sourceId);
        ISavedTitle savedTitle = this.titleManager.rollback(titleId, version, true, (ITitleActionSource)source);
        return savedTitle.getTitle();
    }

    @Transactional
    public Collection<Title> getCompleteTitles(List<Long> titleIds) {
        ArrayList<String> ids = new ArrayList<String>();
        for (long id : titleIds) {
            ids.add(String.valueOf(id));
        }
        PredicateRightValue prv = new PredicateRightValue("id", "", FieldType.PMM_TITLE, ids, LogicalOperator.IN, "integer", Boolean.valueOf(false));
        ITitleSearchService titleSearchService = (ITitleSearchService)ServiceRegistry.getDefault().lookup(ITitleSearchService.class);
        List titles = titleSearchService.search((ExpNode)new ExpValue((Predicate)prv));
        for (Title t : titles) {
            this.initTitleAsset(t);
        }
        return titles;
    }

    private void initTitleAsset(Title t) {
        logger.debug((Object)("Title[ " + t.getId() + "] = " + t));
        t.getAsset().loadCompleteTree();
        for (Field f : t.getAsset().getAllDescendantAssetFields()) {
            f.setParentAsset(new AssetUtil().unWrap(f.getParentAsset()));
        }
    }

    public SaveResult updateAndNotify(Title title, List<TitleActions> actions, boolean saveAsDraftIfValidationFails, String sourceComponentName, String sourceEntityName, String sourceId) throws TitleValidationException {
        SaveResult saveResult = null;
        try {
            saveResult = this.update(title, sourceComponentName, sourceEntityName, sourceId);
        }
        catch (TitleValidationException e) {
            if (saveAsDraftIfValidationFails) {
                TitleActionSource source = new TitleActionSource(sourceComponentName, sourceEntityName, sourceId);
                ISavedTitle savedTitle = this.titleManager.update(title, true, (ITitleActionSource)source);
                this.statusService.sendStatus(savedTitle.getTitle(), ProgressStatusHelper.VALIDATION_FAILURE, e.getMessage(), false, sourceComponentName, sourceEntityName, sourceId);
                saveResult = new SaveResult(savedTitle.getTitle(), savedTitle.getValidationMessages());
            }
            throw e;
        }
        if (actions.contains(TitleActions.TITLE_NATIONALIZED_ACTION)) {
            this.statusService.sendStatus(saveResult.getTitle(), ProgressStatusHelper.NORMALIZED, null, true, sourceComponentName, sourceEntityName, sourceId);
            RulesEngineFacade.sendNationalizedEvent(saveResult.getTitle());
        }
        return saveResult;
    }

    public void setLookupKey(File file, String value) {
        this.titleManager.setLookupKey(file, value);
    }
}

