/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title;

import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.content.contentclass.entities.ContentClass;
import com.tandbergtv.content.contentclass.entities.ContentClassAsset;
import com.tandbergtv.content.contentclass.entities.ContentClassMetadata;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.File;
import com.tandbergtv.watchpoint.pmm.core.ITitleStatusService;
import com.tandbergtv.watchpoint.pmm.core.ProgressManager;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.entities.TitleStatus;
import com.tandbergtv.watchpoint.pmm.schedule.search.IScheduleSearchService;
import com.tandbergtv.watchpoint.pmm.title.TitleUtil;
import com.tandbergtv.watchpoint.pmm.util.ProgressStatusHelper;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;

public class TitleStatusService
implements ITitleStatusService {
    private static final String CONTENT_MGMT_UI_GROUP = "com.ericsson.cms.contentmgmt.ui";
    private static final String FILENAME_VALIDATION = "ContentComponent.TitleView.FileNameValidation";
    private ProgressManager progressManager = ProgressManager.newInstance();

    @Transactional
    public void sendAssetReceivedStatus(Title rootTitle, String titleName, String sourceComponentName, String sourceEntityName, String sourceId) {
        IScheduleSearchService scheduleSearchService = (IScheduleSearchService)ServiceRegistry.getDefault().lookup(IScheduleSearchService.class);
        Long plannerId = scheduleSearchService.findEarliestUpcomingPlannerId(rootTitle);
        if (plannerId == null) {
            plannerId = scheduleSearchService.findPastPlannerId(rootTitle);
        }
        this.sendAssetReceivedStatus(rootTitle, titleName, plannerId, sourceComponentName, sourceEntityName, sourceId);
    }

    @Transactional
    public void sendAssetReceivedStatus(Title rootTitle, String titleName, Long plannerId, String sourceComponentName, String sourceEntityName, String sourceId) {
        String statusName = ProgressStatusHelper.getAssetReceivedStatusName(titleName);
        String statusValue = ProgressStatusHelper.getAssetReceivedStatusValue(titleName);
        if (statusName != null) {
            this.progressManager.updateStatus(rootTitle, plannerId, statusName, statusValue, true, sourceComponentName, sourceEntityName, sourceId);
        }
    }

    @Transactional
    public void sendMetadataReceivedStatus(Title rootTitle, String sourceComponentName, String sourceEntityName, String sourceId) {
        IScheduleSearchService scheduleSearchService = (IScheduleSearchService)ServiceRegistry.getDefault().lookup(IScheduleSearchService.class);
        Long plannerId = scheduleSearchService.findEarliestUpcomingPlannerId(rootTitle);
        if (plannerId == null) {
            plannerId = scheduleSearchService.findPastPlannerId(rootTitle);
        }
        this.sendMetadataReceivedStatus(rootTitle, plannerId, sourceComponentName, sourceEntityName, sourceId);
    }

    @Transactional
    public void sendMetadataReceivedStatus(Title rootTitle, Long plannerId, String sourceComponentName, String sourceEntityName, String sourceId) {
        String statusName = ProgressStatusHelper.getMetadataReceivedStatusName();
        String statusValue = ProgressStatusHelper.getMetadataReceivedValue();
        if (statusName != null) {
            this.progressManager.updateStatus(rootTitle, plannerId, statusName, statusValue, true, sourceComponentName, sourceEntityName, sourceId);
        }
    }

    @Transactional
    public void sendStatus(Title title, String statusName, String statusValue, boolean success, String sourceComponentName, String sourceEntityName, String sourceId) {
        IScheduleSearchService scheduleSearchService = (IScheduleSearchService)ServiceRegistry.getDefault().lookup(IScheduleSearchService.class);
        Long plannerId = scheduleSearchService.findEarliestUpcomingPlannerId(title);
        if (plannerId == null) {
            plannerId = scheduleSearchService.findPastPlannerId(title);
        }
        this.progressManager.updateStatus(title, plannerId, statusName, statusValue, success, sourceComponentName, sourceEntityName, sourceId);
    }

    @Transactional
    public void updateTitleStatus(Title rootTitle, ContentClass cc) {
        Asset rootAsset = rootTitle.getAsset();
        if (rootTitle.getStatus() == TitleStatus.APPROVED) {
            return;
        }
        if (this.containsValue(rootTitle.getExternalLocation())) {
            rootTitle.setStatus(TitleStatus.READY);
            return;
        }
        rootTitle.setStatus(TitleStatus.COMMITTED);
        if (rootAsset.getPath() == null) {
            Asset.setPaths((Asset)rootAsset, null);
        }
        for (Asset sectionAsset : rootAsset.getAllAssets(false)) {
            if (!this.requiresFile(sectionAsset, cc)) continue;
            if (TitleUtil.getFileName(sectionAsset) != null) {
                String assetURI = sectionAsset.getContentURI();
                File file = this.getOriginalFile(sectionAsset);
                if (file == null) {
                    return;
                }
                if (this.verifyFileURI(assetURI, file)) continue;
                return;
            }
            return;
        }
        rootTitle.setStatus(TitleStatus.READY);
    }

    private boolean requiresFile(Asset sectionAsset, ContentClass cc) {
        if (sectionAsset == null) {
            return false;
        }
        if (cc == null) {
            return false;
        }
        ContentClassMetadata meta = cc.getMetadata();
        if (meta == null) {
            return false;
        }
        String path = sectionAsset.getPath();
        ContentClassAsset ccAsset = meta.getAsset(path);
        if (ccAsset == null) {
            return false;
        }
        return ccAsset.isRequiresFile();
    }

    private boolean containsValue(String s) {
        return s != null && s.trim().length() > 0;
    }

    private File getOriginalFile(Asset asset) {
        List files = asset.getChildrenOfType(File.class);
        if (files != null) {
            for (File file : files) {
                if (!file.isOriginal()) continue;
                return file;
            }
        }
        return null;
    }

    private boolean verifyFileURI(String assetURI, File file) {
        String assetURIFileName;
        String fileName;
        Map progSettings = TitleUtil.getConfigurationService().getProperties(CONTENT_MGMT_UI_GROUP);
        boolean isFilenameValidation = Boolean.parseBoolean((String)progSettings.get(FILENAME_VALIDATION));
        return !isFilenameValidation || TitleUtil.compareFileNames(fileName = FilenameUtils.getName((String)file.getURL()), assetURIFileName = FilenameUtils.getName((String)assetURI));
    }
}

