/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title.conf.specs;

import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.schedule.ScheduleRuntimeException;
import com.tandbergtv.watchpoint.pmm.title.conf.IRightsManager;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class RightsManager
implements IRightsManager {
    private static String LICENSE_WINDOW_END = "/Fields/Rights/LicensingWindowEnd";

    @Transactional
    public void isLicensed(Title title, Date date) {
        ArrayList<String> assetTypes = new ArrayList<String>();
        assetTypes.add("PACKAGE");
        assetTypes.add("TITLE");
        List fields = title.getAsset().getAllFieldsForXpath(assetTypes, LICENSE_WINDOW_END);
        if (fields == null || fields.isEmpty()) {
            throw new ScheduleRuntimeException("License end date metadata field for selected title(s) is missing");
        }
        Date licEndDate = (Date)((Field)fields.iterator().next()).getTypedValue();
        if (licEndDate == null) {
            throw new ScheduleRuntimeException("License end date for selected title(s) is empty or invalid");
        }
        if (date.after(licEndDate)) {
            throw new ScheduleRuntimeException("License end date for selected title(s) should be after the schedule date.");
        }
    }
}

