/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title.copy;

import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.metadatamanager.IAssetCopyService;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.title.ITitleCopyService;
import com.tandbergtv.watchpoint.pmm.title.ITitleManager;
import com.tandbergtv.watchpoint.pmm.title.ITitlePersistenceService;
import com.tandbergtv.watchpoint.pmm.title.TitleCopyException;
import com.tandbergtv.watchpoint.pmm.title.copy.TitleCopier;
import com.tandbergtv.workflow.core.service.Service;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.util.ArrayList;
import java.util.Collection;

public class TitleCopyService
implements ITitleCopyService {
    private static final String SERVICE_NAME = "Title Copy Service";
    private final IAssetCopyService assetCopyService;
    private ITitleManager titleManager;
    private ITitlePersistenceService titlePersistenceService;

    public TitleCopyService(IAssetCopyService assetCopyService) {
        this.assetCopyService = assetCopyService;
    }

    @Transactional
    public Title createTitleCopy(long titleId, boolean referenceOriginal) throws TitleCopyException {
        Title title = this.titleManager.get(Long.valueOf(titleId));
        return this.createTitleCopy(title, referenceOriginal);
    }

    public Title createTitleCopy(Title title, boolean referenceOriginal) throws TitleCopyException {
        TitleCopier copier = new TitleCopier(this.assetCopyService);
        return copier.copyTitle(title, referenceOriginal);
    }

    @Transactional
    public Title overwriteTitleCopy(long titleCopyId) throws TitleCopyException {
        Title copy = this.titleManager.get(Long.valueOf(titleCopyId));
        if (!copy.isCopy()) {
            String msg = "Title[" + titleCopyId + "] is not a copy and cannot be overwritten.";
            throw new TitleCopyException(msg);
        }
        Title original = this.titleManager.get(copy.getOriginalId());
        TitleCopier copier = new TitleCopier(this.assetCopyService);
        copier.overwriteTitle(original, copy);
        return copy;
    }

    @Transactional
    public Collection<Title> getTitleCopies(long titleId) {
        ArrayList<Title> copyTitles = new ArrayList<Title>();
        Collection<Long> copyIDs = this.getTitleCopyIds(titleId);
        if (copyIDs != null) {
            for (Long copyTitleID : copyIDs) {
                copyTitles.add(this.titleManager.get(copyTitleID));
            }
        }
        return copyTitles;
    }

    @Transactional
    public Collection<Long> getTitleCopyIds(long titleId) {
        return this.titlePersistenceService.getCopyIds(Long.valueOf(titleId));
    }

    @Transactional
    public Title getOriginalTitle(long titleCopyId) {
        Long originalID = this.getOriginalTitleId(titleCopyId);
        return originalID != null ? this.titleManager.get(originalID) : null;
    }

    @Transactional
    public Long getOriginalTitleId(long titleCopyId) {
        return this.titlePersistenceService.getOriginalId(Long.valueOf(titleCopyId));
    }

    public String getServiceName() {
        return SERVICE_NAME;
    }

    public void start() {
        this.titleManager = this.getService(ITitleManager.class);
        this.titlePersistenceService = this.getService(ITitlePersistenceService.class);
    }

    public void stop() {
    }

    private <T extends Service> T getService(Class<T> serviceClass) {
        ServiceRegistry registry = ServiceRegistry.getDefault();
        return (T)((Service)registry.lookup(serviceClass));
    }
}

