/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title.license;

import com.tandbergtv.content.contentclass.entities.ContentClass;
import com.tandbergtv.content.contentclass.service.ContentClassPersistenceException;
import com.tandbergtv.content.contentclass.service.IContentClassService;
import com.tandbergtv.neptune.licensing.ILicenseManager;
import com.tandbergtv.neptune.licensing.InvalidLicenseException;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.watchpoint.pmm.title.license.LicenseFilter;
import com.tandbergtv.watchpoint.pmm.title.usagemonitor.LicenseMonitor;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import org.apache.log4j.Logger;

public class LicenseManager {
    private static final Logger logger = Logger.getLogger(LicenseManager.class);
    private static ILicenseManager licenseManager = null;
    private static LicenseMonitor usage = null;
    private static final String MAX_MASTER_TITLES = "master.titles";
    private static final String MAX_SITE_TITLES = "sites.titles";
    private static final String MAX_INGEST_RATE = "ingest.thruput";
    private static final String MAX_DISTRIBUTION_RATE = "dist.thruput";

    public static LicenseManager getInstance() {
        return SingletonHelper.INSTANCE;
    }

    private LicenseManager() {
        long start = System.currentTimeMillis();
        licenseManager = (ILicenseManager)InjectionUtil.injectInstance((String)"cms/LicenseManager/local", ILicenseManager.class);
        logger.debug((Object)("Time taken to lookup neptune license manager - time:" + (System.currentTimeMillis() - start)));
        usage = LicenseMonitor.getInstance();
    }

    private void canCreateMasterTitles() {
        long currMasterTitleCount = 0L;
        String maxCount = "0";
        try {
            currMasterTitleCount = usage.getMasterTitleCount();
            maxCount = licenseManager.getProperty(MAX_MASTER_TITLES);
        }
        catch (InvalidLicenseException ex) {
            throw new RuntimeException("Cannot create master or series titles." + ex.getMessage());
        }
        if (currMasterTitleCount == 0L) {
            return;
        }
        if (maxCount == null) {
            return;
        }
        long maxMasterTitleCount = Long.parseLong(maxCount);
        if (maxMasterTitleCount == 0L) {
            return;
        }
        if (currMasterTitleCount >= maxMasterTitleCount) {
            throw new RuntimeException("Cannot create master or series titles. Maximum License limit [" + maxMasterTitleCount + "] reached.");
        }
    }

    public void canCreateSiteTitles(LicenseFilter filter) {
        if (this.isSkipCheckLicense(filter)) {
            return;
        }
        this.canCreateSiteTitles();
    }

    private void canCreateSiteTitles() {
        long currSiteTitleCount = 0L;
        String maxCount = "0";
        try {
            currSiteTitleCount = usage.getSiteTitleCount();
            maxCount = licenseManager.getProperty(MAX_SITE_TITLES);
        }
        catch (InvalidLicenseException ex) {
            throw new RuntimeException("Cannot create site titles." + ex.getMessage());
        }
        if (currSiteTitleCount == 0L) {
            return;
        }
        if (maxCount == null) {
            return;
        }
        long maxSiteTitleCount = Long.parseLong(maxCount);
        if (maxSiteTitleCount == 0L) {
            return;
        }
        if (currSiteTitleCount >= maxSiteTitleCount) {
            throw new RuntimeException("Cannot create site titles. Maximum License limit [" + maxSiteTitleCount + "] reached.");
        }
    }

    public void canIngestMasterTitle(LicenseFilter filter) {
        if (this.isSkipCheckLicense(filter)) {
            return;
        }
        this.canCreateMasterTitles();
        this.canIngestMasterTitle();
    }

    private void canIngestMasterTitle() {
        long currIngestRate = 0L;
        String maxRate = "0";
        try {
            currIngestRate = usage.getIngestTitleCount();
            maxRate = licenseManager.getProperty(MAX_INGEST_RATE);
        }
        catch (InvalidLicenseException ex) {
            throw new RuntimeException("Cannot ingest title" + ex.getMessage());
        }
        if (currIngestRate == 0L) {
            return;
        }
        if (maxRate == null) {
            return;
        }
        long maxIngestRate = Long.parseLong(maxRate);
        if (maxIngestRate == 0L) {
            return;
        }
        if (currIngestRate >= maxIngestRate) {
            throw new RuntimeException("Maximum Ingest rate [" + maxIngestRate + "] reached.");
        }
    }

    public void canDistributeTitle(LicenseFilter filter) {
        if (this.isSkipCheckLicense(filter)) {
            return;
        }
        this.canDistributeTitle();
    }

    private void canDistributeTitle() {
        long currDistributionRate = 0L;
        String maxRate = "0";
        try {
            currDistributionRate = usage.getDistributionTitleCount();
            maxRate = licenseManager.getProperty(MAX_DISTRIBUTION_RATE);
        }
        catch (InvalidLicenseException ex) {
            throw new RuntimeException("Cannot distribute title" + ex.getMessage());
        }
        if (maxRate == null) {
            return;
        }
        long maxDistributionRate = Long.parseLong(maxRate);
        if (maxDistributionRate == 0L) {
            return;
        }
        if (currDistributionRate >= maxDistributionRate) {
            throw new RuntimeException("Maximum distribution rate [" + maxDistributionRate + "] reached.");
        }
    }

    private boolean isSkipCheckLicense(LicenseFilter filter) {
        return this.isSkipCheckLicenseByContentClassType(filter);
    }

    private boolean isSkipCheckLicenseByContentClassType(LicenseFilter filter) {
        Long contentClassId = filter.getContentClassId();
        IContentClassService contentClassService = (IContentClassService)ServiceRegistry.getDefault().lookup(IContentClassService.class);
        if (null == contentClassId) {
            String contentClassName = filter.getContentClassName();
            if (null == contentClassName) {
                return false;
            }
            try {
                contentClassId = contentClassService.getContentClassIdByName(contentClassName);
            }
            catch (ContentClassPersistenceException e) {
                logger.error((Object)new StringBuilder("Cannot get content class id by name from DB. Content class name: ").append(contentClassName), (Throwable)e);
            }
        }
        if (null == contentClassId) {
            return false;
        }
        ContentClass.Type type = null;
        try {
            type = contentClassService.getContentClassTypeById(contentClassId.longValue());
        }
        catch (ContentClassPersistenceException e) {
            logger.error((Object)new StringBuilder("Cannot get content class by id from DB. Content class id: ").append(contentClassId), (Throwable)e);
        }
        if (null == type) {
            return false;
        }
        for (ContentClass.Type contentClassType : LicenseFilter.CONTENT_CLASS_FILTER) {
            if (type != contentClassType) continue;
            return true;
        }
        return false;
    }

    private static class SingletonHelper {
        private static final LicenseManager INSTANCE = new LicenseManager();

        private SingletonHelper() {
        }
    }
}

