/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title.search;

import com.ericsson.cms.criteria.Predicate;
import com.tandbergtv.metadatamanager.util.Utils;
import com.tandbergtv.watchpoint.pmm.title.search.FlowerConditionBuilder;
import java.util.List;

public class FlowerStringConditionBuilder
extends FlowerConditionBuilder {
    public FlowerStringConditionBuilder(Predicate predicate) {
        super(predicate);
    }

    @Override
    protected String equal() {
        return this.simpleConditionHelper(" = ");
    }

    @Override
    protected String notEqual() {
        return this.simpleConditionHelper(" != ");
    }

    protected String simpleConditionHelper(String operator) {
        StringBuffer condition = new StringBuffer();
        condition.append("$field");
        condition.append(operator);
        condition.append(this.getICCRhsValue());
        return condition.toString();
    }

    private String getICCXpathTail() {
        if (this.predicate.getIgnoreCase()) {
            return "fn:upper-case($field)";
        }
        return "$field";
    }

    private String getICCRhsValue() {
        StringBuffer sb = new StringBuffer("\"");
        if (this.predicate.getIgnoreCase()) {
            sb.append(this.getRhsValue().toUpperCase());
        } else {
            sb.append(this.getRhsValue());
        }
        sb.append("\"");
        return sb.toString();
    }

    @Override
    protected String in() {
        List<String> values = this.getValues();
        if (values.size() == 0) {
            return "";
        }
        StringBuffer condition = new StringBuffer();
        condition.append("(");
        for (int i = 0; i < values.size(); ++i) {
            String rhsValue = "\"" + values.get(i) + "\"";
            if (i > 0) {
                condition.append(" or ");
            }
            condition.append("$field");
            condition.append("=");
            condition.append(rhsValue);
        }
        condition.append(")");
        return condition.toString();
    }

    @Override
    protected String notIn() {
        List<String> values = this.getValues();
        if (values.size() == 0) {
            return "";
        }
        StringBuffer condition = new StringBuffer();
        condition.append("(");
        for (int i = 0; i < values.size(); ++i) {
            String rhsValue = "\"" + values.get(i) + "\"";
            if (i > 0) {
                condition.append(" and ");
            }
            condition.append("$field");
            condition.append("!=");
            condition.append(rhsValue);
        }
        condition.append(")");
        return condition.toString();
    }

    @Override
    protected String contains() {
        StringBuffer condition = new StringBuffer();
        condition.append("ora:contains(");
        condition.append("$field");
        condition.append(", \"%");
        condition.append(Utils.encodeString((String)this.getRhsValue()));
        condition.append("%\") > 0");
        return condition.toString();
    }

    @Override
    protected String notContains() {
        StringBuffer condition = new StringBuffer();
        condition.append("ora:contains(");
        condition.append("$field");
        condition.append(", \"");
        condition.append(Utils.encodeString((String)this.getRhsValue()));
        condition.append("\") = 0");
        return condition.toString();
    }

    @Override
    protected String startsWith() {
        return this.getFuncCondition("fn:starts-with");
    }

    private String getFuncCondition(String function) {
        StringBuffer condition = new StringBuffer();
        condition.append(function);
        condition.append("(");
        condition.append(this.getICCXpathTail());
        condition.append(", ");
        condition.append(this.getICCRhsValue());
        condition.append(")");
        return condition.toString();
    }

    @Override
    protected String doesNotStartWith() {
        return "not(" + this.startsWith() + ")";
    }

    @Override
    protected String endsWith() {
        return this.getFuncCondition("fn:ends-with");
    }

    @Override
    protected String doesNotEndWith() {
        return "not(" + this.endsWith() + ")";
    }
}

